/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bd.business;

import java.util.HashMap;
import java.util.Map;
import kd.bos.dataentity.TypesContainer;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.instance.Instance;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.fi.bd.business.service.AccountAssignServiceImpl;
import kd.fi.bd.business.service.AccountHealthLogServiceImpl;
import kd.fi.bd.business.service.CashFlowItemServiceImpl;
import kd.fi.bd.business.service.SystemInfoServiceImpl;
import kd.fi.bd.business.service.account.AccountQueryServiceImpl;
import kd.fi.bd.business.service.accountrepair.impl.AccountAssistRepairServiceImpl;
import kd.fi.bd.interfaces.service.AccountHealthLogService;
import kd.fi.bd.interfaces.service.IAccountAssignService;
import kd.fi.bd.interfaces.service.IAccountAssistRepairService;
import kd.fi.bd.interfaces.service.IAccountQueryService;
import kd.fi.bd.interfaces.service.ICashFlowItemService;
import kd.fi.bd.interfaces.service.ISystemInfoService;

public class BDGLServiceFactory {
    private static Map<String, String> serviceMap = new HashMap<String, String>();
    private static Log LOG = LogFactory.getLog((String)"BDGLServiceFactory");
    private static final ThreadLocal<Map<String, Object>> serviceInstanceMap = new ThreadLocal();

    public static <T> T getService(Class<T> clazz) {
        String key = clazz.getSimpleName();
        return (T)(serviceInstanceMap.get() != null && serviceInstanceMap.get().containsKey(key) ? serviceInstanceMap.get().get(key) : BDGLServiceFactory.getService(key));
    }

    public static void putService(String serviceName, String serviceImpl) {
        serviceMap.put(serviceName, serviceImpl);
    }

    public static Object getService(String serviceName) {
        String className = serviceMap.get(serviceName);
        if (className == null) {
            String appName = Instance.getAppName();
            throw new RuntimeException(String.format(ResManager.loadKDString((String)"%1$s\u5bf9\u5e94\u7684\u670d\u52a1\u5b9e\u73b0\u5728%2$s\u672a\u627e\u5230\u3002", (String)"ServiceFactory_0", (String)"bos-core-api", (Object[])new Object[0]), serviceName, appName));
        }
        return TypesContainer.getOrRegisterSingletonInstance((String)className);
    }

    static {
        serviceMap.put(ISystemInfoService.class.getSimpleName(), SystemInfoServiceImpl.class.getName());
        serviceMap.put(IAccountAssignService.class.getSimpleName(), AccountAssignServiceImpl.class.getName());
        serviceMap.put(IAccountAssistRepairService.class.getSimpleName(), AccountAssistRepairServiceImpl.class.getName());
        serviceMap.put(AccountHealthLogService.class.getSimpleName(), AccountHealthLogServiceImpl.class.getName());
        serviceMap.put(ICashFlowItemService.class.getSimpleName(), CashFlowItemServiceImpl.class.getName());
        serviceMap.put(IAccountQueryService.class.getSimpleName(), AccountQueryServiceImpl.class.getName());
    }
}

