/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bd.business.dao;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.data.BusinessDataReader;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.utils.ArrayUtils;
import kd.bos.dataentity.utils.OrmUtils;
import kd.bos.orm.datamanager.DataEntityCacheManager;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import org.apache.commons.collections4.CollectionUtils;

public class DataLoaderPrivate<T> {
    private final IDataEntityType type;
    private final DataEntityCacheManager cacheManager;

    protected DataLoaderPrivate(Class<T> source) {
        this.type = OrmUtils.getDataEntityType(source);
        this.cacheManager = new DataEntityCacheManager(this.type);
    }

    protected T loadSingle(Object pk) {
        return this.load(new Object[]{pk}).get(pk);
    }

    protected <P> Map<P, T> load(P[] pks) {
        Set availPks = Arrays.stream(pks).filter(pk -> pk != null && !this.cacheManager.isNotExistPK(pk)).collect(Collectors.toSet());
        if (availPks.isEmpty()) {
            return Collections.emptyMap();
        }
        Map result = this.cacheManager.get(availPks.toArray());
        Collection notFoundPks = CollectionUtils.subtract(availPks, result.keySet());
        if (notFoundPks.isEmpty()) {
            return result;
        }
        Object[] newDatas = BusinessDataReader.load((Object[])notFoundPks.toArray(), (IDataEntityType)this.type);
        if (ArrayUtils.isNotEmpty((Object[])newDatas)) {
            this.cacheManager.put(newDatas);
        }
        for (Object newData : newDatas) {
            Object newDataPk = this.type.getPrimaryKey().getValue(newData);
            result.put(newDataPk, newData);
            notFoundPks.remove(newDataPk);
        }
        if (!notFoundPks.isEmpty()) {
            this.cacheManager.putNotExistPKs(notFoundPks.toArray());
        }
        return result;
    }

    protected List<T> load(QFilter[] qFilters, String entityName, String orderBys, int top) {
        Object[] cachePks = this.cacheManager.getCachePks(qFilters);
        if (cachePks != null) {
            return new ArrayList<T>(this.load(cachePks).values());
        }
        Object[] queryPks = QueryServiceHelper.queryPrimaryKeys((String)entityName, (QFilter[])qFilters, (String)orderBys, (int)top).toArray();
        this.cacheManager.putCachePks(qFilters, queryPks);
        return new ArrayList<T>(this.load(queryPks).values());
    }
}

