/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bd.business.service;

import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.SqlBuilder;
import kd.bos.exception.BosErrorCode;
import kd.bos.exception.KDException;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.fi.bd.interfaces.service.ICashflowItemUseRelationService;
import kd.fi.bd.util.AccountVersionUtil;
import kd.fi.bd.util.BDUtil;

public class CashflowItemUseRelationServiceImpl
implements ICashflowItemUseRelationService {
    @Override
    public Map<Long, Long> getAllSubCfIncludeAssign(Long id, String longNumber, List<Long> orgIds, boolean isOnlyLeaf) {
        HashMap<Long, Long> id2Masterid = new HashMap<Long, Long>(16);
        if (orgIds.isEmpty()) {
            return id2Masterid;
        }
        QFilter qnumber = new QFilter("longnumber", "like", (Object)(longNumber + "%"));
        List allCfItemIds = QueryServiceHelper.queryPrimaryKeys((String)"gl_cashflowitem", (QFilter[])new QFilter[]{qnumber}, null, (int)-1);
        allCfItemIds.remove(id);
        if (allCfItemIds.isEmpty()) {
            return id2Masterid;
        }
        SqlBuilder sql = new SqlBuilder();
        sql.append("SELECT a.fdataid id FROM t_gl_cashflowitemusereg a LEFT JOIN t_gl_cashflowitemexc b ON (a.fdataid = b.fdataid AND a.fcreateorgid=b.fcreateorgid AND a.fuseorgid=b.fuseorgid) WHERE b.fdataid IS NULL", new Object[0]);
        sql.appendIn(" AND a.fdataid ", allCfItemIds);
        sql.appendIn(" AND a.fuseorgid ", orgIds.toArray(new Object[0]));
        List assignidList = (List)DB.query((DBRoute)DBRoute.of((String)"gl"), (SqlBuilder)sql, rs -> {
            ArrayList<Long> list = new ArrayList<Long>(16);
            try {
                while (rs.next()) {
                    list.add(rs.getLong("id"));
                }
            }
            catch (SQLException e) {
                throw new KDException((Throwable)e, BosErrorCode.sQL, new Object[]{String.format("Error:%s", e.getMessage())});
            }
            return list;
        });
        QFilter qorg = new QFilter("createorg", "in", orgIds);
        QFilter qown = new QFilter("id", "!=", (Object)id);
        List ids = QueryServiceHelper.queryPrimaryKeys((String)"gl_cashflowitem", (QFilter[])new QFilter[]{qorg, qnumber, qown}, null, (int)-1);
        ids.addAll(assignidList);
        ArrayList<QFilter> qFilters = new ArrayList<QFilter>(2);
        qFilters.add(new QFilter("id", "in", (Object)ids));
        if (isOnlyLeaf) {
            qFilters.add(new QFilter("isleaf", "=", (Object)true));
        }
        try (DataSet ds = QueryServiceHelper.queryDataSet((String)"getAllSubCfIncludeAssign", (String)"gl_cashflowitem", (String)"id,masterid", (QFilter[])qFilters.toArray(new QFilter[0]), null);){
            for (Row row : ds) {
                id2Masterid.put(row.getLong("id"), row.getLong("masterid"));
            }
        }
        return id2Masterid;
    }

    @Override
    public Map<String, Set<Long>> queryExcDataId(long useOrgId, String[] numbers) {
        HashMap<String, Set<Long>> useOrgExcdatas = new HashMap<String, Set<Long>>(16);
        SqlBuilder sqlBuilder = new SqlBuilder();
        sqlBuilder.append(" select acct.fnumber, exc.fdataid fdataid from t_gl_cashflowitemexc exc ", new Object[0]);
        sqlBuilder.append(" left join t_gl_cashflowitem acct on exc.fdataid=acct.fid  ", new Object[0]);
        sqlBuilder.append(" where exc.fuseorgid = ? ", new Object[]{useOrgId});
        sqlBuilder.appendIn(" and acct.fnumber ", (Object[])numbers);
        try (DataSet dataSet = DB.queryDataSet((String)"assignAllOldVersionAccts", (DBRoute)DBRoute.of((String)"gl"), (SqlBuilder)sqlBuilder);){
            for (Row row : dataSet) {
                useOrgExcdatas.computeIfAbsent(row.getString("fnumber"), k -> new HashSet()).add(row.getLong("fdataid"));
            }
        }
        return useOrgExcdatas;
    }

    @Override
    public DataSet queryExcDataIdByNumber(long useOrgId, List<Object> numbers) {
        SqlBuilder sqlBuilder = new SqlBuilder();
        sqlBuilder.append(" select a.FNUMBER, exc.FDATAID,exc.FCREATEORGID,exc.FUSEORGID ", new Object[0]);
        sqlBuilder.append(" from  t_gl_cashflowitemexc exc ", new Object[0]);
        sqlBuilder.append(" inner join T_GL_CASHFLOWITEM a ON exc.fdataid=a.fid ", new Object[0]);
        sqlBuilder.append(" where exc.FUSEORGID = ? ", new Object[]{useOrgId});
        sqlBuilder.appendIn(" and fnumber ", numbers);
        return DB.queryDataSet((String)"AssignUtil.findCashFlowItemsByCreateOrgId123123", (DBRoute)DBRoute.of((String)"gl"), (SqlBuilder)sqlBuilder);
    }

    @Override
    public Set<Long> queryIndivisionOrgIds(long itemId, List<Long> orgIds) {
        SqlBuilder sql = new SqlBuilder();
        sql.append("select fuseorgid from t_gl_cashflowitemexc ", new Object[0]);
        sql.append(" WHERE fdataid = ?", new Object[]{itemId});
        if (orgIds != null && !orgIds.isEmpty()) {
            sql.appendIn(" AND fuseorgid ", new ArrayList<Long>(orgIds));
        }
        HashSet<Long> customizedOrgIds = new HashSet<Long>();
        try (DataSet dt = DB.queryDataSet((String)CashflowItemUseRelationServiceImpl.class.getName(), (DBRoute)DBRoute.of((String)"gl"), (SqlBuilder)sql);){
            for (Row row : dt) {
                customizedOrgIds.add(row.getLong("fuseorgid"));
            }
        }
        return customizedOrgIds;
    }

    @Override
    public Set<Long> queryAssignOrgIds(long itemId) {
        StringBuilder sql = new StringBuilder();
        sql.append("select fuseorgid from t_gl_cashflowitemusereg ");
        sql.append(" WHERE fdataid = ").append(itemId);
        sql.append(" AND fcreateorgid != fuseorgid ");
        HashSet<Long> assignOrgIds = new HashSet<Long>();
        try (DataSet dt = DB.queryDataSet((String)CashflowItemUseRelationServiceImpl.class.getName(), (DBRoute)DBRoute.of((String)"gl"), (String)sql.toString());){
            for (Row row : dt) {
                assignOrgIds.add(row.getLong("fuseorgid"));
            }
        }
        return assignOrgIds;
    }

    @Override
    public Map<Long, Set<Long>> queryAssignRelationByMid(long masterId, List<Object> useOrgIds) {
        SqlBuilder sql = new SqlBuilder();
        sql.append("SELECT u.fdataid id, u.fuseorgid FROM t_gl_cashflowitemusereg AS u", new Object[0]);
        sql.append("INNER JOIN t_gl_cashflowitem AS c ON u.fdataid = c.fid WHERE ", new Object[0]);
        sql.append(" c.fmasterid = ?", new Object[]{masterId});
        sql.appendIn(" AND u.fuseorgid ", useOrgIds);
        HashMap<Long, Set<Long>> accOrgRelation = new HashMap<Long, Set<Long>>(8);
        try (DataSet dataSet = DB.queryDataSet((String)CashflowItemUseRelationServiceImpl.class.getName(), (DBRoute)DBRoute.of((String)"gl"), (SqlBuilder)sql);){
            for (Row row : dataSet) {
                accOrgRelation.computeIfAbsent(row.getLong("id"), k -> new HashSet()).add(row.getLong("fuseorgid"));
            }
        }
        return accOrgRelation;
    }

    @Override
    public DataSet queryAssignDataByNumbers(long userOrgId, List<Object> numbers) {
        SqlBuilder sqlBuilder = new SqlBuilder();
        sqlBuilder.append(" select a.fid,a.fmasterid,a.fparentid,a.fnumber,a.fcreateOrgId,a.fctrlstrategy,a.fenddate, ", new Object[0]);
        sqlBuilder.append(" reg.fuseorgid ", new Object[0]);
        sqlBuilder.append(" from  t_gl_cashflowitemusereg reg ", new Object[0]);
        sqlBuilder.append(" inner join t_gl_cashflowitem a ON reg.fdataid=a.fid ", new Object[0]);
        sqlBuilder.append(" where reg.FUSEORGID = ? ", new Object[]{userOrgId});
        sqlBuilder.appendIn(" and a.fnumber ", numbers);
        return DB.queryDataSet((String)"AssignUtil.findCashFlowItemsByCreateOrgId123123", (DBRoute)DBRoute.of((String)"gl"), (SqlBuilder)sqlBuilder);
    }

    @Override
    public Map<String, Set<Long>> queryAssignDataId(long useOrgId, String[] numbers) {
        SqlBuilder sqlBuilder = new SqlBuilder();
        sqlBuilder.append(" select a.fnumber, reg.fdataid fdataid ", new Object[0]);
        sqlBuilder.append(" from t_gl_cashflowitemUseReg reg ", new Object[0]);
        sqlBuilder.append(" left join t_gl_cashflowitem a on reg.FDATAID = a.fid ", new Object[0]);
        sqlBuilder.append(" where reg.fuseorgid = ? ", new Object[]{useOrgId});
        sqlBuilder.appendIn(" and a.fnumber ", (Object[])numbers);
        HashMap<String, Set<Long>> assignOrgUseregDatas = new HashMap<String, Set<Long>>();
        try (DataSet dataSet = DB.queryDataSet((String)"CashflowItemUseRelationServiceImpl.queryAssignDataId", (DBRoute)DBRoute.of((String)"gl"), (SqlBuilder)sqlBuilder);){
            for (Row row : dataSet) {
                assignOrgUseregDatas.computeIfAbsent(row.getString("fnumber"), k -> new HashSet()).add(row.getLong("fdataid"));
            }
        }
        return assignOrgUseregDatas;
    }

    @Override
    public void writeUseRange(List<Object[]> excParams, List<Object[]> useRegParams) {
        String insertExcSql = "insert into t_gl_cashflowitemexc(fdataid,fcreateorgid,fuseorgid) values(?,?,?)";
        if (excParams != null && !excParams.isEmpty()) {
            DB.executeBatch((DBRoute)DBRoute.of((String)"gl"), (String)"delete from t_gl_cashflowitemexc where fdataid = ? and fcreateorgid = ? and fuseorgid = ?", excParams);
            DB.executeBatch((DBRoute)DBRoute.of((String)"gl"), (String)insertExcSql, excParams);
        }
        String insertUseRegSql = "insert into t_gl_cashflowitemusereg(fuseorgid,fdataid,fcreateorgid,fadminorgid,fctrlstrategy,fisassign,fassignorgid) values(?,?,?,?,?,?,?)";
        if (useRegParams != null && !useRegParams.isEmpty()) {
            ArrayList<Object[]> delParams = new ArrayList<Object[]>(useRegParams.size());
            for (Object[] param : useRegParams) {
                delParams.add(new Object[]{param[1], param[2], param[0]});
            }
            DB.executeBatch((DBRoute)DBRoute.of((String)"gl"), (String)"delete from t_gl_cashflowitemusereg where fdataid = ? and fcreateorgid = ? and fuseorgid = ?", delParams);
            DB.executeBatch((DBRoute)DBRoute.of((String)"gl"), (String)insertUseRegSql, useRegParams);
        }
        CashflowItemUseRelationServiceImpl.refreshBaseDataUseRange(excParams, useRegParams);
    }

    private static void refreshBaseDataUseRange(List<Object[]> excParams, List<Object[]> useRegParams) {
        if (excParams != null && !excParams.isEmpty()) {
            ArrayList<Object[]> deleteRParams = new ArrayList<Object[]>(excParams.size());
            for (Object[] param : excParams) {
                deleteRParams.add(new Object[]{param[0], param[2]});
            }
            DB.executeBatch((DBRoute)DBRoute.of((String)"gl"), (String)"delete from t_gl_cashflowitem_u where fdataid = ? and fuseorgid = ?", deleteRParams);
        }
        if (useRegParams != null && !useRegParams.isEmpty()) {
            ArrayList<Object[]> insertRParams = new ArrayList<Object[]>(useRegParams.size());
            for (Object[] param : useRegParams) {
                boolean containsExc;
                if (excParams != null && !excParams.isEmpty() && (containsExc = excParams.stream().anyMatch(excParam -> ((Long)excParam[0]).compareTo((Long)param[1]) == 0 && ((Long)excParam[2]).compareTo((Long)param[0]) == 0))) continue;
                insertRParams.add(new Object[]{param[1], param[0]});
            }
            if (!insertRParams.isEmpty()) {
                DB.executeBatch((DBRoute)DBRoute.of((String)"gl"), (String)"delete from t_gl_cashflowitem_u where fdataid = ? and fuseorgid = ?", insertRParams);
                DB.executeBatch((DBRoute)DBRoute.of((String)"gl"), (String)"insert into t_gl_cashflowitem_u(fdataid,fuseorgid) values(?,?)", insertRParams);
            }
        }
    }

    @Override
    public void deleteUseRange(List<Object[]> params) {
        if (params != null && !params.isEmpty()) {
            String deleteUseRangeSql = "delete from t_gl_cashflowitemusereg where fdataid = ? and fuseorgid = ?";
            DB.executeBatch((DBRoute)DBRoute.of((String)"gl"), (String)deleteUseRangeSql, params);
            deleteUseRangeSql = "DELETE from t_gl_cashflowitemusereg  where FDataID in(SELECT fid from t_gl_cashflowitem where fid <> fmasterid  and fmasterid = ?  and fcreateorgid = ? ) ";
            DB.executeBatch((DBRoute)DBRoute.of((String)"gl"), (String)deleteUseRangeSql, params);
            deleteUseRangeSql = "delete from t_gl_cashflowitemExc where fdataid = ? and fuseorgid = ?";
            DB.executeBatch((DBRoute)DBRoute.of((String)"gl"), (String)deleteUseRangeSql, params);
            deleteUseRangeSql = "DELETE from t_gl_cashflowitemExc  where FDataID in(SELECT fid from t_gl_cashflowitem where fid <> fmasterid  and fmasterid = ?  and fcreateorgid = ? ) ";
            DB.executeBatch((DBRoute)DBRoute.of((String)"gl"), (String)deleteUseRangeSql, params);
            deleteUseRangeSql = "delete from t_gl_cashflowitem_u where fdataid = ? and fuseorgid = ?";
            DB.executeBatch((DBRoute)DBRoute.of((String)"gl"), (String)deleteUseRangeSql, params);
        }
    }

    @Override
    public Optional<DynamicObject> findPreVersion(long curOrgId, String number) {
        SqlBuilder sql = new SqlBuilder();
        sql.append("select r.fcreateorgid,r.fdataid from t_gl_cashflowitemusereg as r inner join t_gl_cashflowitem as c on r.fdataid = c.fid ", new Object[0]);
        sql.append(" where r.fuseorgid = ?", new Object[]{curOrgId});
        sql.append(" and c.fnumber = ?", new Object[]{number});
        sql.append(" order by c.fstartdate asc ", new Object[0]);
        HashMap<Long, Long> assignOrgVersionMap = new HashMap<Long, Long>(8);
        DataSet dt = DB.queryDataSet((String)AccountVersionUtil.class.getName(), (DBRoute)DBRoute.of((String)"gl"), (SqlBuilder)sql);
        Object object = null;
        try {
            while (dt.hasNext()) {
                Row row = dt.next();
                long assignOrgId = row.getLong("fcreateorgid");
                long versionAccId = row.getLong("fdataid");
                assignOrgVersionMap.put(assignOrgId, versionAccId);
            }
        }
        catch (Throwable row) {
            object = row;
            throw row;
        }
        finally {
            if (dt != null) {
                if (object != null) {
                    try {
                        dt.close();
                    }
                    catch (Throwable row) {
                        ((Throwable)object).addSuppressed(row);
                    }
                } else {
                    dt.close();
                }
            }
        }
        if (!assignOrgVersionMap.isEmpty()) {
            List<Long> parentOrgIds = BDUtil.getAllSuperiorOrgIds(curOrgId, false);
            for (Long pOrgId : parentOrgIds) {
                if (!Objects.nonNull(assignOrgVersionMap.get(pOrgId))) continue;
                long lastVersionId = (Long)assignOrgVersionMap.get(pOrgId);
                return Optional.of(BusinessDataServiceHelper.loadSingle((Object)lastVersionId, (String)"gl_cashflowitem"));
            }
        }
        return Optional.empty();
    }

    @Override
    public Set<Long> queryAssignDataIds(long useOrgId, Set<Long> itemIds) {
        SqlBuilder sql = new SqlBuilder();
        sql.appendIn("select fdataid from t_gl_cashflowitemusereg where fdataid", itemIds.toArray());
        sql.append("and fuseorgid = ?", new Object[]{useOrgId});
        HashSet<Long> result = new HashSet<Long>(10);
        try (DataSet dt = DB.queryDataSet((String)this.getClass().getName(), (DBRoute)DBRoute.of((String)"gl"), (SqlBuilder)sql);){
            for (Row row : dt) {
                result.add(row.getLong("fdataid"));
            }
        }
        return result;
    }

    @Override
    public Set<Long> queryExcnDataIds(long createOrgId, Set<Long> itemIds) {
        SqlBuilder sql = new SqlBuilder();
        sql.appendIn("select fdataid id from t_gl_cashflowitemexc where fdataid", itemIds.toArray());
        sql.append("and fcreateorgid = ?", new Object[]{createOrgId});
        HashSet<Long> result = new HashSet<Long>(10);
        try (DataSet dt = DB.queryDataSet((String)this.getClass().getName(), (DBRoute)DBRoute.of((String)"gl"), (SqlBuilder)sql);){
            for (Row row : dt) {
                result.add(row.getLong("id"));
            }
        }
        return result;
    }
}

