/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bd.business.service;

import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.orm.datamanager.DataEntityCacheManager;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.org.OrgUnitServiceHelper;

public class ExtOrgService {
    private static final String ORG_STRUCTURE = "bos_org_structure";

    public static List<Long> getAllSuperiorOrgs(String viewType, Long orgId, boolean includeSelf) {
        List<Long> result;
        DataEntityCacheManager cacheManager = new DataEntityCacheManager((IDataEntityType)EntityMetadataCache.getDataEntityType((String)ORG_STRUCTURE));
        QFilter fakeQFilter = QFilter.of((String)"getAllSuperiorOrgs = true and viewType = ? and orgId = ?", (Object[])new Object[]{viewType, orgId});
        Object[] cachePks = cacheManager.getCachePks(new QFilter[]{fakeQFilter});
        if (cachePks != null) {
            result = Arrays.stream(cachePks).map(Long.class::cast).collect(Collectors.toList());
        } else {
            result = OrgUnitServiceHelper.getAllSuperiorOrgs((String)viewType, (long)orgId);
            cacheManager.putCachePks(new QFilter[]{fakeQFilter}, (Object[])result.toArray(new Long[0]));
        }
        if (includeSelf) {
            result.add(orgId);
        }
        return result;
    }
}

