/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bd.business.service;

import com.google.common.collect.HashBasedTable;
import com.google.common.collect.Table;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.exception.KDBizException;
import kd.bos.ext.fi.ai.dap.cache.CacheKeyPrefix;
import kd.bos.ext.fi.ai.dap.cache.LocalCacheHelper;
import kd.bos.ext.fi.ai.dap.cache.LocalCacheKey;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.util.CollectionUtils;
import kd.fi.bd.business.service.LocalCurrencyConfigService;
import kd.fi.bd.business.vo.AccountBookMCVO;
import kd.fi.bd.business.vo.LocalCurrencyConfigVO;
import kd.fi.bd.enums.ConversionMethod;
import kd.fi.bd.exception.MCErrorCodes;
import kd.fi.bd.util.DebugTrace;
import org.apache.commons.collections4.list.UnmodifiableList;

public class LocalCurrencyQueryService {
    public static final String ENABLE_GROUP_LOCAL_CURRENCY = "enablegrplocalcur";
    private static final String ALL_MUL_LOCAL_CURRENCY_KEY = "allMulLocalCurrency";
    private static final Log LOG = LogFactory.getLog(LocalCurrencyQueryService.class);

    public static Map<Long, AccountBookMCVO> batchQueryEnabledCurDetails(Collection<Long> orgIds, long bookTypeId) {
        if (CollectionUtils.isEmpty(orgIds)) {
            return Collections.EMPTY_MAP;
        }
        HashMap<Long, AccountBookMCVO> result = new HashMap<Long, AccountBookMCVO>(orgIds.size());
        Table<Long, Long, AccountBookMCVO> allMCAccountBooks = LocalCurrencyQueryService.getAllMulLocalCurrency();
        orgIds.stream().forEach(orgId -> {
            AccountBookMCVO accountBookMCVO = (AccountBookMCVO)allMCAccountBooks.get(orgId, (Object)bookTypeId);
            if (Objects.nonNull(accountBookMCVO)) {
                result.put((Long)orgId, accountBookMCVO);
            }
        });
        return result;
    }

    public static Set<Long> queryUsedCurrency(Collection<Long> orgIds, long bookTypeId) {
        Set<AccountBookMCVO.Info> usedInfos = LocalCurrencyQueryService.queryDistinctUsedInfos(orgIds, bookTypeId);
        return usedInfos.stream().map(AccountBookMCVO.Info::getCurrencyId).collect(Collectors.toSet());
    }

    public static Set<Long> queryUsedExtRateTables(Collection<Long> orgIds, long bookTypeId) {
        Set<AccountBookMCVO.Info> usedInfos = LocalCurrencyQueryService.queryDistinctUsedInfos(orgIds, bookTypeId);
        return usedInfos.stream().map(AccountBookMCVO.Info::getExRateTableId).collect(Collectors.toSet());
    }

    private static Set<AccountBookMCVO.Info> queryDistinctUsedInfos(Collection<Long> orgIds, long bookTypeId) {
        if (CollectionUtils.isEmpty(orgIds)) {
            return Collections.EMPTY_SET;
        }
        HashSet<AccountBookMCVO.Info> allEnabledCurs = new HashSet<AccountBookMCVO.Info>(3);
        Table<Long, Long, AccountBookMCVO> allMCAccountBooks = LocalCurrencyQueryService.getAllMulLocalCurrency();
        orgIds.stream().forEach(orgId -> {
            AccountBookMCVO accountBookMCVO = (AccountBookMCVO)allMCAccountBooks.get(orgId, (Object)bookTypeId);
            if (Objects.nonNull(accountBookMCVO)) {
                Map<String, AccountBookMCVO.Info> enabledCurs = accountBookMCVO.getCurrencyInfoMap();
                allEnabledCurs.addAll(enabledCurs.values());
            }
        });
        return allEnabledCurs;
    }

    public static Table<Long, Long, Map<String, AccountBookMCVO.Info>> batchQueryMulCurrency(Collection<Long> orgIds, long bookTypeId) {
        HashBasedTable mulCurrencyTable = HashBasedTable.create();
        if (CollectionUtils.isEmpty(orgIds)) {
            return mulCurrencyTable;
        }
        Table<Long, Long, AccountBookMCVO> allMCAccountBooks = LocalCurrencyQueryService.getAllMulLocalCurrency();
        orgIds.stream().forEach(arg_0 -> LocalCurrencyQueryService.lambda$batchQueryMulCurrency$2(allMCAccountBooks, bookTypeId, (Table)mulCurrencyTable, arg_0));
        return mulCurrencyTable;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static Table<Long, Long, AccountBookMCVO> getAllMulLocalCurrency() {
        LocalCacheKey cacheKey = LocalCurrencyQueryService.buildCacheKey(ALL_MUL_LOCAL_CURRENCY_KEY);
        Table accountBookMCVOTable = (Table)LocalCacheHelper.get((LocalCacheKey)cacheKey, Table.class);
        if (!Objects.isNull(accountBookMCVOTable)) return accountBookMCVOTable;
        Class<LocalCurrencyQueryService> clazz = LocalCurrencyQueryService.class;
        synchronized (LocalCurrencyQueryService.class) {
            accountBookMCVOTable = (Table)LocalCacheHelper.get((LocalCacheKey)cacheKey, Table.class);
            if (!Objects.isNull(accountBookMCVOTable)) return accountBookMCVOTable;
            accountBookMCVOTable = HashBasedTable.create();
            UnmodifiableList<LocalCurrencyConfigVO> configVOList = LocalCurrencyConfigService.queryEnableCurrencies();
            if (!configVOList.isEmpty()) {
                if (!configVOList.stream().allMatch(LocalCurrencyConfigVO::validateSelf)) {
                    LOG.error("wrong config exists:" + configVOList.toString());
                    throw new KDBizException(MCErrorCodes.CONFIG_ERR, new Object[]{"config validate failed, please check log. "});
                }
                StringBuilder selectFields = new StringBuilder("org,bookstype, accountingsys.conversionmethod conversionmethod");
                for (Object configVO : configVOList) {
                    if ("gl_accountbook".equals(((LocalCurrencyConfigVO)configVO).getControlEntityId())) {
                        selectFields.append(",").append(((LocalCurrencyConfigVO)configVO).getCurrencyField());
                        selectFields.append(",").append(((LocalCurrencyConfigVO)configVO).getExRateField());
                        continue;
                    }
                    if (!"bd_accountingsys".equals(((LocalCurrencyConfigVO)configVO).getControlEntityId())) continue;
                    selectFields.append(",").append("accountingsys").append(".").append(((LocalCurrencyConfigVO)configVO).getCurrencyField()).append(" ").append("accountingsys").append(((LocalCurrencyConfigVO)configVO).getCurrencyField());
                    selectFields.append(",").append("accountingsys").append(".").append(((LocalCurrencyConfigVO)configVO).getExRateField()).append(" ").append("accountingsys").append(((LocalCurrencyConfigVO)configVO).getExRateField());
                }
                if (DebugTrace.enable()) {
                    LOG.info("query mullocales select fields:" + selectFields);
                }
                QFilter qFilter = null;
                for (LocalCurrencyConfigVO configVO : configVOList) {
                    QFilter orFilter;
                    if ("gl_accountbook".equals(configVO.getControlEntityId())) {
                        orFilter = new QFilter(configVO.getCurrencyField(), ">", (Object)0);
                    } else {
                        if (!"bd_accountingsys".equals(configVO.getControlEntityId())) throw new KDBizException(MCErrorCodes.NOT_IMPLEMENTS, new Object[]{"Not support :" + configVO.getControlEntityId()});
                        orFilter = new QFilter("accountingsys." + configVO.getCurrencyField(), ">", (Object)0);
                    }
                    qFilter = null == qFilter ? orFilter : qFilter.or(orFilter);
                }
                if (DebugTrace.enable()) {
                    LOG.info("query mullocales filters:" + qFilter);
                }
                DataSet ds = QueryServiceHelper.queryDataSet((String)"mullocalquery", (String)"gl_accountbook", (String)selectFields.toString(), (QFilter[])(qFilter == null ? null : qFilter.toArray()), null);
                while (ds.hasNext()) {
                    Row accountBook = ds.next();
                    AccountBookMCVO accountBookMCVO = LocalCurrencyQueryService.buildAccountBookMCVO(accountBook, configVOList);
                    accountBookMCVOTable.put((Object)accountBookMCVO.getOrgId(), (Object)accountBookMCVO.getBookTypeId(), (Object)accountBookMCVO);
                }
            }
            LocalCacheHelper.put((LocalCacheKey)cacheKey, (Object)accountBookMCVOTable);
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return accountBookMCVOTable;
        }
    }

    private static AccountBookMCVO buildAccountBookMCVO(Row accountBookRow, List<LocalCurrencyConfigVO> configVOList) {
        HashMap<String, AccountBookMCVO.Info> currencyInfoMap = new HashMap<String, AccountBookMCVO.Info>(8);
        for (LocalCurrencyConfigVO configVO : configVOList) {
            ConversionMethod conversionMethod;
            long exRateTableId;
            long currencyId;
            String number = configVO.getNumber();
            if ("gl_accountbook".equals(configVO.getControlEntityId())) {
                currencyId = accountBookRow.getLong(configVO.getCurrencyField());
                exRateTableId = accountBookRow.getLong(configVO.getExRateField());
                conversionMethod = ConversionMethod.ORIGINAL;
            } else if ("bd_accountingsys".equals(configVO.getControlEntityId())) {
                currencyId = accountBookRow.getLong("accountingsys" + configVO.getCurrencyField());
                exRateTableId = accountBookRow.getLong("accountingsys" + configVO.getExRateField());
                conversionMethod = ConversionMethod.getConversionMethodByValue(accountBookRow.getString("conversionmethod"));
            } else {
                throw new KDBizException(MCErrorCodes.NOT_IMPLEMENTS, new Object[]{"Not support :" + configVO.getControlEntityId()});
            }
            if (currencyId <= 0L && exRateTableId <= 0L) continue;
            AccountBookMCVO.Info info = new AccountBookMCVO.Info(currencyId, exRateTableId, conversionMethod);
            currencyInfoMap.put(number, info);
        }
        return new AccountBookMCVO(accountBookRow.getLong("org"), accountBookRow.getLong("bookstype"), currencyInfoMap);
    }

    private static LocalCacheKey buildCacheKey(String key) {
        return LocalCacheKey.getCacheKey((CacheKeyPrefix)CacheKeyPrefix.BASE_CURRENCY, (Object[])new Object[]{key});
    }

    public static void removeCache() {
        LocalCacheHelper.remove((LocalCacheKey)LocalCurrencyQueryService.buildCacheKey(ALL_MUL_LOCAL_CURRENCY_KEY));
    }

    private static /* synthetic */ void lambda$batchQueryMulCurrency$2(Table allMCAccountBooks, long bookTypeId, Table mulCurrencyTable, Long orgId) {
        AccountBookMCVO accountBookMCVO = (AccountBookMCVO)allMCAccountBooks.get((Object)orgId, (Object)bookTypeId);
        if (Objects.nonNull(accountBookMCVO)) {
            mulCurrencyTable.put((Object)orgId, (Object)bookTypeId, accountBookMCVO.getCurrencyInfoMap());
        }
    }
}

