/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bd.business.service.accountrepair;

import com.google.common.base.Preconditions;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.SqlBuilder;
import kd.bos.dlock.DLock;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.org.OrgUnitServiceHelper;
import kd.fi.bd.accounthealth.accountrepair.repair.AccountRepairContext;
import kd.fi.bd.accounthealth.impl.AccountRepairServiceImpl;
import kd.fi.bd.accounthealth.vo.AccountRepairResVO;
import kd.fi.bd.business.BDGLServiceFactory;
import kd.fi.bd.enums.AccountPropCategory;
import kd.fi.bd.interfaces.service.IAccountAssistRepairService;
import kd.fi.bd.util.AccountVersionUtil;
import kd.fi.bd.util.BDUtil;
import kd.fi.bd.util.BiTreeNode;
import kd.fi.bd.util.QFBuilder;
import kd.fi.bd.vo.AccountVO;
import kd.fi.bd.vo.AssistEntryVO;

public class AccountRepairCommonService {
    private static final Log LOGGER = LogFactory.getLog(AccountRepairCommonService.class);

    public static List<AccountRepairResVO> doRepair(AccountRepairContext ctx) {
        ArrayList<AccountRepairResVO> workOuterToExcelInfoList = new ArrayList<AccountRepairResVO>(8);
        Map<String, Set<Long>> firstNnumberToOrgs = ctx.getFirstNnumberToOrgs();
        for (Map.Entry<String, Set<Long>> firstNumberToOrg : firstNnumberToOrgs.entrySet()) {
            String firstNumber = firstNumberToOrg.getKey();
            String lockKey = ctx.getAccountTableId() + firstNumber;
            DLock lock = DLock.create((String)lockKey);
            Throwable throwable = null;
            try {
                if (lock.tryLock()) {
                    List<AccountRepairResVO> repairResult = AccountRepairCommonService.repair(ctx, firstNumberToOrg);
                    if (CollectionUtils.isEmpty(repairResult)) continue;
                    workOuterToExcelInfoList.addAll(repairResult);
                    continue;
                }
                throw new KDBizException(ResManager.loadKDString((String)"\u8be5\u79d1\u76ee\u8868\u6b63\u5728\u4fdd\u5b58\u76f8\u540c\u7f16\u7801\u7684\u79d1\u76ee\uff0c\u8bf7\u7a0d\u540e\u518d\u8bd5\u3002", (String)"AccountRepairServiceImpl_2", (String)"fi-bd-common", (Object[])new Object[0]));
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                if (lock == null) continue;
                if (throwable != null) {
                    try {
                        lock.close();
                    }
                    catch (Throwable throwable3) {
                        throwable.addSuppressed(throwable3);
                    }
                    continue;
                }
                lock.close();
            }
        }
        return workOuterToExcelInfoList;
    }

    protected static List<AccountRepairResVO> repair(AccountRepairContext ctx, Map.Entry<String, Set<Long>> firstNumberToOrg) {
        Set<Long> needRepairOrgIds = firstNumberToOrg.getValue();
        HashMap<Long, List<Long>> allSuperiorOrgMap = new HashMap(8);
        if (needRepairOrgIds.size() > 1) {
            allSuperiorOrgMap = OrgUnitServiceHelper.getAllSuperiorOrgs((String)"10", new ArrayList<Long>(needRepairOrgIds));
        }
        ArrayList<AccountRepairResVO> repairResult = new ArrayList<AccountRepairResVO>(8);
        String firstNumber = firstNumberToOrg.getKey();
        for (Long needRepairOrgId : needRepairOrgIds) {
            Set rootNumbers = (Set)ctx.getOrgFirstNumberToRootNumbers().get((Object)needRepairOrgId, (Object)firstNumber);
            if (CollectionUtils.isEmpty((Collection)rootNumbers)) continue;
            if (ctx.getRepairType().equals(AccountPropCategory.PROP.getType())) {
                AccountRepairServiceImpl accountRepairService = new AccountRepairServiceImpl();
                repairResult.addAll(accountRepairService.accountRepairForProp(ctx, needRepairOrgId, rootNumbers));
                continue;
            }
            if (!CollectionUtils.isEmpty(allSuperiorOrgMap) && !AccountRepairCommonService.isNeedRepair(ctx, needRepairOrgIds, allSuperiorOrgMap, firstNumber, needRepairOrgId) || !ctx.getRepairType().equals(AccountPropCategory.ASST.getType())) continue;
            IAccountAssistRepairService accountAssistRepairService = (IAccountAssistRepairService)BDGLServiceFactory.getService("IAccountAssistRepairService");
            repairResult.addAll(accountAssistRepairService.repairAssist(ctx, needRepairOrgId, rootNumbers));
        }
        return repairResult;
    }

    protected static boolean isNeedRepair(AccountRepairContext ctx, Set<Long> needRepairOrgIds, Map<Long, List<Long>> allSuperiorOrgMap, String firstNumber, Long needRepairOrgId) {
        List<Long> allSuperiorOrgs = allSuperiorOrgMap.get(needRepairOrgId);
        allSuperiorOrgs.retainAll(needRepairOrgIds);
        if (!CollectionUtils.isEmpty(allSuperiorOrgs)) {
            for (Long superOrg : allSuperiorOrgs) {
                Set superOrgRootNumbers = (Set)ctx.getOrgFirstNumberToRootNumbers().get((Object)superOrg, (Object)firstNumber);
                Set currOrgRootNumbers = (Set)ctx.getOrgFirstNumberToRootNumbers().get((Object)needRepairOrgId, (Object)firstNumber);
                if (CollectionUtils.isEmpty((Collection)superOrgRootNumbers)) continue;
                HashSet<String> noNeedRepairAccs = new HashSet<String>(8);
                for (String currOrgRootNumber : currOrgRootNumbers) {
                    for (String superOrgRootNumber : superOrgRootNumbers) {
                        if (!currOrgRootNumber.startsWith(superOrgRootNumber)) continue;
                        noNeedRepairAccs.add(currOrgRootNumber);
                    }
                }
                currOrgRootNumbers.removeAll(noNeedRepairAccs);
                if (!CollectionUtils.isEmpty((Collection)currOrgRootNumbers)) continue;
                return false;
            }
        }
        return true;
    }

    public static BiTreeNode<String, AccountVO> buildSubTreeByAccountNumber(long accountTableId, String accountNumber, String longnumber, List<Long> useOrgIdList) {
        HashMap<String, BiTreeNode<String, AccountVO>> accountNumIndexMap = new HashMap<String, BiTreeNode<String, AccountVO>>(8);
        BiTreeNode<String, AccountVO> rootNode = null;
        long tick = System.currentTimeMillis();
        QFBuilder globalBuilder = new QFBuilder();
        QFBuilder orgBuilder = new QFBuilder();
        QFilter accountTableIdFilter = new QFilter("accounttable", "=", (Object)accountTableId);
        QFilter endDateFilter = new QFilter("enddate", "=", (Object)AccountVersionUtil.getEndDate());
        QFilter longnumberFilter = new QFilter("longnumber", "like", (Object)(longnumber + "%"));
        globalBuilder.add(accountTableIdFilter).add(endDateFilter).add(longnumberFilter);
        orgBuilder.add(accountTableIdFilter).add(endDateFilter).add(longnumberFilter);
        if (useOrgIdList != null && !useOrgIdList.isEmpty()) {
            globalBuilder.add(new QFilter("ctrlstrategy", "=", (Object)"5"));
            orgBuilder.add(QFilter.sqlExpress((String)"id", (String)"in", (String)(" ( select fdataid from t_bd_account_u where fuseorgid in (" + StringUtils.join((Object[])useOrgIdList.toArray(), (String)",") + " ))")));
        }
        DataSet globalAccountDataSet = QueryServiceHelper.queryDataSet((String)BDUtil.class.getName(), (String)"bd_accountview", (String)"id, number, name, parent.number parentnumber, longnumber,level", (QFilter[])globalBuilder.toArray(), null);
        DataSet orgAccountDataSet = QueryServiceHelper.queryDataSet((String)BDUtil.class.getName(), (String)"bd_accountview", (String)"id, number, name, parent.number parentnumber,longnumber,level", (QFilter[])orgBuilder.toArray(), null);
        DataSet accountDataSet = globalAccountDataSet.union(orgAccountDataSet).select("id, number, name, parentnumber, longnumber, level").orderBy(new String[]{"level asc"});
        for (Row row : accountDataSet) {
            String number = row.getString("number");
            Integer level = row.getInteger("level");
            String name = row.getString("name");
            if (Objects.nonNull(accountNumIndexMap.get(number))) continue;
            if (Objects.isNull(rootNode)) {
                if (!accountNumber.equals(number)) continue;
                rootNode = new BiTreeNode<String, AccountVO>(number, new AccountVO(number, name, accountTableId, level));
                accountNumIndexMap.put(number, rootNode);
                continue;
            }
            String parentNumber = row.getString("parentnumber");
            if (!Objects.nonNull(parentNumber) || !accountNumIndexMap.containsKey(parentNumber)) continue;
            BiTreeNode parentNode = (BiTreeNode)accountNumIndexMap.get(parentNumber);
            Preconditions.checkState((boolean)Objects.nonNull(parentNode));
            BiTreeNode<String, AccountVO> accountNode = new BiTreeNode<String, AccountVO>(number, new AccountVO(number, name, accountTableId, level));
            accountNumIndexMap.put(number, accountNode);
            accountNode.setParent(parentNode);
        }
        LOGGER.info("kd.fi.bd.util.BDUtil.buildSubTreeByAccountNumber cost " + (System.currentTimeMillis() - tick));
        return rootNode;
    }

    public static Map<Long, Set<AssistEntryVO>> batchGetAssist(List<Long> accountIds) {
        if (accountIds.isEmpty()) {
            throw new KDBizException(ResManager.loadKDString((String)"\u7ec4\u7ec7\u6ca1\u6709\u79d1\u76ee\u7684\u4f7f\u7528\u6743\u9650\u3002", (String)"AccountRepairCommonService_1", (String)"fi-bd-common", (Object[])new Object[0]));
        }
        String selectFields = "fid id,fasstactitemid asstactitem ,fisrequire isrequire,fisdetail isdetail,fenaccheck enaccheck";
        SqlBuilder sqlBuilder = new SqlBuilder();
        sqlBuilder.append("select ", new Object[0]).append(selectFields, new Object[0]).append(" from t_bd_Accountasstactitem where ", new Object[0]);
        sqlBuilder.appendIn(" fid ", accountIds.toArray());
        HashMap<Long, Set<AssistEntryVO>> idToAssistMap = new HashMap<Long, Set<AssistEntryVO>>(8);
        try (DataSet data = DB.queryDataSet((String)"batchGetAssist#assist", (DBRoute)DBRoute.of((String)"fi"), (SqlBuilder)sqlBuilder);){
            while (data.hasNext()) {
                Row row = data.next();
                long id = row.getLong("id");
                Long asstactItemId = row.getLong("asstactitem");
                Boolean isRequire = row.getBoolean("isrequire");
                Boolean isDetail = row.getBoolean("isdetail");
                Boolean accheck = row.getBoolean("enaccheck");
                idToAssistMap.computeIfAbsent(id, k -> new HashSet(8)).add(new AssistEntryVO(asstactItemId, isRequire, isDetail, accheck));
            }
        }
        return idToAssistMap;
    }
}

