/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bd.business.service.cashitem;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.cache.ThreadCache;
import kd.bos.dataentity.entity.CloneUtils;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.IDataEntityBase;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.SqlBuilder;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.ORM;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.basedata.BaseDataServiceHelper;
import kd.bos.servicehelper.org.OrgUnitServiceHelper;
import kd.fi.bd.business.vo.PresetCashFlowItemRelation;
import kd.fi.bd.util.DebugTrace;

public class AccountCashFlowService {
    private static final Log LOG = LogFactory.getLog(AccountCashFlowService.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Map<Long, Set<PresetCashFlowItemRelation>> batchGetAccountCashItemRel(Set<Long> orgIdSet, long accountTableId) {
        long tick;
        HashMap<Long, Set<PresetCashFlowItemRelation>> relMap;
        block6: {
            relMap = new HashMap<Long, Set<PresetCashFlowItemRelation>>(8);
            tick = System.currentTimeMillis();
            try {
                ArrayList<Long> orgList = new ArrayList<Long>(orgIdSet);
                if (orgList.size() > 1000) {
                    int count = orgList.size() / 1000 + 1;
                    for (int i = 0; i < count; ++i) {
                        List<Long> batchOrg = orgList.subList(0, Math.min(orgList.size(), 1000));
                        Map<Long, Set<PresetCashFlowItemRelation>> presetCFRelationMap = AccountCashFlowService.batchGetAccountCashItemRel(batchOrg, accountTableId);
                        if (CollectionUtils.isEmpty(presetCFRelationMap)) continue;
                        relMap.putAll(presetCFRelationMap);
                    }
                    break block6;
                }
                Map<Long, Set<PresetCashFlowItemRelation>> presetCFRelationMap = AccountCashFlowService.batchGetAccountCashItemRel(orgList, accountTableId);
                if (CollectionUtils.isEmpty(presetCFRelationMap)) break block6;
                relMap.putAll(presetCFRelationMap);
            }
            catch (Throwable throwable) {
                if (DebugTrace.enable()) {
                    LOG.info("batchGetAccountCashItemRel_cost: {}, accTableId: {}, orgIds: {}", new Object[]{System.currentTimeMillis() - tick, accountTableId, orgIdSet});
                }
                throw throwable;
            }
        }
        if (DebugTrace.enable()) {
            LOG.info("batchGetAccountCashItemRel_cost: {}, accTableId: {}, orgIds: {}", new Object[]{System.currentTimeMillis() - tick, accountTableId, orgIdSet});
        }
        return relMap;
    }

    public static Map<Long, Set<PresetCashFlowItemRelation>> batchGetAccountCashItemRel(List<Long> orgIds, long accountTableId) {
        HashMap<Long, Set<PresetCashFlowItemRelation>> relMap = new HashMap<Long, Set<PresetCashFlowItemRelation>>(8);
        Map superOrgMap = OrgUnitServiceHelper.getAllSuperiorOrgs((String)"10", new ArrayList<Long>(orgIds));
        Collection collection = superOrgMap.values();
        HashSet supOrgs = new HashSet(collection.size());
        collection.forEach(supOrgs::addAll);
        supOrgs.addAll(superOrgMap.keySet());
        QFilter orgFilter = new QFilter("createorg", "in", supOrgs);
        orgFilter.and(new QFilter("accounttable", "=", (Object)accountTableId));
        HashMap info = new HashMap();
        DynamicObjectCollection cashFlowItems = QueryServiceHelper.query((String)"AccountCashFlowService#queryAccountCashItemRel", (String)"gl_presetcashflowitem", (String)"id,createorg,group.longnumber,entryentity.account.longnumber,entryentity.dc,entryentity.assgrp_id", (QFilter[])orgFilter.toArray(), (String)"");
        HashMap existPresetCFRelMap = new HashMap(8);
        for (DynamicObject dynamicObject : cashFlowItems) {
            long orgId = dynamicObject.getLong("createorg");
            String groupNumber = dynamicObject.getString("group.longnumber");
            HashMap<String, List> curOrgItemInfoMap = (HashMap<String, List>)info.get(orgId);
            if (curOrgItemInfoMap == null) {
                curOrgItemInfoMap = new HashMap<String, List>(8);
            }
            Long assgrp = dynamicObject.getLong("entryentity.assgrp_id");
            String dc = dynamicObject.getString("entryentity.dc");
            String accLongNumber = dynamicObject.getString("entryentity.account.longnumber");
            String key = AccountCashFlowService.buildKey(new Object[]{assgrp, dc, accLongNumber});
            PresetCashFlowItemRelation cashFlowItemRelation = (PresetCashFlowItemRelation)existPresetCFRelMap.get(key);
            if (!existPresetCFRelMap.containsKey(key)) {
                cashFlowItemRelation = new PresetCashFlowItemRelation(accLongNumber, dc, assgrp);
            }
            curOrgItemInfoMap.computeIfAbsent(groupNumber, k -> new ArrayList(8)).add(cashFlowItemRelation);
            info.put(orgId, curOrgItemInfoMap);
        }
        Map<Long, Set<String>> useLongNumberMap = AccountCashFlowService.getOrgItemLongnumber(orgIds);
        for (Map.Entry supOrgMap : superOrgMap.entrySet()) {
            long currOrg = (Long)supOrgMap.getKey();
            ArrayList<Long> superOrgIds = new ArrayList<Long>((Collection)supOrgMap.getValue());
            superOrgIds.add(currOrg);
            HashMap<String, List> currPresetCashFlowMap = (HashMap<String, List>)info.get(currOrg);
            if (CollectionUtils.isEmpty((Map)currPresetCashFlowMap)) {
                currPresetCashFlowMap = new HashMap<String, List>(8);
            }
            for (int i = superOrgIds.size() - 1; i >= 0; --i) {
                Map superPresetItemMap = (Map)info.get(superOrgIds.get(i));
                if (CollectionUtils.isEmpty((Map)superPresetItemMap)) continue;
                for (Map.Entry entry : superPresetItemMap.entrySet()) {
                    String cfiLongNum = (String)entry.getKey();
                    if (currPresetCashFlowMap.containsKey(cfiLongNum) || !useLongNumberMap.get(currOrg).contains(cfiLongNum)) continue;
                    currPresetCashFlowMap.computeIfAbsent(cfiLongNum, k -> new ArrayList(8)).addAll((Collection)entry.getValue());
                }
            }
            HashSet result = new HashSet(8);
            currPresetCashFlowMap.values().forEach(result::addAll);
            relMap.put(currOrg, result);
        }
        return relMap;
    }

    private static String buildKey(Object[] field) {
        return StringUtils.join((Object[])field, (String)"*");
    }

    private static Map<Long, Set<String>> getOrgItemLongnumber(List<Long> orgIds) {
        QFilter orgFilter = BaseDataServiceHelper.getBaseDataFilter((String)"gl_cashflowitem", new ArrayList<Long>(orgIds), (boolean)true);
        HashMap<Long, Set<String>> useLongNumberMap = new HashMap<Long, Set<String>>(8);
        List useCashFlowItems = QueryServiceHelper.queryPrimaryKeys((String)"gl_cashflowitem", (QFilter[])orgFilter.toArray(), null, (int)-1);
        if (CollectionUtils.isEmpty((Collection)useCashFlowItems)) {
            return useLongNumberMap;
        }
        SqlBuilder sqlBuilder = new SqlBuilder();
        sqlBuilder.append("select flongnumber,fuseorgid from t_gl_cashflowitem a inner join ", new Object[0]);
        sqlBuilder.append(" t_gl_cashflowitem_u b on a.fid = b.fdataid where ", new Object[0]);
        sqlBuilder.appendIn(" a.fid ", useCashFlowItems).append(" and ", new Object[0]);
        sqlBuilder.appendIn(" b.fuseorgid ", orgIds.toArray());
        try (DataSet dataSet = DB.queryDataSet((String)"AccountCashFlowService.getOrgItemLongnumber", (DBRoute)DBRoute.of((String)"fi"), (SqlBuilder)sqlBuilder);){
            while (dataSet.hasNext()) {
                Row row = dataSet.next();
                useLongNumberMap.computeIfAbsent(row.getLong("fuseorgid"), k -> new HashSet(8)).add(row.getString("flongnumber"));
            }
        }
        return useLongNumberMap;
    }

    public static DynamicObject newPresetCashItem(DynamicObject dynamicObject, long accountTableId) {
        CloneUtils c = new CloneUtils(true, true);
        DynamicObject newAccCashFlowItemRel = (DynamicObject)c.clone((IDataEntityBase)dynamicObject);
        DynamicObject tableDyn = (DynamicObject)ThreadCache.get((Object)accountTableId, () -> BusinessDataServiceHelper.loadSingleFromCache((Object)accountTableId, (String)"bd_accounttable"), (boolean)true);
        newAccCashFlowItemRel.set("accounttable", (Object)tableDyn);
        newAccCashFlowItemRel.set("id", (Object)ORM.create().genLongId("gl_presetcashflowitem"));
        return newAccCashFlowItemRel;
    }

    public static DynamicObject createRelationShip(DynamicObject dynamicObject, PresetCashFlowItemRelation presetCashFlowItemRelation, long newAccountId) {
        CloneUtils c = new CloneUtils(true, true);
        DynamicObject newAccCashFlowItemRel = (DynamicObject)c.clone((IDataEntityBase)dynamicObject);
        newAccCashFlowItemRel.set("account_id", (Object)newAccountId);
        newAccCashFlowItemRel.set("dc", (Object)presetCashFlowItemRelation.getDc());
        newAccCashFlowItemRel.set("assgrp_id", (Object)presetCashFlowItemRelation.getAssgrp());
        newAccCashFlowItemRel.set("id", (Object)ORM.create().genLongId("gl_presetcashflowitem"));
        return newAccCashFlowItemRel;
    }
}

