/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bd.business.service.dbschema.impl;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.util.StringUtils;
import kd.fi.bd.business.service.dbschema.DBSchemaSql;
import kd.fi.bd.business.service.dbschema.DBSchemaSqlFile;
import kd.fi.bd.business.service.dbschema.IDBSchemaService;
import org.apache.commons.io.input.BOMInputStream;

public class DBSchemaServiceImpl
implements IDBSchemaService {
    @Override
    public void execute(List<DBSchemaSqlFile> sqlFiles) {
        List<DBSchemaSql> sqlList = this.getSqlList(sqlFiles);
        for (DBSchemaSql sql : sqlList) {
            DB.execute((DBRoute)sql.getDbRoute(), (String)sql.getSql());
        }
    }

    @Override
    public List<DBSchemaSql> getSqlList(List<DBSchemaSqlFile> sqlFiles) {
        ArrayList<DBSchemaSql> result = new ArrayList<DBSchemaSql>(sqlFiles.size());
        StringBuilder sqlBuilder = new StringBuilder();
        for (DBSchemaSqlFile sqlFile : sqlFiles) {
            try {
                InputStream inputStream = this.getClass().getClassLoader().getResourceAsStream(sqlFile.getResourcesPath());
                Throwable throwable = null;
                try {
                    if (inputStream == null) {
                        throw new IllegalArgumentException("not find sql: " + sqlFile.getFileName());
                    }
                    BufferedReader reader = new BufferedReader(new InputStreamReader((InputStream)new BOMInputStream(inputStream), StandardCharsets.UTF_8));
                    Throwable throwable2 = null;
                    try {
                        String sql;
                        while ((sql = reader.readLine()) != null) {
                            if (StringUtils.isBlank((String)sql) || sql.startsWith("/*") || sql.endsWith("*/")) continue;
                            sqlBuilder.append(sql);
                            if (sql.endsWith(";")) {
                                result.add(new DBSchemaSql(sqlBuilder.toString(), DBRoute.of((String)sqlFile.getDbRoute())));
                                sqlBuilder.setLength(0);
                                continue;
                            }
                            sqlBuilder.append(" ");
                        }
                    }
                    catch (Throwable throwable3) {
                        throwable2 = throwable3;
                        throw throwable3;
                    }
                    finally {
                        if (reader == null) continue;
                        if (throwable2 != null) {
                            try {
                                reader.close();
                            }
                            catch (Throwable throwable4) {
                                throwable2.addSuppressed(throwable4);
                            }
                            continue;
                        }
                        reader.close();
                    }
                }
                catch (Throwable throwable5) {
                    throwable = throwable5;
                    throw throwable5;
                }
                finally {
                    if (inputStream == null) continue;
                    if (throwable != null) {
                        try {
                            inputStream.close();
                        }
                        catch (Throwable throwable6) {
                            throwable.addSuppressed(throwable6);
                        }
                        continue;
                    }
                    inputStream.close();
                }
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        return result;
    }
}

