/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bd.business.service.metadata.utils;

import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.nio.charset.StandardCharsets;
import java.util.List;
import kd.bos.util.SAXReaderUtil;
import kd.fi.bd.business.service.metadata.utils.XMLModifyArg;
import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.Element;
import org.dom4j.io.OutputFormat;
import org.dom4j.io.XMLWriter;

public class XMLUtil {
    public static Document parseString(String content) throws DocumentException {
        return SAXReaderUtil.parseText((String)content);
    }

    public static void updateNodeValue(Document doc, String xPatchExpr, String value) {
        if (value == null) {
            value = "";
        }
        List nodes = doc.selectNodes(xPatchExpr);
        for (Object node : nodes) {
            if (!(node instanceof Element)) continue;
            ((Element)node).setText(value);
        }
    }

    public static void updateNodeValue(Document doc, List<? extends XMLModifyArg> args) {
        for (XMLModifyArg xMLModifyArg : args) {
            XMLUtil.updateNodeValue(doc, xMLModifyArg.getXpath(), xMLModifyArg.getValue());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String xmlToString(Document doc) throws IOException {
        Throwable throwable = null;
        try (StringWriter writer = new StringWriter();){
            String string;
            block16: {
                OutputFormat outputFormat = OutputFormat.createCompactFormat();
                outputFormat.setEncoding(StandardCharsets.UTF_8.toString());
                outputFormat.setTrimText(false);
                XMLWriter xmlWriter = null;
                try {
                    xmlWriter = new XMLWriter((Writer)writer, outputFormat);
                    xmlWriter.write(doc);
                    xmlWriter.flush();
                    string = ((Object)writer).toString();
                    if (xmlWriter == null) break block16;
                }
                catch (Throwable throwable2) {
                    try {
                        if (xmlWriter != null) {
                            xmlWriter.close();
                        }
                        throw throwable2;
                    }
                    catch (Throwable throwable3) {
                        throwable = throwable3;
                        throw throwable3;
                    }
                }
                xmlWriter.close();
            }
            return string;
        }
    }
}

