/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bd.business.service.mulcur;

import java.util.List;
import java.util.Map;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.util.StringUtils;
import kd.fi.bd.business.service.mulcur.enums.MulLocalMeta;
import kd.fi.bd.business.vo.LocalCurrencyConfigVO;
import kd.fi.bd.business.vo.MetaField;

public class MulLocalDeployServiceHelper {
    private static final Log LOG = LogFactory.getLog(MulLocalDeployServiceHelper.class);

    public static void deployAll(LocalCurrencyConfigVO ... configs) {
        MulLocalDeployServiceHelper.deploy(MulLocalMeta.values(), configs);
    }

    public static void deploy(MulLocalMeta[] metadata, LocalCurrencyConfigVO ... configs) {
        for (MulLocalMeta meta : metadata) {
            try {
                meta.getDeployerGetter().get().deploy(configs);
            }
            catch (Exception e) {
                LOG.error("Meta {} deploy failed, {}", (Object)meta, (Object)e.getMessage());
                throw e;
            }
        }
    }

    public static boolean validateAfterDeployed(LocalCurrencyConfigVO ... configs) {
        boolean isValid = true;
        for (LocalCurrencyConfigVO config : configs) {
            for (Map.Entry<String, List<MetaField>> entry : config.getAllFields().entrySet()) {
                String entity = entry.getKey();
                List<MetaField> fields = entry.getValue();
                MainEntityType entityType = EntityMetadataCache.getDataEntityType((String)entity);
                Map metaFields = entityType.getAllFields();
                for (MetaField field : fields) {
                    String metaId = field.getMetaId();
                    String alias = field.getDbId();
                    IDataEntityProperty property = (IDataEntityProperty)metaFields.get(metaId);
                    if (null != property && (StringUtils.isEmpty((String)alias) || alias.trim().equalsIgnoreCase(property.getAlias()))) continue;
                    LOG.error("MulLocalCurrencyValidate:entity:" + entity + ", metaId");
                    isValid = false;
                }
            }
        }
        return isValid;
    }

    public static void checkAddConstraintAll(LocalCurrencyConfigVO ... configs) {
        for (MulLocalMeta meta : MulLocalMeta.values()) {
            meta.getDeployerGetter().get().asyncCheckDDL(configs);
        }
    }
}

