/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bd.business.service.mulcur.deployer;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.metadata.deploy.DeployMetadata;
import kd.bos.util.CollectionUtils;
import kd.fi.bd.business.service.dbschema.DBSchemaServiceHelper;
import kd.fi.bd.business.service.dbschema.DBSchemaSqlFile;
import kd.fi.bd.business.service.metadata.IModifyParam;
import kd.fi.bd.business.service.metadata.MetadataFile;
import kd.fi.bd.business.service.metadata.MetadataServiceHelper;
import kd.fi.bd.business.service.metadata.enums.MulLang;
import kd.fi.bd.business.service.metadata.field.FieldName;
import kd.fi.bd.business.service.metadata.param.FieldNameModifyParam;
import kd.fi.bd.business.service.mulcur.IMulLocalMetaDeployer;
import kd.fi.bd.business.vo.LocalCurrencyConfigVO;
import org.apache.commons.lang3.ArrayUtils;

public abstract class AbstractMulLocalDeployer
implements IMulLocalMetaDeployer {
    private static final Log LOG = LogFactory.getLog(AbstractMulLocalDeployer.class);

    @Override
    public void deploy(LocalCurrencyConfigVO[] configs) {
        if (ArrayUtils.isEmpty((Object[])configs)) {
            return;
        }
        String logConfigs = Arrays.stream(configs).map(LocalCurrencyConfigVO::toString).collect(Collectors.joining("|"));
        LOG.info("Meta {} deploy start, configs {}.", (Object)this.getMeta(), (Object)logConfigs);
        List<DeployMetadata> deployMetadata = this.loadMetadata(configs);
        deployMetadata = this.modifyMetadata(deployMetadata, configs);
        try (TXHandle ignored = TX.requiresNew();){
            DBSchemaServiceHelper.execute(this.getSQLFiles(configs));
        }
        LOG.info("Sql execute success.");
        MetadataServiceHelper.deployMetadata(deployMetadata);
        LOG.info("Meta deploy success.");
        LOG.info("Meta {} deploy end, configs {}.", (Object)this.getMeta(), (Object)logConfigs);
    }

    protected List<DeployMetadata> loadMetadata(LocalCurrencyConfigVO[] configs) {
        if (ArrayUtils.isEmpty((Object[])configs)) {
            return Collections.emptyList();
        }
        if (configs.length == 1 && "GrpLocalCurrency".equalsIgnoreCase(configs[0].getNumber())) {
            MetadataFile metadataFile = new MetadataFile(this.getMeta().getFormNumber(), MulLang.values(), "grp/");
            return MetadataServiceHelper.loadMetadataFromResource(metadataFile);
        }
        MetadataFile metadataFile = new MetadataFile(this.getMeta().getFormNumber(), MulLang.values());
        return MetadataServiceHelper.loadMetadataFromResource(metadataFile);
    }

    protected List<DeployMetadata> modifyMetadata(List<DeployMetadata> deployMetadata, LocalCurrencyConfigVO[] configs) {
        List<IModifyParam> params = this.getMetadataModifyParams(configs);
        if (CollectionUtils.isNotEmpty(params)) {
            for (DeployMetadata deployMeta : deployMetadata) {
                MetadataServiceHelper.modify(deployMeta, params.toArray(new IModifyParam[0]));
            }
        }
        return deployMetadata;
    }

    protected List<IModifyParam> getMetadataModifyParams(LocalCurrencyConfigVO[] configs) {
        ArrayList<IModifyParam> params = new ArrayList<IModifyParam>(2);
        FieldNameModifyParam modifyParam = new FieldNameModifyParam(this.getFieldNames(configs));
        params.add(modifyParam);
        return params;
    }

    protected abstract List<FieldName> getFieldNames(LocalCurrencyConfigVO[] var1);

    protected abstract List<DBSchemaSqlFile> getSQLFiles(LocalCurrencyConfigVO[] var1);

    @Override
    public void asyncCheckDDL(LocalCurrencyConfigVO[] configs) {
        DBSchemaServiceHelper.execute(this.getAsyncSqlFiles(configs));
    }

    protected abstract List<DBSchemaSqlFile> getAsyncSqlFiles(LocalCurrencyConfigVO[] var1);
}

