/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bd.business.service.mulcur.deployer;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import kd.fi.bd.business.service.dbschema.DBSchemaSqlFile;
import kd.fi.bd.business.service.metadata.IModifyParam;
import kd.fi.bd.business.service.metadata.enums.FieldType;
import kd.fi.bd.business.service.metadata.enums.FormAp;
import kd.fi.bd.business.service.metadata.field.FieldName;
import kd.fi.bd.business.service.metadata.field.FieldVisible;
import kd.fi.bd.business.service.metadata.param.FieldVisibleModifyParam;
import kd.fi.bd.business.service.mulcur.deployer.AbstractMulLocalDeployer;
import kd.fi.bd.business.service.mulcur.enums.MulLocalMeta;
import kd.fi.bd.business.vo.LocalCurrencyConfigVO;
import kd.fi.bd.consts.MCT;

public class MCTemplateVoucherDeployer
extends AbstractMulLocalDeployer {
    @Override
    public MulLocalMeta getMeta() {
        return MulLocalMeta.GL_TEMPLATEVOUCHER_MC;
    }

    @Override
    public boolean isDeployed(LocalCurrencyConfigVO[] configs) {
        return false;
    }

    @Override
    protected List<IModifyParam> getMetadataModifyParams(LocalCurrencyConfigVO[] configs) {
        List<IModifyParam> params = super.getMetadataModifyParams(configs);
        FieldVisibleModifyParam param = new FieldVisibleModifyParam(Arrays.stream(configs).flatMap(x -> Stream.of(FieldVisible.create(FormAp.EntryFieldAp, x.getVoucherField(MCT.DEBIT).getMetaId(), FieldVisible.Visible.values()), FieldVisible.create(FormAp.EntryFieldAp, x.getVoucherField(MCT.CREDIT).getMetaId(), FieldVisible.Visible.values()))).collect(Collectors.toList()));
        params.add(param);
        return params;
    }

    @Override
    protected List<FieldName> getFieldNames(LocalCurrencyConfigVO[] configs) {
        return Arrays.stream(configs).flatMap(x -> Stream.of(FieldName.create(FieldType.AmountField, x.getVoucherField(MCT.DEBIT).getMetaId(), x.getVoucherField(MCT.DEBIT).getDbId()), FieldName.create(FieldType.AmountField, x.getVoucherField(MCT.CREDIT).getMetaId(), x.getVoucherField(MCT.CREDIT).getDbId()), FieldName.create(FieldType.CurrencyField, x.getVoucherField(MCT.CURRENCY).getMetaId(), x.getVoucherField(MCT.CURRENCY).getDbId()))).collect(Collectors.toList());
    }

    @Override
    protected List<DBSchemaSqlFile> getSQLFiles(LocalCurrencyConfigVO[] configs) {
        ArrayList<DBSchemaSqlFile> sqlFiles = new ArrayList<DBSchemaSqlFile>(configs.length);
        block10: for (LocalCurrencyConfigVO config : configs) {
            switch (config.getNumber()) {
                case "GrpLocalCurrency": {
                    sqlFiles.add(new DBSchemaSqlFile("gl", "kd_1.5.251_gl_table_templatevoucher_mc_grp.sql"));
                    continue block10;
                }
                case "SecLocalCurrency": {
                    sqlFiles.add(new DBSchemaSqlFile("gl", "kd_1.5.251_gl_table_templatevoucher_mc_sec.sql"));
                    continue block10;
                }
                case "TrdLocalCurrency": {
                    sqlFiles.add(new DBSchemaSqlFile("gl", "kd_1.5.251_gl_table_templatevoucher_mc_trd.sql"));
                    continue block10;
                }
            }
        }
        return sqlFiles;
    }

    @Override
    protected List<DBSchemaSqlFile> getAsyncSqlFiles(LocalCurrencyConfigVO[] configs) {
        ArrayList<DBSchemaSqlFile> sqlFiles = new ArrayList<DBSchemaSqlFile>(configs.length);
        block10: for (LocalCurrencyConfigVO config : configs) {
            switch (config.getNumber()) {
                case "GrpLocalCurrency": {
                    sqlFiles.add(new DBSchemaSqlFile("gl", "kd_1.5.251_gl_cons_templatevoucher_mc_grp.sql"));
                    continue block10;
                }
                case "SecLocalCurrency": {
                    sqlFiles.add(new DBSchemaSqlFile("gl", "kd_1.5.251_gl_cons_templatevoucher_mc_sec.sql"));
                    continue block10;
                }
                case "TrdLocalCurrency": {
                    sqlFiles.add(new DBSchemaSqlFile("gl", "kd_1.5.251_gl_cons_templatevoucher_mc_trd.sql"));
                    continue block10;
                }
            }
        }
        return sqlFiles;
    }
}

