/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bd.business.service.mulcur.deployer;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import kd.fi.bd.business.service.dbschema.DBSchemaSqlFile;
import kd.fi.bd.business.service.metadata.enums.FieldType;
import kd.fi.bd.business.service.metadata.field.FieldName;
import kd.fi.bd.business.service.mulcur.deployer.AbstractMulLocalDeployer;
import kd.fi.bd.business.service.mulcur.enums.MulLocalMeta;
import kd.fi.bd.business.vo.LocalCurrencyConfigVO;
import kd.fi.bd.consts.MCT;

public class MulLocalBalanceDeployer
extends AbstractMulLocalDeployer {
    @Override
    protected List<FieldName> getFieldNames(LocalCurrencyConfigVO[] configs) {
        return Arrays.stream(configs).flatMap(x -> Stream.of(FieldName.create(FieldType.AmountField, x.getBalanceField(MCT.BEGIN).getMetaId(), x.getBalanceField(MCT.BEGIN).getDbId()), FieldName.create(FieldType.AmountField, x.getBalanceField(MCT.DEBIT).getMetaId(), x.getBalanceField(MCT.DEBIT).getDbId()), FieldName.create(FieldType.AmountField, x.getBalanceField(MCT.CREDIT).getMetaId(), x.getBalanceField(MCT.CREDIT).getDbId()), FieldName.create(FieldType.AmountField, x.getBalanceField(MCT.YEAR_DEBIT).getMetaId(), x.getBalanceField(MCT.YEAR_DEBIT).getDbId()), FieldName.create(FieldType.AmountField, x.getBalanceField(MCT.YEAR_CREDIT).getMetaId(), x.getBalanceField(MCT.YEAR_CREDIT).getDbId()), FieldName.create(FieldType.AmountField, x.getBalanceField(MCT.END).getMetaId(), x.getBalanceField(MCT.END).getDbId()))).collect(Collectors.toList());
    }

    @Override
    protected List<DBSchemaSqlFile> getSQLFiles(LocalCurrencyConfigVO[] configs) {
        ArrayList<DBSchemaSqlFile> sqlFiles = new ArrayList<DBSchemaSqlFile>(configs.length);
        block10: for (LocalCurrencyConfigVO config : configs) {
            switch (config.getNumber()) {
                case "GrpLocalCurrency": {
                    sqlFiles.add(new DBSchemaSqlFile("gl", "kd_1.5.240_gl_balance_mc_grp.sql"));
                    continue block10;
                }
                case "SecLocalCurrency": {
                    sqlFiles.add(new DBSchemaSqlFile("gl", "kd_1.5.240_gl_balance_mc_sec.sql"));
                    continue block10;
                }
                case "TrdLocalCurrency": {
                    sqlFiles.add(new DBSchemaSqlFile("gl", "kd_1.5.240_gl_balance_mc_trd.sql"));
                    continue block10;
                }
            }
        }
        return sqlFiles;
    }

    @Override
    public MulLocalMeta getMeta() {
        return MulLocalMeta.GL_BALANCE_MC;
    }

    @Override
    protected List<DBSchemaSqlFile> getAsyncSqlFiles(LocalCurrencyConfigVO[] configs) {
        ArrayList<DBSchemaSqlFile> sqlFiles = new ArrayList<DBSchemaSqlFile>(configs.length);
        block10: for (LocalCurrencyConfigVO config : configs) {
            switch (config.getNumber()) {
                case "GrpLocalCurrency": {
                    sqlFiles.add(new DBSchemaSqlFile("gl", "kd_1.5.240_gl_balance_mc_grp_constraint.sql"));
                    continue block10;
                }
                case "SecLocalCurrency": {
                    sqlFiles.add(new DBSchemaSqlFile("gl", "kd_1.5.240_gl_balance_mc_sec_constraint.sql"));
                    continue block10;
                }
                case "TrdLocalCurrency": {
                    sqlFiles.add(new DBSchemaSqlFile("gl", "kd_1.5.240_gl_balance_mc_trd_constraint.sql"));
                    continue block10;
                }
            }
        }
        return sqlFiles;
    }

    @Override
    public boolean isDeployed(LocalCurrencyConfigVO[] configs) {
        return false;
    }
}

