/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bd.business.vo;

import com.google.common.collect.Table;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.ILocaleString;
import kd.bos.dataentity.utils.ArrayUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.fi.bd.business.service.LocalCurrencyQueryService;
import kd.fi.bd.business.vo.AccountBookMCVO;
import kd.fi.bd.business.vo.MetaField;
import kd.fi.bd.consts.MCT;
import kd.fi.bd.enums.ConversionMethod;
import kd.fi.bd.exception.MCErrorCodes;

public class LocalCurrencyConfigVO {
    private static final Log LOG = LogFactory.getLog(LocalCurrencyConfigVO.class);
    private static final String COMMA = ",";
    private String number;
    private ILocaleString name;
    private boolean enabled;
    private final MetaField currencyMetaField;
    private final MetaField exrateTableField;
    private Table<String, MCT, MetaField> _allFields;

    public LocalCurrencyConfigVO(boolean enabled, String number, ILocaleString name, MetaField currencyMetaField, MetaField exrateTableField, Table<String, MCT, MetaField> allFields) {
        this.number = number;
        this.enabled = enabled;
        this.name = name;
        this.currencyMetaField = currencyMetaField;
        this.exrateTableField = exrateTableField;
        this._allFields = allFields;
    }

    public boolean validateSelf() {
        if (null == this._allFields || this._allFields.isEmpty()) {
            return false;
        }
        Set entities = this._allFields.rowKeySet();
        for (String entity : entities) {
            Map fieldMap = this._allFields.row((Object)entity);
            if (!fieldMap.entrySet().stream().anyMatch(e -> e.getValue() == null || !((MCT)((Object)((Object)e.getKey()))).getValue().equals(((MetaField)e.getValue()).getFieldTag()) || StringUtils.isEmpty((CharSequence)((MetaField)e.getValue()).getFieldTag()))) continue;
            LOG.error("wrong config: number: " + this.getNumber() + ", entity: " + entity + ", config:" + fieldMap);
            return false;
        }
        return true;
    }

    public Collection<MetaField> getVoucherFields(MCT ... tags) {
        if (ArrayUtils.isEmpty((Object[])tags)) {
            throw new KDBizException(MCErrorCodes.PARAM_ERR, new Object[]{"params tags is empty"});
        }
        return this.getFields("gl_voucher", tags);
    }

    public MetaField getVoucherField(MCT tag) {
        if (null == tag) {
            throw new KDBizException(MCErrorCodes.PARAM_ERR, new Object[]{"params tag is empty"});
        }
        return this.getFields("gl_voucher", tag).get(0);
    }

    public String getOrmVoucherFields(MCT ... tags) {
        return this.getVoucherFields(tags).stream().map(MetaField::getMetaId).collect(Collectors.joining(COMMA));
    }

    public String getSqlVoucherFields(MCT ... tags) {
        return this.getVoucherFields(tags).stream().map(MetaField::getDbId).collect(Collectors.joining(COMMA));
    }

    public Collection<MetaField> getInitBalanceFields(MCT ... tags) {
        if (ArrayUtils.isEmpty((Object[])tags)) {
            throw new KDBizException(MCErrorCodes.PARAM_ERR, new Object[]{"params tags is empty"});
        }
        return this.getFields("gl_initbalance", tags);
    }

    public Collection<MetaField> getAllInitBalanceFields() {
        return this.getAllFields("gl_initbalance");
    }

    public MetaField getInitBalanceField(MCT tag) {
        if (null == tag) {
            throw new KDBizException(MCErrorCodes.PARAM_ERR, new Object[]{"params tag is empty"});
        }
        return this.getFields("gl_initbalance", tag).get(0);
    }

    public String getOrmInitBalanceFields(MCT ... tags) {
        return this.getInitBalanceFields(tags).stream().map(MetaField::getMetaId).collect(Collectors.joining(COMMA));
    }

    public String getSqlInitBalanceFields(MCT ... tags) {
        return this.getInitBalanceFields(tags).stream().map(MetaField::getDbId).collect(Collectors.joining(COMMA));
    }

    public Collection<MetaField> getBalanceLogFields(MCT ... tags) {
        if (ArrayUtils.isEmpty((Object[])tags)) {
            throw new KDBizException(MCErrorCodes.PARAM_ERR, new Object[]{"params tags is empty"});
        }
        return this.getFields("gl_balance_log", tags);
    }

    public MetaField getBalanceLogField(MCT tag) {
        if (null == tag) {
            throw new KDBizException(MCErrorCodes.PARAM_ERR, new Object[]{"params tag is empty"});
        }
        return this.getFields("gl_balance_log", tag).get(0);
    }

    public String getOrmBalanceLogFields(MCT ... tags) {
        return this.getBalanceLogFields(tags).stream().map(MetaField::getMetaId).collect(Collectors.joining(COMMA));
    }

    public String getSqlBalanceLogFields(MCT ... tags) {
        return this.getBalanceLogFields(tags).stream().map(MetaField::getDbId).collect(Collectors.joining(COMMA));
    }

    public long getExRateTableId(long orgId, long bookTypeId) {
        AccountBookMCVO.Info info;
        Table<Long, Long, AccountBookMCVO> allMulLocalCurrency = LocalCurrencyQueryService.getAllMulLocalCurrency();
        AccountBookMCVO accountBookMCVO = (AccountBookMCVO)allMulLocalCurrency.get((Object)orgId, (Object)bookTypeId);
        if (Objects.nonNull(accountBookMCVO) && Objects.nonNull(info = accountBookMCVO.getCurrencyInfoMap().get(this.number))) {
            return info.getExRateTableId();
        }
        return 0L;
    }

    public long getCurrencyId(long orgId, long bookTypeId) {
        AccountBookMCVO.Info info;
        Table<Long, Long, AccountBookMCVO> allMulLocalCurrency = LocalCurrencyQueryService.getAllMulLocalCurrency();
        AccountBookMCVO accountBookMCVO = (AccountBookMCVO)allMulLocalCurrency.get((Object)orgId, (Object)bookTypeId);
        if (Objects.nonNull(accountBookMCVO) && Objects.nonNull(info = accountBookMCVO.getCurrencyInfoMap().get(this.number))) {
            return info.getCurrencyId();
        }
        return 0L;
    }

    public ConversionMethod getConversionMethod(long orgId, long bookTypeId) {
        AccountBookMCVO.Info info;
        Table<Long, Long, AccountBookMCVO> allMulLocalCurrency = LocalCurrencyQueryService.getAllMulLocalCurrency();
        AccountBookMCVO accountBookMCVO = (AccountBookMCVO)allMulLocalCurrency.get((Object)orgId, (Object)bookTypeId);
        if (Objects.nonNull(accountBookMCVO) && Objects.nonNull(info = accountBookMCVO.getCurrencyInfoMap().get(this.number))) {
            return info.getConversionMethod();
        }
        return ConversionMethod.ORIGINAL;
    }

    public Collection<MetaField> getBalanceFields(MCT ... tags) {
        if (ArrayUtils.isEmpty((Object[])tags)) {
            throw new KDBizException(MCErrorCodes.PARAM_ERR, new Object[]{"params tags is empty"});
        }
        return this.getFields("gl_balance", tags);
    }

    public MetaField getBalanceField(MCT tag) {
        if (null == tag) {
            throw new KDBizException(MCErrorCodes.PARAM_ERR, new Object[]{"params tag is empty"});
        }
        return this.getFields("gl_balance", tag).get(0);
    }

    public String getOrmBalanceFields(MCT ... tags) {
        return this.getBalanceFields(tags).stream().map(MetaField::getMetaId).collect(Collectors.joining(COMMA));
    }

    public String getSqlBalanceFields(MCT ... tags) {
        return this.getBalanceFields(tags).stream().map(MetaField::getDbId).collect(Collectors.joining(COMMA));
    }

    private List<MetaField> getFields(String entity, MCT ... tags) {
        if (ArrayUtils.isEmpty((Object[])tags)) {
            throw new KDBizException(MCErrorCodes.PARAM_ERR, new Object[]{"params tags is empty"});
        }
        Map sources = this._allFields.row((Object)entity);
        ArrayList<MetaField> fields = new ArrayList<MetaField>(tags.length);
        for (MCT tag : tags) {
            MetaField field = (MetaField)sources.get((Object)tag);
            if (null == field) {
                throw new KDBizException(MCErrorCodes.CONFIG_ERR, new Object[]{"no field with tag:" + (Object)((Object)tag)});
            }
            fields.add(field);
        }
        if (fields.size() != tags.length) {
            throw new KDBizException(MCErrorCodes.LOGIC_ERR, new Object[]{"The size of result is not matched the param size. "});
        }
        return fields;
    }

    private List<MetaField> getAllFields(String entity) {
        Map sources = this._allFields.row((Object)entity);
        return new ArrayList<MetaField>(sources.values());
    }

    public String getNumber() {
        return this.number;
    }

    public ILocaleString getName() {
        return this.name;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        LocalCurrencyConfigVO that = (LocalCurrencyConfigVO)o;
        return Objects.equals(this.number, that.number);
    }

    public Map<String, List<MetaField>> getAllFields() {
        HashMap<String, List<MetaField>> result = new HashMap<String, List<MetaField>>(8);
        for (String entity : this._allFields.rowKeySet()) {
            result.put(entity, new ArrayList(this._allFields.row((Object)entity).values()));
        }
        return result;
    }

    public String getCurrencyField() {
        return this.currencyMetaField.getMetaId();
    }

    public String getExRateField() {
        return this.exrateTableField.getMetaId();
    }

    public String getControlEntityId() {
        return this.currencyMetaField.getEntityId();
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public int hashCode() {
        return Objects.hash(this.number);
    }

    public String toString() {
        return "LocalCurrencyConfigVO{number='" + this.number + '\'' + ", name=" + this.name + ", currencyMetaField=" + this.currencyMetaField + ", exrateTableField=" + this.exrateTableField + ", allFields=" + this._allFields + '}';
    }
}

