/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bd.cache.cacheservice;

import kd.bos.entity.cache.AppCache;
import kd.bos.entity.cache.IAppCache;
import kd.fi.bd.cache.CacheModule;
import kd.fi.bd.cache.cacheservice.IDataCacheEntry;

public class IDataDistributeCache
implements IAppCache,
IDataCacheEntry {
    private static IDataDistributeCache[] moduleDistributedCaches = new IDataDistributeCache[CacheModule.values().length];
    private IAppCache distributedCaches;

    public static IDataDistributeCache getCache(CacheModule module) {
        return module != null ? moduleDistributedCaches[module.getCode()] : null;
    }

    public IDataDistributeCache(IAppCache distributedCaches) {
        this.distributedCaches = distributedCaches;
    }

    @Override
    public void put(String key, Object content) {
        this.distributedCaches.put(key, content);
    }

    @Override
    public String get(String key) {
        return (String)this.distributedCaches.get(key, String.class);
    }

    @Override
    public void remove(String key) {
        this.distributedCaches.remove(key);
    }

    @Override
    public void put(String key, Object content, int timeout) {
        this.distributedCaches.put(key, content, timeout);
    }

    @Override
    public <T> T get(String key, Class<T> classType) {
        return (T)this.distributedCaches.get(key, classType);
    }

    @Override
    public void clear() {
        this.distributedCaches.clear();
    }

    @Override
    public String getString(String key) {
        return (String)this.distributedCaches.get(key, String.class);
    }

    static {
        for (CacheModule module : CacheModule.values()) {
            IDataDistributeCache.moduleDistributedCaches[module.getCode()] = new IDataDistributeCache(AppCache.get((String)module.name()));
        }
    }
}

