/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bd.cache.cacheservice;

import java.util.Map;
import kd.bos.cache.CacheConfigInfo;
import kd.bos.cache.CacheFactory;
import kd.bos.cache.LocalMemoryCache;
import kd.bos.dataentity.resource.cache.CacheKeyUtil;
import kd.fi.bd.cache.CacheModule;
import kd.fi.bd.cache.cacheservice.IDataCacheEntry;
import kd.fi.bd.util.optimizor.OptimizeControlPanel;

public class IDataLocalCache
implements LocalMemoryCache,
IDataCacheEntry {
    private static int defaultTimeOut = OptimizeControlPanel.getSysPropertyInteger("idata.localcache.timeout", 3600);
    private static int maxItemSize = OptimizeControlPanel.getSysPropertyInteger("idata.localcache.maxitemsize", 10240000);
    private static CacheConfigInfo defaultCacheConfig = new CacheConfigInfo();
    private LocalMemoryCache localCache;
    private CacheConfigInfo cacheConfig;
    private String cacheKeyPrefix;

    public static IDataLocalCache getCache(CacheModule module) {
        if (module == null) {
            return null;
        }
        return new IDataLocalCache(module, CacheFactory.getCommonCacheFactory().$getOrCreateLocalMemoryCache(CacheKeyUtil.getAcctId(), module.name(), defaultCacheConfig), defaultCacheConfig);
    }

    public static IDataLocalCache getCache(CacheModule module, int defaultTimeOut, int maxItemSize) {
        if (module == null) {
            return null;
        }
        CacheConfigInfo config = new CacheConfigInfo();
        config.setTimeout(defaultTimeOut);
        config.setMaxItemSize(maxItemSize);
        return new IDataLocalCache(module, CacheFactory.getCommonCacheFactory().$getOrCreateLocalMemoryCache(CacheKeyUtil.getAcctId(), module.name(), config), config);
    }

    public static IDataLocalCache getCache(CacheModule module, int defaultTimeOut) {
        return IDataLocalCache.getCache(module, defaultTimeOut, maxItemSize);
    }

    public CacheConfigInfo getCacheConfig() {
        return this.cacheConfig;
    }

    protected IDataLocalCache(CacheModule module, LocalMemoryCache localCache, CacheConfigInfo cacheConfig) {
        this.localCache = localCache;
        this.cacheKeyPrefix = module.name();
        this.cacheConfig = cacheConfig;
    }

    protected String buildCacheKey(String key) {
        return this.cacheKeyPrefix + "|" + key;
    }

    protected String[] buildCacheKey(String[] keys) {
        if (keys == null || keys.length <= 0) {
            return keys;
        }
        for (int i = 0; i < keys.length; ++i) {
            keys[i] = this.buildCacheKey(keys[i]);
        }
        return keys;
    }

    @Override
    public void put(String key, Object content) {
        this.localCache.put(this.buildCacheKey(key), content);
    }

    @Override
    public Object get(String key) {
        return this.localCache.get(this.buildCacheKey(key));
    }

    @Override
    public void remove(String key) {
        this.localCache.remove(new String[]{this.buildCacheKey(key)});
    }

    public Map<String, Object> get(String ... keys) {
        return (keys = this.buildCacheKey(keys)) == null ? null : this.localCache.get(keys);
    }

    public void remove(String ... keys) {
        if ((keys = this.buildCacheKey(keys)) != null) {
            this.localCache.remove(keys);
        }
    }

    public Object getAndRemove(String key) {
        key = this.buildCacheKey(key);
        Object buf = this.localCache.get(key);
        this.localCache.remove(new String[]{key});
        return buf;
    }

    public Map<String, Object> getAndRemove(String ... keys) {
        if (keys != null && keys.length > 0) {
            keys = this.buildCacheKey(keys);
            Map buf = this.localCache.get(keys);
            this.localCache.remove(keys);
            return buf;
        }
        return null;
    }

    public boolean contains(String key) {
        return this.localCache.contains(key);
    }

    @Override
    public void clear() {
        this.localCache.clear();
    }

    public void removeMapFields(String var1, String ... var2) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void put(String key, Object content, int timeout) {
        this.put(key, content);
    }

    @Override
    public <T> T get(String key, Class<T> classType) {
        return (T)this.get(key);
    }

    @Override
    public String getString(String key) {
        Object result = this.get(key);
        return result != null ? result.toString() : null;
    }

    static {
        defaultCacheConfig.setTimeout(defaultTimeOut);
        defaultCacheConfig.setMaxItemSize(maxItemSize);
    }
}

