/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bd.cashflow.replace;

import com.google.common.collect.ImmutableList;
import java.util.Collections;
import java.util.List;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.SqlBuilder;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.logging.Log;
import kd.bos.orm.datamanager.DataEntityCacheManager;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.org.OrgServiceHelper;
import kd.fi.bd.cashflow.replace.CashFlowItemDBReplaceConfig;
import kd.fi.bd.logger.ExtLogFactory;
import kd.fi.bd.util.BillParamUtil;
import kd.fi.bd.util.filter.QFilterBuilder;

public class CashFlowItemDBReplaceExecutor {
    private static final Log extLogger = ExtLogFactory.getLog(CashFlowItemDBReplaceExecutor.class, "[CashFlowItemDBReplaceExecutor]", () -> true);
    private static final List<CashFlowItemDBReplaceConfig> STANDARD_CONFIG_LIST = ImmutableList.of((Object)new CashFlowItemDBReplaceConfig("gl_presetcashflowitem", "t_gl_presetcashflowitem", "fgroupid", "fcreateorgid"));

    public static int replace(Long orgId, Long previousMasterid, Long updatedId) {
        String extConfig = BillParamUtil.getStringValue("83bfebc8000017ac", "fi.gl.cashflow.replace.config", "[]");
        List cashFlowItemDBReplaceConfigs = SerializationUtils.fromJsonStringToList((String)extConfig, CashFlowItemDBReplaceConfig.class);
        cashFlowItemDBReplaceConfigs.addAll(STANDARD_CONFIG_LIST);
        Throwable throwable = null;
        try (TXHandle txHandle = TX.required();){
            int n = CashFlowItemDBReplaceExecutor._replace(previousMasterid, updatedId, orgId, cashFlowItemDBReplaceConfigs);
            return n;
        }
        catch (Exception e) {
            try {
                extLogger.error("replace item error", (Throwable)e);
                txHandle.markRollback();
                throw e;
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
        }
    }

    private static int _replace(Long previousMasterId, Long updatedId, Long orgId, List<CashFlowItemDBReplaceConfig> replaceConfigs) {
        extLogger.info("start replace:previousId={},updatedId={},orgId={},config={}", new Object[]{previousMasterId, updatedId, orgId, replaceConfigs});
        int result = 0;
        List allSubordinateOrgs = OrgServiceHelper.getAllSubordinateOrgs((String)"10", Collections.singletonList(orgId), (boolean)true);
        List toReplacedCashFlowItemIds = QueryServiceHelper.queryPrimaryKeys((String)"gl_cashflowitem", (QFilter[])QFilterBuilder.create("masterid", "=", previousMasterId).toArray(new QFilter[0]), (String)"", (int)-1);
        for (CashFlowItemDBReplaceConfig replaceConfig : replaceConfigs) {
            SqlBuilder sqlBuilder = new SqlBuilder().append(String.format("update %s set %s = ? ", replaceConfig.getTableAlias(), replaceConfig.getItemFieldAlias()), new Object[]{updatedId}).appendIn("where " + replaceConfig.getItemFieldAlias(), toReplacedCashFlowItemIds).appendIn(" and " + replaceConfig.getCreateOrgFieldAlias(), allSubordinateOrgs.toArray());
            int updateCnt = DB.update((DBRoute)DBRoute.of((String)EntityMetadataCache.getDataEntityType((String)replaceConfig.getEntityId()).getDBRouteKey()), (SqlBuilder)sqlBuilder);
            if (updateCnt <= 0) continue;
            new DataEntityCacheManager(replaceConfig.getTableAlias()).removeByDt();
            result += updateCnt;
        }
        extLogger.info("replace success, updateCnt={}", (Object)result);
        return result;
    }
}

