/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bd.cfversion;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.basedata.BaseDataServiceHelper;
import kd.bos.servicehelper.org.OrgServiceHelper;
import kd.fi.bd.cfversion.CheckResult;
import kd.fi.bd.util.CashflowItemCheckUtil;
import kd.fi.bd.util.CashflowItemVersionUtil;

public class CashflowPropertyCheck {
    private static final List<String> SUB_SUP_ITEM_CHECK = new ArrayList<String>();
    private static final List<String> SUB_SUP_ORG_CHECK = new ArrayList<String>();
    private static final String[] ENTRY_FIELD = new String[]{"isrequire", "isdetail"};
    private static final String SELECT_FIELD = "createorg,assistentry.asstypeid,assistentry.isdetail,assistentry.isrequire,direction,isdealactivity,type,isexchangerate,isscheduleitem,isprefit,level";

    public String countTip(CheckType checkType) {
        String err;
        switch (checkType) {
            case CUR_SUPERIOR: {
                err = ResManager.loadKDString((String)"\u5f53\u524d\u73b0\u91d1\u6d41\u91cf\u9879\u76ee\u7684\u6838\u7b97\u7ef4\u5ea6\u4e0d\u80fd\u5c11\u4e8e\u4e0a\u7ea7\u73b0\u91d1\u6d41\u91cf\u9879\u76ee\u7684\u6838\u7b97\u7ef4\u5ea6\u3002", (String)"CashflowPropertyCheck_0", (String)"fi-bd-common", (Object[])new Object[0]);
                break;
            }
            case ORG_SUPERIOR: {
                err = ResManager.loadKDString((String)"\u5f53\u524d\u73b0\u91d1\u6d41\u91cf\u9879\u76ee\u7684\u6838\u7b97\u7ef4\u5ea6\u4e0d\u80fd\u5c11\u4e8e\u4e0a\u7ea7\u7ec4\u7ec7\u73b0\u91d1\u6d41\u91cf\u9879\u76ee\u7684\u6838\u7b97\u7ef4\u5ea6\u3002", (String)"CashflowPropertyCheck_1", (String)"fi-bd-common", (Object[])new Object[0]);
                break;
            }
            case CUR_SUBORDINATE: {
                err = ResManager.loadKDString((String)"\u5f53\u524d\u73b0\u91d1\u6d41\u91cf\u9879\u76ee\u7684\u6838\u7b97\u7ef4\u5ea6\u4e0d\u80fd\u591a\u4e8e\u4e0b\u7ea7\u73b0\u91d1\u6d41\u91cf\u9879\u76ee\u7684\u6838\u7b97\u7ef4\u5ea6\u3002", (String)"CashflowPropertyCheck_2", (String)"fi-bd-common", (Object[])new Object[0]);
                break;
            }
            case ORG_SUBORDINATE: {
                err = ResManager.loadKDString((String)"\u5f53\u524d\u73b0\u91d1\u6d41\u91cf\u9879\u76ee\u7684\u6838\u7b97\u7ef4\u5ea6\u4e0d\u80fd\u591a\u4e8e\u4e0b\u7ea7\u7ec4\u7ec7\u73b0\u91d1\u6d41\u91cf\u9879\u76ee\u7684\u6838\u7b97\u7ef4\u5ea6\u3002", (String)"CashflowPropertyCheck_3", (String)"fi-bd-common", (Object[])new Object[0]);
                break;
            }
            default: {
                throw new IllegalStateException("Unexpected value: " + (Object)((Object)checkType));
            }
        }
        return err;
    }

    public String missTup(CheckType checkType, String assistName) {
        String err;
        switch (checkType) {
            case CUR_SUPERIOR: {
                err = String.format(ResManager.loadKDString((String)"\u4e0a\u7ea7\u6d41\u91cf\u9879\u76ee\u5305\u542b\u6838\u7b97\u7ef4\u5ea6%1$s\u65f6\uff0c\u5f53\u524d\u6838\u7b97\u7ef4\u5ea6\u5fc5\u987b\u5305\u542b\u8be5\u7ef4\u5ea6\u3002", (String)"CashflowPropertyCheck_4", (String)"fi-bd-common", (Object[])new Object[0]), assistName);
                break;
            }
            case ORG_SUPERIOR: {
                err = String.format(ResManager.loadKDString((String)"\u4e0a\u7ea7\u7ec4\u7ec7\u6d41\u91cf\u9879\u76ee\u5305\u542b\u6838\u7b97\u7ef4\u5ea6%1$s\u65f6\uff0c\u5f53\u524d\u6838\u7b97\u7ef4\u5ea6\u5fc5\u987b\u5305\u542b\u8be5\u7ef4\u5ea6\u3002", (String)"CashflowPropertyCheck_5", (String)"fi-bd-common", (Object[])new Object[0]), assistName);
                break;
            }
            case CUR_SUBORDINATE: {
                err = String.format(ResManager.loadKDString((String)"\u5f53\u524d\u73b0\u91d1\u6d41\u91cf\u9879\u76ee\u5305\u542b\u6838\u7b97\u7ef4\u5ea6%1$s\uff0c\u4e0b\u7ea7\u73b0\u91d1\u6d41\u91cf\u9879\u76ee\u4e5f\u9700\u8981\u5305\u542b\u8be5\u7ef4\u5ea6\u3002", (String)"CashflowPropertyCheck_6", (String)"fi-bd-common", (Object[])new Object[0]), assistName);
                break;
            }
            case ORG_SUBORDINATE: {
                err = String.format(ResManager.loadKDString((String)"\u5f53\u524d\u73b0\u91d1\u6d41\u91cf\u9879\u76ee\u5305\u542b\u6838\u7b97\u7ef4\u5ea6%1$s\uff0c\u4e0b\u7ea7\u7ec4\u7ec7\u73b0\u91d1\u6d41\u91cf\u9879\u76ee\u4e5f\u9700\u8981\u5305\u542b\u8be5\u7ef4\u5ea6\u3002", (String)"CashflowPropertyCheck_7", (String)"fi-bd-common", (Object[])new Object[0]), assistName);
                break;
            }
            default: {
                throw new IllegalStateException("Unexpected value: " + (Object)((Object)checkType));
            }
        }
        return err;
    }

    public String propertyTip(CheckType checkType, String assistName, String fieldName) {
        String err;
        switch (checkType) {
            case CUR_SUPERIOR: {
                err = String.format(ResManager.loadKDString((String)"\u5f53\u4e0a\u7ea7\u73b0\u91d1\u6d41\u91cf\u9879\u76ee\u6838\u7b97\u7ef4\u5ea6%1$s\u7684%2$s\u5c5e\u6027\u52fe\u9009\u65f6\uff0c\u4e0b\u7ea7\u4e0d\u80fd\u53d6\u6d88\u52fe\u9009\u3002", (String)"CashflowPropertyCheck_8", (String)"fi-bd-common", (Object[])new Object[0]), assistName, fieldName);
                break;
            }
            case ORG_SUPERIOR: {
                err = String.format(ResManager.loadKDString((String)"\u5f53\u4e0a\u7ea7\u7ec4\u7ec7\u73b0\u91d1\u6d41\u91cf\u9879\u76ee\u6838\u7b97\u7ef4\u5ea6%1$s\u7684%2$s\u5c5e\u6027\u52fe\u9009\u65f6\uff0c\u4e0b\u7ea7\u4e0d\u80fd\u53d6\u6d88\u52fe\u9009\u3002", (String)"CashflowPropertyCheck_9", (String)"fi-bd-common", (Object[])new Object[0]), assistName, fieldName);
                break;
            }
            case CUR_SUBORDINATE: {
                err = String.format(ResManager.loadKDString((String)"\u4e0b\u7ea7\u73b0\u91d1\u6d41\u91cf\u9879\u76ee\u6838\u7b97\u7ef4\u5ea6%1$s\u7684%2$s\u5c5e\u6027\u6ca1\u52fe\u9009\u65f6\uff0c\u5f53\u524d\u73b0\u91d1\u6d41\u91cf\u9879\u76ee\u4e0d\u80fd\u52fe\u9009\u3002", (String)"CashflowPropertyCheck_10", (String)"fi-bd-common", (Object[])new Object[0]), assistName, fieldName);
                break;
            }
            case ORG_SUBORDINATE: {
                err = String.format(ResManager.loadKDString((String)"\u4e0b\u7ea7\u7ec4\u7ec7\u73b0\u91d1\u6d41\u91cf\u9879\u76ee\u6838\u7b97\u7ef4\u5ea6%1$s\u7684%2$s\u5c5e\u6027\u6ca1\u52fe\u9009\u65f6\uff0c\u5f53\u524d\u73b0\u91d1\u6d41\u91cf\u9879\u76ee\u4e0d\u80fd\u52fe\u9009\u3002", (String)"CashflowPropertyCheck_11", (String)"fi-bd-common", (Object[])new Object[0]), assistName, fieldName);
                break;
            }
            default: {
                throw new IllegalStateException("Unexpected value: " + (Object)((Object)checkType));
            }
        }
        return err;
    }

    private CheckResult check(DynamicObject curObj, DynamicObject parent, CheckType checkType) {
        CheckResult result = new CheckResult();
        result.setStatus(Status.SUCCESS);
        if (parent == null) {
            return result;
        }
        String[] entryFieldNames = new String[]{ResManager.loadKDString((String)"\u5fc5\u5f55", (String)"CashflowPropertyCheck_12", (String)"fi-bd-common", (Object[])new Object[0]), ResManager.loadKDString((String)"\u660e\u7ec6", (String)"CashflowPropertyCheck_13", (String)"fi-bd-common", (Object[])new Object[0])};
        DynamicObjectCollection checkitementry = curObj.getDynamicObjectCollection("assistentry");
        Map<Long, DynamicObject> checkitemMap = checkitementry.stream().filter(x -> x.getDynamicObject("asstypeid") != null).collect(Collectors.toMap(x -> x.getDynamicObject("asstypeid").getLong("id"), x -> x));
        DynamicObjectCollection parentcheckitementry = parent.getDynamicObjectCollection("assistentry");
        if (checkitementry.size() < parentcheckitementry.size()) {
            String err = this.countTip(checkType);
            result.setErrorMsg(err);
            result.setStatus(Status.SIZE_DIFF);
            return result;
        }
        for (DynamicObject dynamicObject : parentcheckitementry) {
            DynamicObject assist = dynamicObject.getDynamicObject("asstypeid");
            long parentasstactTypeId = assist.getLong("id");
            if (!checkitemMap.containsKey(parentasstactTypeId)) {
                String err = this.missTup(checkType, assist.getString("name"));
                result.setErrorMsg(err);
                result.setStatus(Status.MISS);
                return result;
            }
            DynamicObject curItem = checkitemMap.get(parentasstactTypeId);
            for (int t = 0; t < ENTRY_FIELD.length; ++t) {
                if (!dynamicObject.getBoolean(ENTRY_FIELD[t]) || curItem.getBoolean(ENTRY_FIELD[t])) continue;
                String err = this.propertyTip(checkType, curItem.getDynamicObject("asstypeid").getString("name"), entryFieldNames[t]);
                result.setErrorMsg(err);
                result.setStatus(Status.PROPERTY_DIFF);
                return result;
            }
        }
        return result;
    }

    private DynamicObject getParentCashflow(long orgId, DynamicObject item) {
        QFilter filter = BaseDataServiceHelper.getBaseDataFilter((String)"gl_cashflowitem", (Long)orgId);
        QFilter fnumber = new QFilter("number", "=", (Object)item.getString("number"));
        QFilter fenddate = new QFilter("enddate", "=", (Object)CashflowItemVersionUtil.getEndDate());
        return BusinessDataServiceHelper.loadSingleFromCache((String)"gl_cashflowitem", (String)SELECT_FIELD, (QFilter[])new QFilter[]{filter, fnumber, fenddate});
    }

    public CheckResult saveCheck(DynamicObject item, boolean onlyCheckParent, long useOrgId) {
        long parentOrgId;
        CheckResult check = new CheckResult();
        check.setStatus(Status.SUCCESS);
        DynamicObject parent = item.getDynamicObject("parent");
        if (parent != null) {
            parent = this.getParentCashflow(useOrgId, parent);
            check = this.check(item, parent, CheckType.CUR_SUPERIOR);
            check.setCheckType(CheckType.CUR_SUPERIOR);
            if (check.getStatus() == Status.SUCCESS) {
                check = this.checkProperty(item, parent, SUB_SUP_ITEM_CHECK, CheckType.CUR_SUPERIOR);
            }
            if (check.getStatus() != Status.SUCCESS) {
                return check;
            }
        }
        if ((parentOrgId = CashflowItemCheckUtil.getParentOrgId(useOrgId)) != 0L) {
            DynamicObject parentItem = this.getParentCashflow(parentOrgId, item);
            check = this.check(item, parentItem, CheckType.ORG_SUPERIOR);
            check.setCheckType(CheckType.ORG_SUPERIOR);
            if (check.getStatus() == Status.SUCCESS) {
                check = this.checkProperty(item, parentItem, SUB_SUP_ORG_CHECK, CheckType.ORG_SUPERIOR);
            }
            if (check.getStatus() != Status.SUCCESS) {
                return check;
            }
        }
        if (!onlyCheckParent) {
            QFilter fenddate = new QFilter("enddate", "=", (Object)CashflowItemVersionUtil.getEndDate());
            QFilter forgid = BaseDataServiceHelper.getBaseDataFilter((String)"gl_cashflowitem", (Long)useOrgId);
            QFilter fparent = new QFilter("parent.masterid", "=", (Object)item.getLong("masterid"));
            Map subItems = BusinessDataServiceHelper.loadFromCache((String)"gl_cashflowitem", (String)SELECT_FIELD, (QFilter[])new QFilter[]{fenddate, forgid, fparent});
            for (DynamicObject obj : subItems.values()) {
                check = this.check(obj, item, CheckType.CUR_SUBORDINATE);
                check.setCheckType(CheckType.CUR_SUBORDINATE);
                if (check.getStatus() == Status.SUCCESS) {
                    check = this.checkProperty(obj, item, SUB_SUP_ITEM_CHECK, CheckType.CUR_SUBORDINATE);
                }
                if (check.getStatus() == Status.SUCCESS) continue;
                return check;
            }
            List orgs = OrgServiceHelper.getAllSubordinateOrgs((String)"10", Collections.singletonList(useOrgId), (boolean)false);
            QFilter fcreorg = new QFilter("createorg", "in", (Object)orgs);
            QFilter fnumber = new QFilter("longnumber", "like", (Object)(item.getString("longnumber") + "%"));
            int level = item.getInt("level");
            QFilter flevel = new QFilter("level", "in", (Object)new Integer[]{level, level + 1});
            Map subOrgObjs = BusinessDataServiceHelper.loadFromCache((String)"gl_cashflowitem", (String)SELECT_FIELD, (QFilter[])new QFilter[]{fenddate, fcreorg, fnumber, flevel});
            HashMap<Long, Long> subOrgItemMasterIds = new HashMap<Long, Long>(orgs.size());
            for (Map.Entry entry : subOrgObjs.entrySet()) {
                DynamicObject subOrgItem = (DynamicObject)entry.getValue();
                if (!subOrgItem.getString("number").equals(item.getString("number"))) continue;
                subOrgItemMasterIds.put(subOrgItem.getLong("createorg_id"), subOrgItem.getLong("masterid"));
            }
            for (DynamicObject obj : subOrgObjs.values()) {
                Long subOrgItemMasterid = (Long)subOrgItemMasterIds.get(obj.getLong("createorg_id"));
                if (subOrgItemMasterid != null && subOrgItemMasterid.compareTo(item.getLong("masterid")) != 0 || obj.getString("level").equals(item.getString("level")) && !obj.getString("number").equals(item.getString("number")) || obj.getInt("level") > item.getInt("level") && !obj.getString("longnumber").startsWith(item.getString("longnumber") + "@")) continue;
                check = this.check(obj, item, CheckType.ORG_SUBORDINATE);
                check.setCheckType(CheckType.ORG_SUBORDINATE);
                if (check.getStatus() == Status.SUCCESS) {
                    check = this.checkProperty(obj, item, SUB_SUP_ORG_CHECK, CheckType.ORG_SUBORDINATE);
                }
                if (check.getStatus() == Status.SUCCESS) continue;
                return check;
            }
        }
        return check;
    }

    protected CheckResult checkProperty(DynamicObject item, DynamicObject parent, List<String> checkField, CheckType checkType) {
        CheckResult result = new CheckResult();
        result.setStatus(Status.SUCCESS);
        if (parent == null) {
            return result;
        }
        String err = null;
        block0 : switch (checkType) {
            case CUR_SUPERIOR: {
                for (String property : checkField) {
                    if (property.equals("direction")) {
                        if (parent.getString(property).equals("b") || item.getString(property).equals(parent.getString(property))) continue;
                        err = String.format(ResManager.loadKDString((String)"\u5f53\u524d\u73b0\u91d1\u6d41\u91cf\u9879\u76ee\u7684%1$s\u5c5e\u6027\u503c\u8ddf\u4e0a\u7ea7\u73b0\u91d1\u6d41\u91cf\u9879\u76ee\u4e0d\u4e00\u81f4\u3002", (String)"CashflowPropertyCheck_14", (String)"fi-bd-common", (Object[])new Object[0]), this.getPropetyName(property));
                        break block0;
                    }
                    if (item.getString(property).equals(parent.getString(property))) continue;
                    err = String.format(ResManager.loadKDString((String)"\u5f53\u524d\u73b0\u91d1\u6d41\u91cf\u9879\u76ee\u7684%1$s\u5c5e\u6027\u503c\u8ddf\u4e0a\u7ea7\u73b0\u91d1\u6d41\u91cf\u9879\u76ee\u4e0d\u4e00\u81f4\u3002", (String)"CashflowPropertyCheck_14", (String)"fi-bd-common", (Object[])new Object[0]), this.getPropetyName(property));
                    break block0;
                }
                break;
            }
            case ORG_SUPERIOR: {
                for (String property : checkField) {
                    if (item.getString(property).equals(parent.getString(property))) continue;
                    err = String.format(ResManager.loadKDString((String)"\u5f53\u524d\u73b0\u91d1\u6d41\u91cf\u9879\u76ee\u7684%1$s\u5c5e\u6027\u503c\u8ddf\u4e0a\u7ea7\u7ec4\u7ec7\u73b0\u91d1\u6d41\u91cf\u9879\u76ee\u4e0d\u4e00\u81f4\u3002", (String)"CashflowPropertyCheck_15", (String)"fi-bd-common", (Object[])new Object[0]), this.getPropetyName(property));
                    break block0;
                }
                break;
            }
            case CUR_SUBORDINATE: {
                for (String property : checkField) {
                    if (property.equals("direction")) {
                        if (parent.getString(property).equals("b") || item.getString(property).equals(parent.getString(property))) continue;
                        err = String.format(ResManager.loadKDString((String)"\u5f53\u524d\u73b0\u91d1\u6d41\u91cf\u9879\u76ee\u7684%1$s\u5c5e\u6027\u503c\u8ddf\u4e0b\u7ea7\u73b0\u91d1\u6d41\u91cf\u9879\u76ee\u4e0d\u4e00\u81f4\u3002", (String)"CashflowPropertyCheck_16", (String)"fi-bd-common", (Object[])new Object[0]), this.getPropetyName(property));
                        break block0;
                    }
                    if (item.getString(property).equals(parent.getString(property))) continue;
                    err = String.format(ResManager.loadKDString((String)"\u5f53\u524d\u73b0\u91d1\u6d41\u91cf\u9879\u76ee\u7684%1$s\u5c5e\u6027\u503c\u8ddf\u4e0b\u7ea7\u73b0\u91d1\u6d41\u91cf\u9879\u76ee\u4e0d\u4e00\u81f4\u3002", (String)"CashflowPropertyCheck_16", (String)"fi-bd-common", (Object[])new Object[0]), this.getPropetyName(property));
                    break block0;
                }
                break;
            }
            case ORG_SUBORDINATE: {
                for (String property : checkField) {
                    if (property.equals("direction")) {
                        if (parent.getString(property).equals("b") || item.getString(property).equals(parent.getString(property))) continue;
                        err = String.format(ResManager.loadKDString((String)"\u5f53\u524d\u73b0\u91d1\u6d41\u91cf\u9879\u76ee\u7684%1$s\u5c5e\u6027\u503c\u8ddf\u4e0b\u7ea7\u7ec4\u7ec7\u73b0\u91d1\u6d41\u91cf\u9879\u76ee\u4e0d\u4e00\u81f4\u3002", (String)"CashflowPropertyCheck_17", (String)"fi-bd-common", (Object[])new Object[0]), this.getPropetyName(property));
                        break block0;
                    }
                    if (!item.getString("number").equals(parent.getString("number")) || item.getString(property).equals(parent.getString(property))) continue;
                    err = String.format(ResManager.loadKDString((String)"\u5f53\u524d\u73b0\u91d1\u6d41\u91cf\u9879\u76ee\u7684%1$s\u5c5e\u6027\u503c\u8ddf\u4e0b\u7ea7\u7ec4\u7ec7\u73b0\u91d1\u6d41\u91cf\u9879\u76ee\u4e0d\u4e00\u81f4\u3002", (String)"CashflowPropertyCheck_17", (String)"fi-bd-common", (Object[])new Object[0]), this.getPropetyName(property));
                    break block0;
                }
                break;
            }
            default: {
                throw new IllegalStateException("Unexpected value: " + (Object)((Object)checkType));
            }
        }
        if (StringUtils.isNotEmpty(err)) {
            result.setStatus(Status.PROPERTY_DIFF);
            result.setErrorMsg(err);
        }
        return result;
    }

    protected String getPropetyName(String property) {
        String name = "";
        switch (property) {
            case "direction": {
                name = ResManager.loadKDString((String)"\u73b0\u91d1\u6d41\u5411", (String)"CashflowPropertyCheck_18", (String)"fi-bd-common", (Object[])new Object[0]);
                break;
            }
            case "isprefit": {
                name = ResManager.loadKDString((String)"\u51c0\u5229\u6da6", (String)"CashflowPropertyCheck_19", (String)"fi-bd-common", (Object[])new Object[0]);
                break;
            }
            case "isscheduleitem": {
                name = ResManager.loadKDString((String)"\u9644\u8868\u9879\u76ee", (String)"CashflowPropertyCheck_20", (String)"fi-bd-common", (Object[])new Object[0]);
                break;
            }
            case "type": {
                name = ResManager.loadKDString((String)"\u9879\u76ee\u7c7b\u522b", (String)"CashflowPropertyCheck_21", (String)"fi-bd-common", (Object[])new Object[0]);
                break;
            }
            case "isdealactivity": {
                name = ResManager.loadKDString((String)"\u7ecf\u8425\u6d3b\u52a8", (String)"CashflowPropertyCheck_22", (String)"fi-bd-common", (Object[])new Object[0]);
                break;
            }
            case "isexchangerate": {
                name = ResManager.loadKDString((String)"\u6c47\u7387\u53d8\u52a8", (String)"CashflowPropertyCheck_23", (String)"fi-bd-common", (Object[])new Object[0]);
                break;
            }
            default: {
                name = "";
            }
        }
        return name;
    }

    public static CheckResult deleteCheck() {
        return null;
    }

    static {
        SUB_SUP_ITEM_CHECK.add("type");
        SUB_SUP_ITEM_CHECK.add("isdealactivity");
        SUB_SUP_ITEM_CHECK.add("isexchangerate");
        SUB_SUP_ITEM_CHECK.add("direction");
        SUB_SUP_ORG_CHECK.add("direction");
        SUB_SUP_ORG_CHECK.add("isprefit");
        SUB_SUP_ORG_CHECK.add("isscheduleitem");
        SUB_SUP_ORG_CHECK.add("type");
        SUB_SUP_ORG_CHECK.add("isdealactivity");
        SUB_SUP_ORG_CHECK.add("isexchangerate");
    }

    public static enum Status {
        SUCCESS,
        SIZE_DIFF,
        MISS,
        PROPERTY_DIFF;

    }

    public static enum CheckType {
        CUR_SUPERIOR,
        CUR_SUBORDINATE,
        ORG_SUPERIOR,
        ORG_SUBORDINATE;

    }
}

