/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bd.cfversion.addassist;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.Tuple;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.fi.bd.cfversion.addassist.CfitemAssistAddingContext;
import kd.fi.bd.consts.BDCommonResource;
import kd.fi.bd.enhance.treetask.CfitemContext;
import kd.fi.bd.enhance.treetask.DependBiTreeNode;
import kd.fi.bd.enhance.treetask.ITaskService;
import kd.fi.bd.enums.PeriodStateEnum;
import kd.fi.bd.util.BDUtil;
import kd.fi.bd.util.BiTreeNode;
import kd.fi.bd.util.CashflowBizCheckUtil;
import kd.fi.bd.util.TaskExecutionResult;
import kd.fi.bd.vo.CashflowItemOrgVo;
import kd.fi.bd.vo.CashflowItemVo;
import kd.fi.bd.vo.MessageVO;
import kd.fi.bd.vo.OrgCfitemOwnershipVO;
import kd.fi.bd.vo.OrgVO;

public class CfitemAddingAssistValidateTaskImpl
implements ITaskService<TaskExecutionResult<CashflowItemOrgVo>, CfitemContext> {
    private static final Log LOG = LogFactory.getLog(CfitemAddingAssistValidateTaskImpl.class);
    protected RequestContext requestContext = RequestContext.get();

    @Override
    public TaskExecutionResult<CashflowItemOrgVo> buildExceptionResult(CfitemContext taskContext, Exception e) {
        Tuple<BiTreeNode<String, CashflowItemVo>, BiTreeNode<Long, OrgVO>> accOrgInfo = taskContext.getData();
        String accNumber = (String)((BiTreeNode)accOrgInfo.item1).getId();
        long orgId = (Long)((BiTreeNode)accOrgInfo.item2).getId();
        CashflowItemOrgVo pairVO = new CashflowItemOrgVo(accNumber, orgId);
        return TaskExecutionResult.failed(pairVO, BDCommonResource.getMessageConstantsE006Text(BDUtil.buildExceptionMsg(e, 20, true), RequestContext.get().getTraceId()), "E004");
    }

    @Override
    public TaskExecutionResult<CashflowItemOrgVo> buildFastFailResult(CfitemContext taskContext) {
        Tuple<BiTreeNode<String, CashflowItemVo>, BiTreeNode<Long, OrgVO>> accOrgInfo = taskContext.getData();
        String accNumber = (String)((BiTreeNode)accOrgInfo.item1).getId();
        long orgId = (Long)((BiTreeNode)accOrgInfo.item2).getId();
        CashflowItemOrgVo pairVO = new CashflowItemOrgVo(accNumber, orgId);
        LOG.info(String.format("AccOrgNodeRecursiveTask execute auto-failed: acc: %s,  org: %s", accNumber, orgId));
        return TaskExecutionResult.fastFail(pairVO, BDCommonResource.getMessageConstantsE003Text(), "E003");
    }

    @Override
    public Optional<TaskExecutionResult<CashflowItemOrgVo>> validateBeforeExecution(CfitemContext taskContext) {
        Tuple<BiTreeNode<String, CashflowItemVo>, BiTreeNode<Long, OrgVO>> data = taskContext.getData();
        BiTreeNode itemNode = (BiTreeNode)data.item1;
        BiTreeNode orgNode = (BiTreeNode)data.item2;
        CfitemAssistAddingContext context = taskContext.getAssistAddingContext();
        Optional<MessageVO> validateMsg = this.isValidBeforeExecution(itemNode, orgNode, context);
        if (validateMsg.isPresent()) {
            LOG.info(String.format("ItemOrgNodeRecursiveTask org : %s, cfitem \uff1a%s, validate msg is : %s", orgNode.getId(), itemNode.getId(), validateMsg.get()));
            if (validateMsg.get().getType() == MessageVO.Type.FAILED) {
                return Optional.of(TaskExecutionResult.failed(new CashflowItemOrgVo((String)itemNode.getId(), (Long)orgNode.getId()), validateMsg.get().getName(), validateMsg.get().getCode()));
            }
            if (validateMsg.get().getType() == MessageVO.Type.SKIP) {
                return Optional.of(TaskExecutionResult.skipped(new CashflowItemOrgVo((String)itemNode.getId(), (Long)orgNode.getId()), validateMsg.get().getName(), validateMsg.get().getCode()));
            }
            if (validateMsg.get().getType() == MessageVO.Type.DELAY) {
                DependBiTreeNode curNode = (DependBiTreeNode)taskContext.getBindNode();
                while (Objects.nonNull(curNode.getParent())) {
                    curNode = (DependBiTreeNode)curNode.getParent();
                    if (!((String)itemNode.getId()).equals(((CfitemContext)curNode.getData()).getAccountNumber()) || validateMsg.get().getProxyOrgId().longValue() != ((CfitemContext)curNode.getData()).getOrgId()) continue;
                    ((DependBiTreeNode)taskContext.getBindNode()).setProxyNode(curNode);
                    break;
                }
                return Optional.of(TaskExecutionResult.delay(new CashflowItemOrgVo((String)itemNode.getId(), (Long)orgNode.getId()), validateMsg.get().getName(), validateMsg.get().getCode()));
            }
            return Optional.of(TaskExecutionResult.failed(new CashflowItemOrgVo((String)itemNode.getId(), (Long)orgNode.getId()), validateMsg.get().getName(), validateMsg.get().getCode()));
        }
        LOG.info(String.format("ItemOrgNodeRecursiveTask org : %s, account \uff1a%s, validate success", orgNode.getId(), itemNode.getId()));
        return Optional.empty();
    }

    @Override
    public TaskExecutionResult<CashflowItemOrgVo> execute(CfitemContext taskContext) {
        Tuple<BiTreeNode<String, CashflowItemVo>, BiTreeNode<Long, OrgVO>> data = taskContext.getData();
        BiTreeNode cfNode = (BiTreeNode)data.item1;
        BiTreeNode orgNode = (BiTreeNode)data.item2;
        return new TaskExecutionResult<CashflowItemOrgVo>(new CashflowItemOrgVo((String)cfNode.getId(), (Long)orgNode.getId()));
    }

    private Optional<MessageVO> isValidBeforeExecution(BiTreeNode<String, CashflowItemVo> itemNode, BiTreeNode<Long, OrgVO> orgNode, CfitemAssistAddingContext context) {
        boolean isVersionedAfterDate;
        if (this.getClass() != CfitemAddingAssistValidateTaskImpl.class && itemNode.getParent() == null && orgNode.getParent() == null) {
            return Optional.of(MessageVO.of("S006", BDCommonResource.getMeesageConstantsS006Text(), MessageVO.Type.SKIP));
        }
        Date versionDate = context.getVersionDate();
        CashflowItemVo cfitem = itemNode.getData();
        String cfNumber = cfitem.getNumber();
        long orgId = orgNode.getId();
        OrgVO org = orgNode.getData();
        Optional<DynamicObject> itemDyn = this.getCurrentCfitemObj(cfNumber, orgId, context);
        if (!itemDyn.isPresent()) {
            return Optional.of(MessageVO.of("S001", String.format(ResManager.loadKDString((String)"\u7ec4\u7ec7%1$s\u4e0d\u5b58\u5728\u7f16\u7801\u4e3a%2$s\u7684\u73b0\u91d1\u6d41\u91cf\u9879\u76ee", (String)"CfitemAddingAssistValidateTaskImpl_0", (String)"fi-bd-common", (Object[])new Object[0]), org.getName(), cfNumber), MessageVO.Type.SKIP));
        }
        long itemId = itemDyn.get().getLong("id");
        boolean isIncludeAssist = this.isIncludeAssist(orgId, cfNumber, context.getOrgIdCfitemIncudeAssistMap());
        if (isIncludeAssist) {
            return Optional.of(MessageVO.of("S002", String.format(ResManager.loadKDString((String)"\u7ec4\u7ec7%1$s\u7f16\u7801\u4e3a%2$s\u7684\u73b0\u91d1\u6d41\u91cf\u9879\u76ee\u5df2\u7ecf\u5b8c\u5168\u5305\u542b\u672c\u6b21\u8981\u6dfb\u52a0\u7684\u7ef4\u5ea6\u4fe1\u606f\u3002", (String)"CfitemAddingAssistValidateTaskImpl_1", (String)"fi-bd-common", (Object[])new Object[0]), org.getName(), cfNumber), MessageVO.Type.SKIP));
        }
        PeriodStateEnum stateEnum = BDUtil.getCurVersionState(context.getPeriodMap(), context.getPeriodTypeIds(), versionDate, itemDyn.get().getDate("startdate"));
        if (PeriodStateEnum.BOTH == stateEnum) {
            return Optional.of(MessageVO.of("E005", BDCommonResource.getMessageConstantsE005Text(), MessageVO.Type.FAILED));
        }
        if (PeriodStateEnum.ALL_NO == stateEnum && (isVersionedAfterDate = this.isVersionAferDate(itemDyn.get(), versionDate))) {
            return Optional.of(MessageVO.of("E001", BDCommonResource.getMessageConstantsE001Text(), MessageVO.Type.FAILED));
        }
        Optional<String> isAfterDateExistsBiz = this.isBizAfterDate(orgId, itemDyn.get().getLong("id"), context);
        if (isAfterDateExistsBiz.isPresent()) {
            return Optional.of(MessageVO.of("E002", BDCommonResource.getMessageConstantsE002Text() + isAfterDateExistsBiz.get(), MessageVO.Type.FAILED));
        }
        boolean isCreateOrgId = this.isCreateOrgId(itemDyn.get(), orgId);
        if (!isCreateOrgId) {
            long callPersonalizeOpOrgId = this.getCallPersonalizeOpOrgId(orgNode, itemId, context);
            DynamicObject orgDyn = context.getOrgIdDynObjMap().get(callPersonalizeOpOrgId);
            if (callPersonalizeOpOrgId != orgId) {
                return Optional.of(MessageVO.ofDelay("S004", String.format(ResManager.loadKDString((String)"\u7ec4\u7ec7%1$s\u7f16\u7801\u4e3a%2$s\u7684\u73b0\u91d1\u6d41\u91cf\u9879\u76ee\u7531\u4e0a\u7ea7\u7ec4\u7ec7\uff1a%3$s\u6267\u884c\u4e2a\u6027\u5316\u65b0\u589e\uff0c\u8be5\u7ec4\u7ec7\u4e0d\u8fdb\u884c\u5904\u7406\u3002", (String)"CfitemAddingAssistValidateTaskImpl_2", (String)"fi-bd-common", (Object[])new Object[0]), org.getName(), cfNumber, orgDyn.getString("name")), callPersonalizeOpOrgId));
            }
        }
        return Optional.empty();
    }

    protected Optional<DynamicObject> getCurrentCfitemObj(String number, Long orgId, CfitemAssistAddingContext context) {
        Optional<Long> itemId = context.tryGetCfitemIdByOrgAndCfNum(orgId, number);
        if (!itemId.isPresent()) {
            return Optional.empty();
        }
        return Optional.of(context.getItemId2DynMap().get(itemId.get()));
    }

    private boolean isIncludeAssist(long orgId, String number, Map<Long, Map<String, Boolean>> orgIdCfitemIncudeAssistMap) {
        Map<String, Boolean> numberResultMap = orgIdCfitemIncudeAssistMap.get(orgId);
        if (numberResultMap == null) {
            return false;
        }
        return numberResultMap.getOrDefault(number, Boolean.FALSE);
    }

    private boolean isVersionAferDate(DynamicObject itemDynObj, Date versionDate) {
        return itemDynObj.getDate("startdate").compareTo(versionDate) >= 0;
    }

    private Optional<String> isBizAfterDate(long orgId, long itemId, CfitemAssistAddingContext context) {
        Integer bizType = (Integer)context.getOrgIditemIdBizTable().get((Object)orgId, (Object)itemId);
        if (bizType != null && bizType > 0) {
            return Optional.of(CashflowBizCheckUtil.BizType.withTypes(bizType).stream().map(CashflowBizCheckUtil.BizType::getDesc).collect(Collectors.joining("\uff0c")));
        }
        return Optional.empty();
    }

    private boolean isCreateOrgId(DynamicObject itemDynObj, long useOrgId) {
        return itemDynObj.getLong("createorg_id") == useOrgId;
    }

    private long getCallPersonalizeOpOrgId(BiTreeNode<Long, OrgVO> orgNode, long itemId, CfitemAssistAddingContext context) {
        ArrayList<Long> parentUseOrgIdList = new ArrayList<Long>(10);
        this.getParentUseOrgIdList(orgNode, itemId, context, parentUseOrgIdList);
        if (parentUseOrgIdList.isEmpty()) {
            return orgNode.getId();
        }
        return (Long)parentUseOrgIdList.get(parentUseOrgIdList.size() - 1);
    }

    private void getParentUseOrgIdList(BiTreeNode<Long, OrgVO> sonNode, long itemId, CfitemAssistAddingContext context, List<Long> parentUseOrgIdList) {
        BiTreeNode parent = sonNode.getParent();
        if (parent != null) {
            boolean accountUseableOnOrg = this.isCfitemUseableOnOrg(itemId, (Long)parent.getId(), context);
            if (!accountUseableOnOrg) {
                return;
            }
            parentUseOrgIdList.add((Long)parent.getId());
            this.getParentUseOrgIdList(parent, itemId, context, parentUseOrgIdList);
        }
    }

    protected boolean isCfitemUseableOnOrg(long itemId, long orgId, CfitemAssistAddingContext context) {
        OrgCfitemOwnershipVO ownershipVO = context.getOrgCfitemNumberShip().get(orgId);
        if (Objects.isNull(ownershipVO)) {
            return false;
        }
        Map<String, Long> numberIdMap = ownershipVO.getNumberLatestCfId();
        return numberIdMap.containsValue(itemId);
    }
}

