/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bd.checktools.account.check;

import java.util.ArrayList;
import java.util.List;
import kd.fi.bd.checktools.account.check.AccountCheckType;
import kd.fi.bd.checktools.account.check.ControlCheckCtx;
import kd.fi.bd.checktools.account.check.ICheckSubscribeService;
import kd.fi.bd.checktools.account.check.checkprop.AccountPropChecker;
import kd.fi.bd.checktools.account.check.service.AsstCheckSubscribeServiceImpl;
import kd.fi.bd.checktools.account.check.service.AsstRepeatCheckSubscribeServiceImpl;
import kd.fi.bd.checktools.account.check.service.BizAccountCheckSubscribeServiceImpl;
import kd.fi.bd.checktools.account.check.service.CheckAccAssignRelationShipServiceImpl;
import kd.fi.bd.checktools.account.check.service.CheckAccUseAndExcDataServiceImpl;
import kd.fi.bd.checktools.account.check.service.FirstLevelSubscribeServiceImpl;
import kd.fi.bd.checktools.account.check.service.JournalCheckSubscribeServiceImpl;
import kd.fi.bd.checktools.account.check.service.LeafCheckSubscribeServiceImpl;
import kd.fi.bd.checktools.account.check.service.LongNumberCheckSubscribeServiceImpl;
import kd.fi.bd.checktools.account.check.service.RelationIncompleteCheckSubscribeServiceImpl;
import kd.fi.bd.checktools.account.check.service.RepeatAccountCheckSubscribeServiceImpl;
import kd.fi.bd.checktools.account.check.service.UseRangeExcCheckSubscribeServiceImpl;
import kd.fi.bd.checktools.account.check.service.VersionDateCheckSubscribeServiceImpl;

public class AccountCheckPublishSubscribe {
    private List<ICheckSubscribeService> subscribers = new ArrayList<ICheckSubscribeService>(10);

    public void publishCheck(ControlCheckCtx ctx) {
        int checkType = ctx.getCheckType().getValue();
        if (AccountCheckType.BIZ_CHECK.isIn(checkType)) {
            this.subscribers.add(new BizAccountCheckSubscribeServiceImpl(ctx));
        }
        if (AccountCheckType.VERSION_DATE.isIn(checkType)) {
            this.subscribers.add(new VersionDateCheckSubscribeServiceImpl(ctx));
        }
        if (AccountCheckType.HIGHER_AND_LOWER_ISLEAF.isIn(checkType)) {
            this.subscribers.add(new LeafCheckSubscribeServiceImpl(ctx));
        }
        if (AccountCheckType.LONG_NUMBER_NAME.isIn(checkType)) {
            this.subscribers.add(new LongNumberCheckSubscribeServiceImpl(ctx));
        }
        if (AccountCheckType.REPEAT.isIn(checkType)) {
            this.subscribers.add(new RepeatAccountCheckSubscribeServiceImpl(ctx));
        }
        if (AccountCheckType.DEFECT_REL.isIn(checkType)) {
            this.subscribers.add(new RelationIncompleteCheckSubscribeServiceImpl(ctx));
        }
        if (AccountCheckType.ASST.isIn(checkType)) {
            this.subscribers.add(new AsstCheckSubscribeServiceImpl(ctx));
        }
        if (AccountCheckType.CHECK_PROP.isIn(checkType)) {
            this.subscribers.add(new AccountPropChecker(ctx));
        }
        if (AccountCheckType.CHECK_FIRST_LEVEL_ACC.isIn(checkType)) {
            this.subscribers.add(new FirstLevelSubscribeServiceImpl(ctx));
        }
        if (AccountCheckType.CHECK_JOURNAL.isIn(checkType)) {
            this.subscribers.add(new JournalCheckSubscribeServiceImpl(ctx));
        }
        if (AccountCheckType.CHECK_USERANGE_EXC.isIn(checkType)) {
            this.subscribers.add(new UseRangeExcCheckSubscribeServiceImpl(ctx));
        }
        if (AccountCheckType.ASST_REPEAT.isIn(checkType)) {
            this.subscribers.add(new AsstRepeatCheckSubscribeServiceImpl(ctx));
        }
        if (AccountCheckType.CHECK_ASSIGN.isIn(checkType)) {
            this.subscribers.add(new CheckAccAssignRelationShipServiceImpl(ctx));
        }
        if (AccountCheckType.CHECK_USE_EXC.isIn(checkType)) {
            this.subscribers.add(new CheckAccUseAndExcDataServiceImpl(ctx));
        }
        this.receiveCheck();
    }

    private void receiveCheck() {
        for (ICheckSubscribeService subscriber : this.subscribers) {
            boolean isCheckSuccess = subscriber.check();
            if (isCheckSuccess) continue;
            return;
        }
    }
}

