/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bd.checktools.account.check;

import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.fi.bd.checktools.account.check.AccountCheckPublishSubscribe;
import kd.fi.bd.checktools.account.check.ControlCheckCtx;
import kd.fi.bd.checktools.account.check.ICheckPulishService;

public class CheckHandle
implements ICheckPulishService {
    private Log logger = LogFactory.getLog(CheckHandle.class);
    private ControlCheckCtx ctx;
    private AccountCheckPublishSubscribe subscribePublish;

    public CheckHandle(ControlCheckCtx ctx) {
        this.ctx = ctx;
        this.subscribePublish = new AccountCheckPublishSubscribe();
    }

    public void handle() {
        try {
            this.createRstTable();
            this.check();
        }
        catch (Exception e) {
            this.logger.info("check_begin error:" + e.getMessage(), (Object)e);
            if (this.ctx.getView() != null) {
                this.ctx.getView().getPageCache().put("msg", e.toString());
            }
        }
        finally {
            if (this.ctx.getView() != null) {
                this.ctx.getView().getPageCache().put("mark", "finish");
            }
        }
    }

    @Override
    public void check() {
        this.subscribePublish.publishCheck(this.ctx);
    }

    private void createRstTable() {
        boolean exitsTable = DB.exitsTable((DBRoute)DBRoute.of((String)"fi"), (String)"t_bd_accountcheckrs");
        if (exitsTable) {
            StringBuilder createTbSql = new StringBuilder();
            createTbSql.append("delete from t_bd_accountcheckrs ");
            DB.execute((DBRoute)DBRoute.of((String)"fi"), (String)createTbSql.toString());
        } else {
            StringBuilder createTbSql = new StringBuilder();
            createTbSql.append("CREATE TABLE t_bd_accountcheckrs( ").append(" FID BIGINT DEFAULT 0 NOT NULL primary key, ").append(" forgid bigint DEFAULT 0 not null, ").append(" forgname varchar(255) DEFAULT(' ') not null, ").append(" faccountnumber varchar(255) DEFAULT(' ') not null, ").append(" fresult varchar(40) DEFAULT(' ') not null, ").append(" fdesc varchar(500) DEFAULT(' ') not null, ").append(" ftype varchar(80) DEFAULT(' ') not null ").append(")");
            DB.execute((DBRoute)DBRoute.of((String)"fi"), (String)createTbSql.toString());
        }
    }

    public void backup() {
    }
}

