/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bd.checktools.account.check.checkprop;

import java.sql.ResultSet;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.ResultSetHandler;
import kd.bos.db.SqlBuilder;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.DBServiceHelper;
import kd.fi.bd.checktools.account.check.AbstractCheckSubscribeService;
import kd.fi.bd.checktools.account.check.ControlCheckCtx;
import kd.fi.bd.checktools.account.check.checkprop.AccountNodeWrap;
import kd.fi.bd.checktools.account.check.checkprop.BaseDataVO;
import kd.fi.bd.checktools.account.check.checkprop.OrgAccountDoubleNode;
import kd.fi.bd.util.AccountVersionControlChecker;
import kd.fi.bd.util.BDUtil;
import kd.fi.bd.util.BiTreeNode;
import kd.fi.bd.vo.OrgVO;

public class AccountPropChecker
extends AbstractCheckSubscribeService {
    private static final Log LOG = LogFactory.getLog(AccountPropChecker.class);
    private static DBRoute ROUNTE_FI = DBRoute.of((String)"fi");
    private Set<CheckedAccPair> checkedPairs = new HashSet<CheckedAccPair>(8);
    private final BiTreeNode<Long, OrgVO> orgFullTree;
    private final Map<Long, BiTreeNode<Long, OrgVO>> orgFastIndex;
    private List<Object[]> checkLogs = new ArrayList<Object[]>(8);

    public AccountPropChecker(ControlCheckCtx ctx) {
        super(ctx);
        this.orgFullTree = BDUtil.buildSubTreeByOrgId(10, Optional.empty());
        this.orgFastIndex = new HashMap<Long, BiTreeNode<Long, OrgVO>>(8);
        this.orgFullTree.collect(x -> this.orgFastIndex.put((Long)x.getId(), (BiTreeNode<Long, OrgVO>)x));
    }

    @Override
    protected boolean process() {
        this.execute(this.ctx.getAccountTableId());
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute(long accTableId) {
        LOG.info("=================  start to checkout account table id: {}", (Object)accTableId);
        SqlBuilder firstLevelAccSql = new SqlBuilder();
        firstLevelAccSql.append("SELECT distinct(c.fnumber) FROM T_BD_ACCOUNT c WHERE ", new Object[0]);
        firstLevelAccSql.append(" c.faccounttableid = ?", new Object[]{accTableId});
        firstLevelAccSql.append(" AND c.fstatus = ?", new Object[]{Character.valueOf('C')});
        firstLevelAccSql.append(" AND c.fenable = ?", new Object[]{Character.valueOf('1')});
        firstLevelAccSql.append(" AND c.flevel = '1'", new Object[0]);
        List firstLevelAccNums = (List)DB.query((DBRoute)ROUNTE_FI, (SqlBuilder)firstLevelAccSql, (ResultSetHandler)new ResultSetHandler<List<String>>(){

            public List<String> handle(ResultSet rs) throws Exception {
                ArrayList<String> firstLevelAccNums = new ArrayList<String>(8);
                while (rs.next()) {
                    firstLevelAccNums.add(rs.getString("fnumber"));
                }
                return firstLevelAccNums;
            }
        });
        try {
            for (int i = 0; i < firstLevelAccNums.size(); ++i) {
                String accNum = (String)firstLevelAccNums.get(i);
                LOG.info("{}/{} check_account_number: {}", new Object[]{i + 1, firstLevelAccNums.size(), accNum});
                this.checkOneAccNumber(accTableId, accNum);
            }
        }
        finally {
            this.persistCheckLog();
            LOG.info("=================  end to check account table id: {}", (Object)accTableId);
        }
    }

    private void checkOneAccNumber(long accTableId, String accNumber) {
        OrgAccountDoubleNode orgAccRootNode = new OrgAccountDoubleNode(this.orgFullTree.getId(), null);
        final HashMap<Long, OrgAccountDoubleNode> orgAccNodeIndex = new HashMap<Long, OrgAccountDoubleNode>(8);
        orgAccNodeIndex.put(this.orgFullTree.getId(), orgAccRootNode);
        this.orgFullTree.preTravel(x -> {
            long orgId = (Long)x.getId();
            if (orgId == this.orgFullTree.getId()) {
                return;
            }
            OrgAccountDoubleNode orgAccDoubleNode = new OrgAccountDoubleNode(orgId, null);
            if (null != x.getParent()) {
                OrgAccountDoubleNode parentNode = (OrgAccountDoubleNode)orgAccNodeIndex.get(x.getParent().getId());
                orgAccDoubleNode.setParent(parentNode);
            }
            orgAccNodeIndex.put(orgId, orgAccDoubleNode);
        });
        SqlBuilder allAccIDSQL = new SqlBuilder();
        allAccIDSQL.append("SELECT c.fid id from T_BD_ACCOUNT AS c WHERE ", new Object[0]);
        allAccIDSQL.append(" c.faccounttableid = ?", new Object[]{accTableId});
        allAccIDSQL.append(" AND c.fstatus = ?", new Object[]{Character.valueOf('C')});
        allAccIDSQL.append(" AND c.fenable = ?", new Object[]{Character.valueOf('1')});
        allAccIDSQL.append(" AND c.flongnumber like ?", new Object[]{accNumber + "%"});
        Set allAccIds = (Set)DB.query((DBRoute)ROUNTE_FI, (SqlBuilder)allAccIDSQL, (ResultSetHandler)new ResultSetHandler<Set<Object>>(){

            public Set<Object> handle(ResultSet rs) throws Exception {
                HashSet<Object> accIds = new HashSet<Object>(8);
                while (rs.next()) {
                    accIds.add(rs.getLong("id"));
                }
                return accIds;
            }
        });
        DynamicObject[] allAccDys = BusinessDataServiceHelper.load((Object[])allAccIds.toArray(new Object[0]), (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)"bd_accountview"));
        final Map<Object, DynamicObject> accIndex = Arrays.stream(allAccDys).collect(Collectors.toMap(x -> x.getLong("id"), x -> x));
        SqlBuilder allAccSQL = new SqlBuilder();
        allAccSQL.append("SELECT c.fid id, u.fuseorgid, c.fnumber, c.flongnumber, c.flevel FROM T_BD_ACCOUNT_U AS u INNER JOIN T_BD_ACCOUNT AS c ON u.fdataid = c.fid WHERE ", new Object[0]);
        allAccSQL.append(" c.faccounttableid = ?", new Object[]{accTableId});
        allAccSQL.append(" AND c.fstatus = ?", new Object[]{Character.valueOf('C')});
        allAccSQL.append(" AND c.fenable = ?", new Object[]{Character.valueOf('1')});
        allAccSQL.append(" AND c.flongnumber like ?", new Object[]{accNumber + "%"});
        allAccSQL.append(" order by c.flevel asc ", new Object[0]);
        boolean isBuildTreeSuccess = (Boolean)DB.query((DBRoute)ROUNTE_FI, (SqlBuilder)allAccSQL, (ResultSetHandler)new ResultSetHandler<Boolean>(){

            public Boolean handle(ResultSet rs) throws Exception {
                while (rs.next()) {
                    try {
                        long accId = rs.getLong("id");
                        long useOrgId = rs.getLong("fuseorgid");
                        String number = rs.getString("fnumber");
                        String longNum = rs.getString("flongnumber");
                        int level = rs.getInt("flevel");
                        OrgAccountDoubleNode orgNode = (OrgAccountDoubleNode)orgAccNodeIndex.get(useOrgId);
                        if (null == orgNode) {
                            AccountPropChecker.this.pushFailedLog(useOrgId, "", "", ResManager.loadKDString((String)"\u8be5\u7ec4\u7ec7\u4e0d\u5728\u6838\u7b97\u7ec4\u7ec7\u89c6\u56fe\u5185\uff0c\u9700\u8981\u6e05\u7406\u3002", (String)"AccountPropChecker_0", (String)"fi-bd-formplugin", (Object[])new Object[0]));
                            continue;
                        }
                        String orgName = ((OrgVO)((BiTreeNode)AccountPropChecker.this.orgFastIndex.get(useOrgId)).getData()).getName();
                        AccountNodeWrap accNodeWrap = (AccountNodeWrap)orgNode.getData();
                        DynamicObject currentAccDy = (DynamicObject)accIndex.get(accId);
                        if (level == 1) {
                            if (null == accNodeWrap) {
                                accNodeWrap = new AccountNodeWrap(new BiTreeNode<String, DynamicObject>(number, currentAccDy));
                                accNodeWrap.refresh();
                                orgNode.setData(accNodeWrap);
                            } else if (AccountPropChecker.this.lessAccountByStartDate(accNodeWrap.getRoot().getData(), currentAccDy)) {
                                accNodeWrap.getRoot().setData(currentAccDy);
                            }
                        } else {
                            if (null == accNodeWrap) {
                                AccountPropChecker.this.pushFailedLog(useOrgId, orgName, number, ResManager.loadKDString((String)"\u8be5\u79d1\u76ee\u7684\u7236\u7ea7\u79d1\u76ee\u4e0d\u5b58\u5728\uff0c\u6216\u5df2\u5b58\u5728\u95ee\u9898\u3002", (String)"AccountPropChecker_1", (String)"fi-bd-formplugin", (Object[])new Object[0]));
                                continue;
                            }
                            String[] numSplits = longNum.split("_");
                            String parentNum = numSplits[numSplits.length - 2];
                            BiTreeNode<String, DynamicObject> accParentNode = accNodeWrap.getByNumber(parentNum);
                            if (null == accParentNode) {
                                AccountPropChecker.this.pushFailedLog(useOrgId, orgName, number, ResManager.loadKDString((String)"\u8be5\u79d1\u76ee\u7684\u7236\u7ea7\u79d1\u76ee\u4e0d\u5b58\u5728\u3002", (String)"AccountPropChecker_2", (String)"fi-bd-formplugin", (Object[])new Object[0]));
                                continue;
                            }
                            BiTreeNode<String, DynamicObject> accNode = accNodeWrap.getByNumber(number);
                            if (null == accNode) {
                                accNode = new BiTreeNode<String, DynamicObject>(number, currentAccDy);
                                accNode.setParent(accParentNode);
                            } else if (AccountPropChecker.this.lessAccountByStartDate(accNode.getData(), currentAccDy)) {
                                accNode.setData(currentAccDy);
                            }
                        }
                        accNodeWrap.refresh();
                    }
                    catch (Exception e) {
                        LOG.error("build_org_account_tree failed:" + e.getMessage(), (Throwable)e);
                        throw new KDBizException("build_org_account_tree failed:" + e.getMessage());
                    }
                }
                return true;
            }
        });
        if (!isBuildTreeSuccess) {
            LOG.info("failed to build org_account_double tree. ");
            return;
        }
        SqlBuilder sameAccNumsSQL = new SqlBuilder();
        sameAccNumsSQL.append("SELECT distinct(fnumber) FROM T_BD_ACCOUNT WHERE ", new Object[0]);
        sameAccNumsSQL.append(" faccounttableid = ?", new Object[]{accTableId});
        sameAccNumsSQL.append(" AND fnumber like ?", new Object[]{accNumber + "%"});
        List allLevelAccNums = (List)DB.query((DBRoute)ROUNTE_FI, (SqlBuilder)sameAccNumsSQL, (ResultSetHandler)new ResultSetHandler<List<String>>(){

            public List<String> handle(ResultSet rs) throws Exception {
                HashSet<String> numbers = new HashSet<String>(8);
                while (rs.next()) {
                    numbers.add(rs.getString("fnumber"));
                }
                return new ArrayList<String>(numbers);
            }
        });
        for (String one : allLevelAccNums) {
            LOG.info(" --- start to check acc number:" + one);
            try {
                this._checkNumber(one, orgAccRootNode);
            }
            catch (Exception e) {
                LOG.error("failed check account number: " + one + " on " + e.getMessage(), (Throwable)e);
                this.pushFailedLog(0L, ResManager.loadKDString((String)"\u5168\u90e8\u7ec4\u7ec7", (String)"AccountPropChecker_3", (String)"fi-bd-formplugin", (Object[])new Object[0]), one, ResManager.loadKDString((String)"\u7a0b\u5e8f\u5f02\u5e38", (String)"AccountPropChecker_4", (String)"fi-bd-formplugin", (Object[])new Object[0]));
            }
        }
    }

    private void _checkNumber(String accNumber, OrgAccountDoubleNode orgAccRootNode) {
        orgAccRootNode.preTravel(orgNode -> {
            try {
                DynamicObject dynamicObject;
                OrgAccountDoubleNode parentOrgAccNode;
                CheckedAccPair newPair;
                DynamicObject parentAccDy;
                CheckedAccPair checkedAccPair;
                if (null == orgNode.getData()) {
                    return;
                }
                BiTreeNode<String, DynamicObject> accNode = ((AccountNodeWrap)orgNode.getData()).getByNumber(accNumber);
                if (null == accNode) {
                    return;
                }
                long orgId = (Long)orgNode.getId();
                String orgName = this.orgFastIndex.get(orgId).getData().getName();
                DynamicObject currentAccountDy = accNode.getData();
                long currentAccId = currentAccountDy.getLong("id");
                Map<String, Object> currentProp = AccountVersionControlChecker.getAccountProp(currentAccountDy);
                if (null != accNode.getParent() && this.checkedPairs.add(checkedAccPair = new CheckedAccPair(currentAccId, (parentAccDy = (DynamicObject)accNode.getParent().getData()).getLong("id")))) {
                    String msgPrefix = String.format(ResManager.loadKDString((String)"\u4e0e\u5176\u4e0a\u7ea7\u79d1\u76ee %s \u6821\u9a8c:", (String)"AccountPropChecker_5", (String)"fi-bd-formplugin", (Object[])new Object[0]), parentAccDy.getString("number"));
                    Map<String, Object> parentProp = AccountVersionControlChecker.getAccountProp(parentAccDy);
                    Optional<String> errMsg = AccountVersionControlChecker.validateAccountControlRelation(currentProp, parentProp, AccountVersionControlChecker.AccPropType.allTypes());
                    if (errMsg.isPresent()) {
                        this.pushFailedLog(orgId, orgName, accNumber, msgPrefix + errMsg.get());
                    } else {
                        this.pushSuccessLog(orgId, orgName, accNumber, msgPrefix);
                    }
                }
                for (BiTreeNode biTreeNode : accNode.getChild()) {
                    newPair = new CheckedAccPair(((DynamicObject)biTreeNode.getData()).getLong("id"), currentAccId);
                    if (!this.checkedPairs.add(newPair)) continue;
                    String msgPrefix = String.format(ResManager.loadKDString((String)"\u4e0e\u5176\u4e0b\u7ea7\u79d1\u76ee %s \u6821\u9a8c: ", (String)"AccountPropChecker_6", (String)"fi-bd-formplugin", (Object[])new Object[0]), ((DynamicObject)biTreeNode.getData()).getString("number"));
                    Map<String, Object> childProp = AccountVersionControlChecker.getAccountProp((DynamicObject)biTreeNode.getData());
                    Optional<String> errMsg = AccountVersionControlChecker.validateAccountControlRelation(childProp, currentProp, AccountVersionControlChecker.AccPropType.allTypes());
                    if (errMsg.isPresent()) {
                        this.pushFailedLog(orgId, orgName, accNumber, errMsg.get());
                        continue;
                    }
                    this.pushSuccessLog(orgId, orgName, accNumber, msgPrefix);
                }
                if (null != orgNode.getParent() && null != (parentOrgAccNode = (OrgAccountDoubleNode)orgNode.getParent()).getData() && null != ((AccountNodeWrap)parentOrgAccNode.getData()).getByNumber(accNumber) && null != (dynamicObject = ((AccountNodeWrap)parentOrgAccNode.getData()).getByNumber(accNumber).getData()) && this.checkedPairs.add(newPair = new CheckedAccPair(currentAccId, dynamicObject.getLong("id")))) {
                    long parentOrgId = (Long)parentOrgAccNode.getId();
                    String parentOrgName = this.orgFastIndex.get(parentOrgId).getData().getName();
                    String msgPrefix = String.format(ResManager.loadKDString((String)"\u4e0e\u5176\u4e0a\u7ea7\u7ec4\u7ec7\uff1a%1$s \u79d1\u76ee %2$s \u6821\u9a8c: ", (String)"AccountPropChecker_7", (String)"fi-bd-formplugin", (Object[])new Object[0]), parentOrgName, accNumber);
                    Map<String, Object> parentOrgAccProp = AccountVersionControlChecker.getAccountProp(dynamicObject);
                    Optional<String> errMsg = AccountVersionControlChecker.validateAccountControlRelation(currentProp, parentOrgAccProp, AccountVersionControlChecker.AccPropType.allTypes());
                    if (errMsg.isPresent()) {
                        this.pushFailedLog(orgId, orgName, accNumber, msgPrefix + errMsg.get());
                    } else {
                        this.pushSuccessLog(orgId, orgName, accNumber, msgPrefix);
                    }
                }
                if (null != orgNode.getChild()) {
                    for (BiTreeNode biTreeNode : orgNode.getChild()) {
                        CheckedAccPair newPair3;
                        DynamicObject childOrgAccountDy;
                        OrgAccountDoubleNode childOrgNode = (OrgAccountDoubleNode)biTreeNode;
                        if (null == childOrgNode.getData() || null == ((AccountNodeWrap)childOrgNode.getData()).getByNumber(accNumber) || null == (childOrgAccountDy = ((AccountNodeWrap)childOrgNode.getData()).getByNumber(accNumber).getData()) || !this.checkedPairs.add(newPair3 = new CheckedAccPair(childOrgAccountDy.getLong("id"), currentAccId))) continue;
                        long childOrgId = (Long)childOrgNode.getId();
                        String childOrgName = this.orgFastIndex.get(childOrgId).getData().getName();
                        String msgPrefix = String.format(ResManager.loadKDString((String)"\u4e0e\u5176\u4e0b\u7ea7\u7ec4\u7ec7\uff1a%1$s \u79d1\u76ee %2$s \u6821\u9a8c: ", (String)"AccountPropChecker_8", (String)"fi-bd-formplugin", (Object[])new Object[0]), childOrgName, accNumber);
                        Map<String, Object> childOrgAccProp = AccountVersionControlChecker.getAccountProp(childOrgAccountDy);
                        Optional<String> errMsg = AccountVersionControlChecker.validateAccountControlRelation(childOrgAccProp, currentProp, AccountVersionControlChecker.AccPropType.allTypes());
                        if (errMsg.isPresent()) {
                            this.pushFailedLog(orgId, orgName, accNumber, msgPrefix + errMsg.get());
                            continue;
                        }
                        this.pushSuccessLog(orgId, orgName, accNumber, msgPrefix);
                    }
                }
            }
            catch (Exception e) {
                LOG.error("check prop failed on org: " + orgNode.getId() + " account: " + accNumber + " on cause: " + e.getMessage(), (Throwable)e);
                this.pushFailedLog((Long)orgNode.getId(), this.orgFastIndex.get(orgNode.getId()).getData().getName(), accNumber, ResManager.loadKDString((String)"\u7a0b\u5e8f\u5f02\u5e38", (String)"AccountPropChecker_9", (String)"fi-bd-formplugin", (Object[])new Object[0]));
            }
        });
    }

    private BaseDataVO.BaseOrgVO convert(BiTreeNode<Long, OrgVO> orgNode) {
        return new BaseDataVO.BaseOrgVO(orgNode.getId(), "", orgNode.getData().getName());
    }

    private boolean lessAccountByStartDate(DynamicObject first, DynamicObject second) {
        return first.getDate("startdate").getTime() < second.getDate("startdate").getTime();
    }

    private void pushSuccessLog(Long orgid, String orgName, String accNumber, String desc) {
        this.push(null == orgid ? 0L : orgid, orgName, accNumber, desc, true);
    }

    private void pushFailedLog(Long orgid, String orgName, String accNumber, String desc) {
        this.push(null == orgid ? 0L : orgid, orgName, accNumber, desc, false);
    }

    private void push(long orgId, String orgName, String accNumber, String desc, boolean isSuc) {
        this.checkLogs.add(new Object[]{DBServiceHelper.genGlobalLongId(), orgId, orgName, accNumber, isSuc ? "success" : "failed", desc, ResManager.loadKDString((String)"\u79d1\u76ee\u5c5e\u6027", (String)"AccountPropChecker_10", (String)"fi-bd-formplugin", (Object[])new Object[0])});
        if (this.checkLogs.size() > 100) {
            this.persistCheckLog();
        }
    }

    private void persistCheckLog() {
        if (!this.checkLogs.isEmpty()) {
            DB.executeBatch((DBRoute)DBRoute.of((String)"fi"), (String)"insert into t_bd_accountcheckrs( fid,forgid,forgname,faccountnumber,fresult,fdesc,ftype) values (?,?,?,?,?,?,?)", this.checkLogs);
        }
    }

    private static class CheckedAccPair {
        private long upAccId;
        private long downAccId;

        public CheckedAccPair(long downAccId, long upAccId) {
            this.upAccId = upAccId;
            this.downAccId = downAccId;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            CheckedAccPair that = (CheckedAccPair)o;
            return this.upAccId == that.upAccId && this.downAccId == that.downAccId;
        }

        public int hashCode() {
            return Objects.hash(this.upAccId, this.downAccId);
        }
    }
}

