/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bd.checktools.account.check.service;

import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.SqlBuilder;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.fi.bd.checktools.account.check.AbstractCheckSubscribeService;
import kd.fi.bd.checktools.account.check.ControlCheckCtx;
import kd.fi.bd.util.AccountVersionUtil;
import kd.fi.bd.util.TaskExecutionResult;
import kd.fi.bd.vo.AccountOrgPairVO;

public class FirstLevelSubscribeServiceImpl
extends AbstractCheckSubscribeService {
    public FirstLevelSubscribeServiceImpl(ControlCheckCtx ctx) {
        super(ctx);
        DynamicObject accounttable = QueryServiceHelper.queryOne((String)"bd_accounttable", (String)"org_id", (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)ctx.getAccountTableId())});
        ctx.setTopOrgId(accounttable.getLong("org_id"));
    }

    @Override
    protected boolean process() {
        SqlBuilder sqlBuilder = new SqlBuilder();
        sqlBuilder.append(" select fid,fnumber,forgid from t_bd_account where fid = fmasterid ", new Object[0]);
        sqlBuilder.append(" and faccounttableid = ? ", new Object[]{this.ctx.getAccountTableId()});
        sqlBuilder.append(" and forgid != ? ", new Object[]{this.ctx.getTopOrgId()});
        sqlBuilder.append(" and flevel = ? ", new Object[]{1});
        sqlBuilder.append(" and fstartdate = ? ", new Object[]{AccountVersionUtil.getInitBeginDate()});
        try (DataSet dataSet = DB.queryDataSet((String)"FirstLevelSubscribeServiceImpl", (DBRoute)DB_ROUTE, (SqlBuilder)sqlBuilder);){
            for (Row row : dataSet) {
                String number = row.getString("fnumber");
                long orgId = row.getLong("forgid");
                DynamicObject bosOrg = this.ctx.getOrgById(orgId);
                if (null == bosOrg) {
                    AccountOrgPairVO accountOrgPairVO = new AccountOrgPairVO("", orgId);
                    this.ctx.addTaskExecutionResult(TaskExecutionResult.failed(accountOrgPairVO, ResManager.loadKDString((String)"\u7ec4\u7ec7\u4e0d\u5b58\u5728", (String)"FirstLevelSubscribeServiceImpl_2", (String)"fi-bd-common", (Object[])new Object[0]), ResManager.loadKDString((String)"\u7ec4\u7ec7\u4e0d\u5b58\u5728", (String)"FirstLevelSubscribeServiceImpl_2", (String)"fi-bd-common", (Object[])new Object[0])));
                    continue;
                }
                String resultTip = String.format(ResManager.loadKDString((String)"\u7ec4\u7ec7'%1$s'\u7684'%2$s'\u79d1\u76ee\uff0c\u975e\u5f53\u524d\u79d1\u76ee\u8868\u521b\u5efa\u7ec4\u7ec7\u521b\u5efa\u3002", (String)"FirstLevelSubscribeServiceImpl_1", (String)"fi-bd-common", (Object[])new Object[0]), bosOrg.getString("name") + "(" + bosOrg.getString("number") + ")", number);
                AccountOrgPairVO accountOrgPairVO = new AccountOrgPairVO(number, orgId);
                accountOrgPairVO.setOrgName(bosOrg.getString("name"));
                this.ctx.addTaskExecutionResult(TaskExecutionResult.failed(accountOrgPairVO, resultTip, ResManager.loadKDString((String)"\u79d1\u76ee\u540d\u79f0", (String)"FirstLevelSubscribeServiceImpl_3", (String)"fi-bd-common", (Object[])new Object[0])));
            }
        }
        return true;
    }
}

