/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bd.checktools.account.check.service;

import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.SqlBuilder;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.fi.bd.checktools.account.check.AbstractCheckSubscribeService;
import kd.fi.bd.checktools.account.check.ControlCheckCtx;
import kd.fi.bd.util.AccountVersionUtil;
import kd.fi.bd.util.TaskExecutionResult;
import kd.fi.bd.vo.AccountOrgPairVO;

public class LeafCheckSubscribeServiceImpl
extends AbstractCheckSubscribeService {
    private Log logger = LogFactory.getLog(LeafCheckSubscribeServiceImpl.class);

    public LeafCheckSubscribeServiceImpl(ControlCheckCtx ctx) {
        super(ctx);
    }

    @Override
    protected boolean process() {
        SqlBuilder sql = new SqlBuilder();
        sql.append(" select su.fuseorgid as suseorgid,pa.fid as pid, pa.fmasterid as pmasterid,pa.fnumber as pnumber,sa.FNUMBER as snumber,sa.fid as sid,sa.fparentid as sparentid,pa.fisleaf ", new Object[0]);
        sql.append(" from t_bd_account_u pu ", new Object[0]);
        sql.append(" inner join t_bd_account pa on pu.fdataid=pa.fid ", new Object[0]);
        sql.append(" inner join t_bd_account sa on sa.fparentid=pa.FID", new Object[0]);
        sql.append(" inner join t_bd_account_u su on pu.fuseorgid=su.FUseOrgID and su.fdataid=sa.fid ", new Object[0]);
        sql.append(" where pa.FNUMBER is not null and pa.fisleaf = ? ", new Object[]{true});
        sql.append(" and pa.fcreateorgid=sa.fcreateorgid ", new Object[0]);
        sql.append(" and pa.fenddate=? ", new Object[]{AccountVersionUtil.getEndDate()});
        sql.append(" and sa.fenddate=? ", new Object[]{AccountVersionUtil.getEndDate()});
        sql.append(" and pa.faccounttableid = ? ", new Object[]{this.ctx.getAccountTableId()});
        sql.append(" and sa.faccounttableid = ? ", new Object[]{this.ctx.getAccountTableId()});
        try (DataSet dataSet = DB.queryDataSet((String)"LongNumberCheckSubscribeServiceImpl", (DBRoute)DB_ROUTE, (SqlBuilder)sql);){
            for (Row row : dataSet) {
                String pnumber;
                long fuseorgid = row.getLong("suseorgid");
                if (!this.checkLasterVerIsLeaf(fuseorgid, pnumber = row.getString("pnumber"))) continue;
                DynamicObject bosOrg = this.ctx.getOrgById(fuseorgid);
                if (null == bosOrg) {
                    AccountOrgPairVO accountOrgPairVO = new AccountOrgPairVO("", fuseorgid);
                    this.ctx.addTaskExecutionResult(TaskExecutionResult.failed(accountOrgPairVO, ResManager.loadKDString((String)"\u7ec4\u7ec7\u4e0d\u5b58\u5728", (String)"RelationIncompleteChecksServiceImpl_2", (String)"fi-bd-formplugin", (Object[])new Object[0]), ResManager.loadKDString((String)"\u7ec4\u7ec7\u4e0d\u5b58\u5728", (String)"RelationIncompleteChecksServiceImpl_2", (String)"fi-bd-formplugin", (Object[])new Object[0])));
                    continue;
                }
                String resultTip = String.format(ResManager.loadKDString((String)"\u7ec4\u7ec7\u201c%s\u201d\u7684\u201c%1$s\u201d\u79d1\u76ee\u4e0e\u7ec4\u7ec7\u201c%2$s\u201d\u7684\u201c%3$s\u201d\u79d1\u76ee\u4e0d\u6ee1\u8db3\u7ba1\u63a7\u5173\u7cfb\uff0c\u4e0a\u4e0b\u7ea7\u90fd\u662f\u660e\u7ec6\u3002", (String)"LeafChecksServiceImpl_1", (String)"fi-bd-formplugin", (Object[])new Object[0]), bosOrg.getString("name") + "(" + bosOrg.getString("number") + ")", pnumber + "(" + pnumber + ")", bosOrg.getString("name") + "(" + bosOrg.getString("number") + ")", row.getString("snumber") + "(" + row.getString("snumber") + ")");
                AccountOrgPairVO accountOrgPairVO = new AccountOrgPairVO(pnumber, fuseorgid);
                accountOrgPairVO.setOrgName(bosOrg.getString("name"));
                this.ctx.addTaskExecutionResult(TaskExecutionResult.failed(accountOrgPairVO, resultTip, ResManager.loadKDString((String)"\u4e0a\u4e0b\u7ea7\u7ec4\u7ec7\u76f8\u540c\u79d1\u76ee", (String)"LeafChecksServiceImpl_2", (String)"fi-bd-formplugin", (Object[])new Object[0])));
            }
        }
        return true;
    }

    private boolean checkLasterVerIsLeaf(long fuseorgid, String fnumber) {
        boolean hasNext = false;
        SqlBuilder sql = new SqlBuilder();
        sql.append(" select a.fid from t_bd_account_u as u ", new Object[0]);
        sql.append(" inner join t_bd_account as a on u.fdataid=a.fid ", new Object[0]);
        sql.append(" where u.fuseorgid = ? ", new Object[]{fuseorgid});
        sql.append(" and a.FNUMBER = ? ", new Object[]{fnumber});
        sql.append(" and a.fenddate=? ", new Object[]{AccountVersionUtil.getEndDate()});
        sql.append(" and a.faccounttableid = ? ", new Object[]{this.ctx.getAccountTableId()});
        sql.append(" and a.fisleaf = ? ", new Object[]{true});
        try (DataSet dataSet = DB.queryDataSet((String)"LeafCheckSubscribeServiceImpl", (DBRoute)DB_ROUTE, (SqlBuilder)sql);){
            hasNext = dataSet.hasNext();
        }
        return hasNext;
    }
}

