/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bd.checktools.account.check.service;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.SqlBuilder;
import kd.bos.orm.query.QFilter;
import kd.fi.bd.checktools.account.check.AbstractCheckSubscribeService;
import kd.fi.bd.checktools.account.check.ControlCheckCtx;
import kd.fi.bd.util.AccountUtils;
import kd.fi.bd.util.AccountVersionUtil;
import kd.fi.bd.util.TaskExecutionResult;
import kd.fi.bd.vo.AccountOrgPairVO;

public class RelationIncompleteCheckSubscribeServiceImpl
extends AbstractCheckSubscribeService {
    public RelationIncompleteCheckSubscribeServiceImpl(ControlCheckCtx ctx) {
        super(ctx);
    }

    @Override
    protected boolean process() {
        this.checkIsMissingUpperOrLower();
        return true;
    }

    private void checkIsMissingUpperOrLower() {
        SqlBuilder sb = new SqlBuilder();
        sb.append(" select fuseorgid from t_bd_accountusereg group by fuseorgid ", new Object[0]);
        try (DataSet dataSet = DB.queryDataSet((String)"RelationIncompleteCheckSubscribeServiceImpl", (DBRoute)DB_ROUTE, (SqlBuilder)sb);){
            for (Row row : dataSet) {
                this.checkIsMissingUpperOrLowerByOrgId(row.getLong("fuseorgid"));
            }
        }
    }

    private void checkIsMissingUpperOrLowerByOrgId(Long fuseorgid) {
        DynamicObject bosOrg = this.ctx.getOrgById(fuseorgid);
        if (null == bosOrg) {
            AccountOrgPairVO accountOrgPairVO = new AccountOrgPairVO("", fuseorgid);
            this.ctx.addTaskExecutionResult(TaskExecutionResult.failed(accountOrgPairVO, ResManager.loadKDString((String)"\u7ec4\u7ec7\u4e0d\u5b58\u5728", (String)"RelationIncompleteChecksServiceImpl_2", (String)"fi-bd-formplugin", (Object[])new Object[0]), ResManager.loadKDString((String)"\u7ec4\u7ec7\u4e0d\u5b58\u5728", (String)"RelationIncompleteChecksServiceImpl_2", (String)"fi-bd-formplugin", (Object[])new Object[0])));
            return;
        }
        ArrayList<QFilter> filters = new ArrayList<QFilter>(10);
        filters.add(new QFilter("enddate", "=", (Object)AccountVersionUtil.getEndDate()));
        HashSet<String> numberSet = new HashSet<String>(1000);
        HashSet longNumberSplitSet = new HashSet(1000);
        try (DataSet dataSet = AccountUtils.queryAccountDataSet(fuseorgid, this.ctx.getAccountTableId(), "number,longnumber", filters);){
            for (Row row : dataSet) {
                numberSet.add(row.getString("number"));
                String flongnumber = row.getString("longnumber");
                String[] split = flongnumber.split("_");
                Collections.addAll(longNumberSplitSet, split);
            }
        }
        for (String numberSplit : longNumberSplitSet) {
            if (numberSet.contains(numberSplit)) continue;
            String resultTip = String.format(ResManager.loadKDString((String)"\u7ec4\u7ec7\u201c%1$s\u201d\u7f3a\u5c11\u201c%2$s\u201d\u79d1\u76ee\u3002", (String)"RelationIncompleteChecksServiceImpl_1", (String)"fi-bd-formplugin", (Object[])new Object[0]), bosOrg.getString("name") + "(" + bosOrg.getString("number") + ")", numberSplit + "(" + numberSplit + ")");
            AccountOrgPairVO accountOrgPairVO = new AccountOrgPairVO(numberSplit, fuseorgid);
            accountOrgPairVO.setOrgName(bosOrg.getString("name"));
            this.ctx.addTaskExecutionResult(TaskExecutionResult.failed(accountOrgPairVO, resultTip, ResManager.loadKDString((String)"\u79d1\u76ee\u7f3a\u5931", (String)"RelationIncompleteChecksServiceImpl_3", (String)"fi-bd-formplugin", (Object[])new Object[0])));
        }
    }
}

