/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bd.checktools.account.check.service;

import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.SqlBuilder;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.fi.bd.checktools.account.check.AbstractCheckSubscribeService;
import kd.fi.bd.checktools.account.check.ControlCheckCtx;
import kd.fi.bd.util.AccountVersionUtil;
import kd.fi.bd.util.TaskExecutionResult;
import kd.fi.bd.vo.AccountOrgPairVO;

public class RepeatAccountCheckSubscribeServiceImpl
extends AbstractCheckSubscribeService {
    private Log logger = LogFactory.getLog(RepeatAccountCheckSubscribeServiceImpl.class);

    public RepeatAccountCheckSubscribeServiceImpl(ControlCheckCtx ctx) {
        super(ctx);
    }

    @Override
    protected boolean process() {
        SqlBuilder sql = new SqlBuilder();
        sql.append(" select u.fuseorgid,a.fnumber,count(a.fnumber) as fnumbercount ", new Object[0]);
        sql.append(" from T_BD_ACCOUNT_u as u", new Object[0]);
        sql.append(" inner join t_bd_account as a on u.fdataid=a.fid ", new Object[0]);
        sql.append(" where a.fenddate = ? ", new Object[]{AccountVersionUtil.getEndDate()});
        sql.append(" and a.faccounttableid = ?", new Object[]{this.ctx.getAccountTableId()});
        sql.append(" and a.fenable = ?", new Object[]{"1"});
        sql.append(" group by a.fnumber,u.fuseorgid", new Object[0]);
        sql.append(" having count(a.fnumber)>1", new Object[0]);
        try (DataSet dataSet = DB.queryDataSet((String)"LongNumberCheckSubscribeServiceImpl", (DBRoute)DB_ROUTE, (SqlBuilder)sql);){
            for (Row row : dataSet) {
                DynamicObject bosOrg = this.ctx.getOrgById(row.getLong("fuseorgid"));
                if (null == bosOrg) {
                    AccountOrgPairVO accountOrgPairVO = new AccountOrgPairVO("", row.getLong("fcreateorgid"));
                    this.ctx.addTaskExecutionResult(TaskExecutionResult.failed(accountOrgPairVO, ResManager.loadKDString((String)"\u7ec4\u7ec7\u4e0d\u5b58\u5728", (String)"RelationIncompleteChecksServiceImpl_2", (String)"fi-bd-formplugin", (Object[])new Object[0]), ResManager.loadKDString((String)"\u7ec4\u7ec7\u4e0d\u5b58\u5728", (String)"RelationIncompleteChecksServiceImpl_2", (String)"fi-bd-formplugin", (Object[])new Object[0])));
                    continue;
                }
                String resultTip = String.format(ResManager.loadKDString((String)"\u7ec4\u7ec7\u201c%1$s\u201d\u7684\u201c%2$s\u201d\u79d1\u76ee\u91cd\u590d\uff1a%3$s\u6b21\u3002", (String)"RepeatAccountChecksServiceImpl_1", (String)"fi-bd-formplugin", (Object[])new Object[0]), bosOrg.getString("name") + "(" + bosOrg.getString("number") + ")", row.getString("fnumber") + "(" + row.getString("fnumber") + ")", row.getInteger("fnumbercount") + "(" + row.getInteger("fnumbercount") + ")");
                AccountOrgPairVO accountOrgPairVO = new AccountOrgPairVO(row.getString("fnumber"), row.getLong("fuseorgid"));
                accountOrgPairVO.setOrgName(bosOrg.getString("name"));
                this.ctx.addTaskExecutionResult(TaskExecutionResult.failed(accountOrgPairVO, resultTip, ResManager.loadKDString((String)"\u79d1\u76ee\u91cd\u590d", (String)"RepeatAccountChecksServiceImpl_2", (String)"fi-bd-formplugin", (Object[])new Object[0])));
            }
        }
        return true;
    }
}

