/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bd.checktools.account.check.service;

import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.SqlBuilder;
import kd.fi.bd.checktools.account.check.AbstractCheckSubscribeService;
import kd.fi.bd.checktools.account.check.ControlCheckCtx;
import kd.fi.bd.util.TaskExecutionResult;
import kd.fi.bd.vo.AccountOrgPairVO;

public class UseRangeExcCheckSubscribeServiceImpl
extends AbstractCheckSubscribeService {
    public UseRangeExcCheckSubscribeServiceImpl(ControlCheckCtx ctx) {
        super(ctx);
    }

    @Override
    protected boolean process() {
        this.doCheck();
        return true;
    }

    private void doCheck() {
        SqlBuilder sql = new SqlBuilder();
        sql.append(" select ea.fcreateorgid,ea.fnumber,ea.flongnumber ", new Object[0]);
        sql.append(" from t_bd_accountexc as ec ", new Object[0]);
        sql.append(" inner join t_Bd_account as ea on ec.fdataid=ea.fid", new Object[0]);
        sql.append(" where ea.faccounttableid = ? ", new Object[]{this.ctx.getAccountTableId()});
        sql.append(" and not exists ( ", new Object[0]);
        sql.append("   select 1 from t_bd_account_u as uc", new Object[0]);
        sql.append("   inner join t_Bd_account as ua on uc.fdataid=ua.fid", new Object[0]);
        sql.append("   where uc.fuseorgid =ec.fuseorgid ", new Object[0]);
        sql.append("   and ua.fnumber = ea.fnumber ", new Object[0]);
        sql.append("   and ua.faccounttableid = ea.faccounttableid", new Object[0]);
        sql.append(" ) ", new Object[0]);
        try (DataSet dataSet = DB.queryDataSet((String)"UseRangeExcCheckSubscribeServiceImpl", (DBRoute)DB_ROUTE, (SqlBuilder)sql);){
            for (Row row : dataSet) {
                DynamicObject bosOrg = this.ctx.getOrgById(row.getLong("fcreateorgid"));
                if (null == bosOrg) {
                    AccountOrgPairVO accountOrgPairVO = new AccountOrgPairVO("", row.getLong("fcreateorgid"));
                    this.ctx.addTaskExecutionResult(TaskExecutionResult.failed(accountOrgPairVO, ResManager.loadKDString((String)"\u7ec4\u7ec7\u4e0d\u5b58\u5728", (String)"RelationIncompleteChecksServiceImpl_2", (String)"fi-bd-formplugin", (Object[])new Object[0]), ResManager.loadKDString((String)"\u7ec4\u7ec7\u4e0d\u5b58\u5728", (String)"RelationIncompleteChecksServiceImpl_2", (String)"fi-bd-formplugin", (Object[])new Object[0])));
                    continue;
                }
                String resultTip = String.format(ResManager.loadKDString((String)"\u7ec4\u7ec7\u201c%1$s\u201d\u7684\u79d1\u76ee\u201c%2$s\u201d\u5728\u6392\u9664\u8868\u4f46\u4e0d\u5728\u4f7f\u7528\u8868\u4e2d\u3002", (String)"UseRangeExcCheckSubscribeServiceImpl_1", (String)"fi-bd-common", (Object[])new Object[0]), bosOrg.getString("name") + "(" + bosOrg.getString("number") + ")", row.getString("fnumber") + "(" + row.getString("fnumber") + ")");
                AccountOrgPairVO accountOrgPairVO = new AccountOrgPairVO(row.getString("fnumber"), row.getLong("fcreateorgid"));
                accountOrgPairVO.setOrgName(bosOrg.getString("name"));
                this.ctx.addTaskExecutionResult(TaskExecutionResult.failed(accountOrgPairVO, resultTip, ResManager.loadKDString((String)"\u4f7f\u7528\u8868\u548c\u6392\u9664\u8868\u77db\u76fe\u7684\u9519\u8bef\u6570\u636e\u3002", (String)"UseRangeExcCheckSubscribeServiceImpl_2", (String)"fi-bd-common", (Object[])new Object[0])));
            }
        }
    }
}

