/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bd.checktools.account.check.service;

import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.SqlBuilder;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.util.CollectionUtils;
import kd.fi.bd.checktools.account.check.AbstractCheckSubscribeService;
import kd.fi.bd.checktools.account.check.ControlCheckCtx;
import kd.fi.bd.util.AccountVersionUtil;
import kd.fi.bd.util.TaskExecutionResult;
import kd.fi.bd.vo.AccountOrgPairVO;

public class VersionDateCheckSubscribeServiceImpl
extends AbstractCheckSubscribeService {
    private Log logger = LogFactory.getLog(VersionDateCheckSubscribeServiceImpl.class);

    public VersionDateCheckSubscribeServiceImpl(ControlCheckCtx ctx) {
        super(ctx);
    }

    @Override
    protected boolean process() {
        this.versionDateCheck();
        return true;
    }

    private void versionDateCheck() {
        SqlBuilder sb = new SqlBuilder();
        sb.append(" select fuseorgid from t_bd_accountusereg group by fuseorgid ", new Object[0]);
        try (DataSet dataSet = DB.queryDataSet((String)"RelationIncompleteCheckSubscribeServiceImpl", (DBRoute)DB_ROUTE, (SqlBuilder)sb);){
            for (Row row : dataSet) {
                this.versionDateCheckByOrg(row.getLong("fuseorgid"));
            }
        }
    }

    private void versionDateCheckByOrg(Long fuseorgid) {
        DynamicObject bosOrg = this.ctx.getOrgById(fuseorgid);
        if (null == bosOrg) {
            AccountOrgPairVO accountOrgPairVO = new AccountOrgPairVO("", fuseorgid);
            this.ctx.addTaskExecutionResult(TaskExecutionResult.failed(accountOrgPairVO, ResManager.loadKDString((String)"\u7ec4\u7ec7\u4e0d\u5b58\u5728", (String)"RelationIncompleteChecksServiceImpl_2", (String)"fi-bd-formplugin", (Object[])new Object[0]), ResManager.loadKDString((String)"\u7ec4\u7ec7\u4e0d\u5b58\u5728", (String)"RelationIncompleteChecksServiceImpl_2", (String)"fi-bd-formplugin", (Object[])new Object[0])));
            return;
        }
        SqlBuilder sb = new SqlBuilder();
        sb.append(" select a.fnumber, a.fstartdate, a.fenddate  ", new Object[0]);
        sb.append(" from T_BD_ACCOUNT_u as u ", new Object[0]);
        sb.append(" inner join t_bd_account as a on u.fdataid=a.fid ", new Object[0]);
        sb.append(" where u.fuseorgid = ? ", new Object[]{fuseorgid});
        sb.append(" and a.faccounttableid = ? ", new Object[]{this.ctx.getAccountTableId()});
        HashMap<String, Map> accountDate = new HashMap<String, Map>(16);
        try (DataSet dataSet = DB.queryDataSet((String)"RelationIncompleteCheckSubscribeServiceImpl", (DBRoute)DB_ROUTE, (SqlBuilder)sb);){
            for (Row row : dataSet) {
                accountDate.computeIfAbsent(row.getString("fnumber"), k -> new HashMap(10)).computeIfAbsent(row.getDate("fstartdate"), k -> new HashSet(8)).add(row.getDate("fenddate"));
            }
        }
        for (Map.Entry entry : accountDate.entrySet()) {
            this.test(fuseorgid, bosOrg, (String)entry.getKey(), (Map)entry.getValue());
        }
    }

    private void test(Long fuseorgid, DynamicObject bosOrg, String fnumber, Map<Date, Set<Date>> dateMap) {
        boolean isMaxDate = dateMap.entrySet().stream().anyMatch(x -> ((Set)x.getValue()).contains(AccountVersionUtil.getEndDate()));
        if (!isMaxDate) {
            String resultTip = String.format(ResManager.loadKDString((String)"\u7ec4\u7ec7\u201c%1$s\u201d\u7684\u201c%2$s\u201d\u79d1\u76ee\u7248\u672c\u5316\u65e5\u671f\u5b58\u5728\u95ee\u9898\uff0c\u7f3a\u59312999-12-31\u3002", (String)"VersionDateChecksServiceImpl_1", (String)"fi-bd-formplugin", (Object[])new Object[0]), bosOrg.getString("name") + "(" + bosOrg.getString("number") + ")", fnumber + "(" + fnumber + ")");
            AccountOrgPairVO accountOrgPairVO = new AccountOrgPairVO(fnumber, fuseorgid);
            accountOrgPairVO.setOrgName(bosOrg.getString("name"));
            this.ctx.addTaskExecutionResult(TaskExecutionResult.failed(accountOrgPairVO, resultTip, ResManager.loadKDString((String)"\u79d1\u76ee\u7248\u672c\u5316\u65e5\u671f", (String)"VersionDateChecksServiceImpl_3", (String)"fi-bd-formplugin", (Object[])new Object[0])));
        }
        for (Map.Entry<Date, Set<Date>> dateEntry : dateMap.entrySet()) {
            Set<Date> fenddateSet = dateEntry.getValue();
            if (CollectionUtils.isEmpty(fenddateSet)) continue;
            for (Date fenddate : fenddateSet) {
                if (fenddate.compareTo(AccountVersionUtil.getEndDate()) == 0 || dateMap.containsKey(fenddate)) continue;
                String resultTip = String.format(ResManager.loadKDString((String)"\u7ec4\u7ec7\u201c%1$s\u201d\u7684\u201c%2$s\u201d\u79d1\u76ee\u7248\u672c\u5316\u65e5\u671f\u5b58\u5728\u95ee\u9898\uff0c\u7248\u672c\u5316\u65e5\u671f\u4e0d\u6b63\u786e\u3002", (String)"VersionDateChecksServiceImpl_2", (String)"fi-bd-formplugin", (Object[])new Object[0]), bosOrg.getString("name") + "(" + bosOrg.getString("number") + ")", fnumber + "(" + fnumber + ")");
                AccountOrgPairVO accountOrgPairVO = new AccountOrgPairVO(fnumber, fuseorgid);
                accountOrgPairVO.setOrgName(bosOrg.getString("name"));
                this.ctx.addTaskExecutionResult(TaskExecutionResult.failed(accountOrgPairVO, resultTip, ResManager.loadKDString((String)"\u79d1\u76ee\u7248\u672c\u5316\u65e5\u671f", (String)"VersionDateChecksServiceImpl_3", (String)"fi-bd-formplugin", (Object[])new Object[0])));
                return;
            }
        }
    }
}

