/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bd.consts;

import com.google.common.collect.ImmutableSet;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.fi.bd.cache.CacheModule;
import kd.fi.bd.cache.cacheservice.IDataLocalCache;

public class AccountType {
    private static final IDataLocalCache typeLocalCache = IDataLocalCache.getCache(CacheModule.accountType, 60);
    public static final String ENTITY = "bd_accounttype";
    public static final String ASSETS = "0";
    public static final String LIABILITIES = "1";
    public static final String RIGHTSINTERESTS = "2";
    public static final String COST = "3";
    public static final String PROFITLOSS = "4";
    public static final String BW = "5";
    public static final String COMMON = "6";
    public static final String OTHER = "7";
    public static final String BUDGET_INCOME = "A";
    public static final String BUDGET_EXPENSE = "B";
    public static final String BUDGET_SURPLUS = "C";
    public static final String[] FINANCIAL_ACCOUNT = new String[]{"0", "1", "2", "3", "4", "5", "6", "7"};
    public static final String[] BUDGET_ACCOUNT = new String[]{"A", "B", "C"};
    public static final String KEY_ACCOUNT_TYPE = "accounttype";
    public static final String KEY_ACCOUNT_TABLE = "accounttableid";
    private static final Set<String> BUDGET_PROPS = ImmutableSet.of((Object)"A", (Object)"B", (Object)"C");

    public static boolean isBudGetType(String accountType) {
        return BUDGET_INCOME.equals(accountType) || BUDGET_EXPENSE.equals(accountType) || BUDGET_SURPLUS.equals(accountType);
    }

    public static boolean isBudgetProp(String propVal) {
        return BUDGET_PROPS.contains(propVal);
    }

    public static boolean isBudgetType(long accountTypeId) {
        return AccountType.isBudgetProp(AccountType.fromAccountTypeId(accountTypeId));
    }

    public static String fromAccountTypeId(long accountTypeId) {
        String result = typeLocalCache.get(String.valueOf(accountTypeId), String.class);
        if (result != null) {
            return result;
        }
        DynamicObject accountTypeDyn = BusinessDataServiceHelper.loadSingleFromCache((Object)accountTypeId, (String)ENTITY, (String)KEY_ACCOUNT_TYPE);
        result = accountTypeDyn == null ? "" : accountTypeDyn.getString(KEY_ACCOUNT_TYPE);
        typeLocalCache.put(String.valueOf(accountTypeId), result);
        return result;
    }

    public static QFilter buildNonBudgetFilter() {
        String accountPropKey = String.join((CharSequence)".", KEY_ACCOUNT_TYPE, KEY_ACCOUNT_TYPE);
        return new QFilter(accountPropKey, "not in", BUDGET_PROPS);
    }
}

