/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bd.consts;

import com.google.common.collect.Sets;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.orm.query.QFilter;
import kd.bos.util.CollectionUtils;
import kd.fi.bd.util.filter.QFilterBuilder;

public class VoucherStatus {
    public static final String TEMP = "A";
    public static final String SUBMITTED = "B";
    public static final String AUDITTED = "C";
    public static final String CANCELLED = "D";
    public static final String NONCHECK = "a";
    public static final String UNCHECK = "b";
    public static final String CHECKED = "c";
    public static final String HAS_ERROR = "1";
    public static final String NO_ERROR = "0";

    public static boolean canModify(DynamicObject voucherDyn) {
        String billStatus = voucherDyn.getString("billstatus");
        String checkStatus = voucherDyn.getString("ischeck");
        boolean reverseVoucher = voucherDyn.getBoolean("isreverse");
        return !(!TEMP.equals(billStatus) && !SUBMITTED.equals(billStatus) || !NONCHECK.equals(checkStatus) && !UNCHECK.equals(checkStatus) || reverseVoucher);
    }

    public static String[] allBillStatus() {
        return new String[]{TEMP, SUBMITTED, CANCELLED, AUDITTED};
    }

    public static boolean notSubmitted(Collection<String> status) {
        return CollectionUtils.isNotEmpty(status) && status.stream().noneMatch(x -> SUBMITTED.equalsIgnoreCase((String)x) || AUDITTED.equalsIgnoreCase((String)x));
    }

    public static boolean isFilterNotSubmittedVoucher(QFilter filter) {
        return VoucherStatus.notSubmitted(VoucherStatus.parseStatusInFilter(filter));
    }

    public static Set<String> parseStatusInFilter(QFilter filter) {
        String cp = filter.getCP();
        HashSet<String> statusSet = new HashSet<String>(4);
        HashSet allStatusSet = Sets.newHashSet((Object[])VoucherStatus.allBillStatus());
        QFilterBuilder.parseContainerValues(filter.getValue(), x -> {
            String status = x.toString();
            if (allStatusSet.contains(status)) {
                statusSet.add(status);
            }
        });
        switch (cp) {
            case "in": 
            case "=": {
                return statusSet;
            }
            case "not in": 
            case "!=": {
                allStatusSet.removeIf(statusSet::contains);
                return allStatusSet;
            }
            case "is not null": {
                return allStatusSet;
            }
        }
        return Collections.emptySet();
    }
}

