/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bd.enhance.treetask;

import java.io.Serializable;
import java.util.Objects;
import java.util.concurrent.locks.ReentrantLock;
import kd.bos.cache.ThreadCache;
import kd.bos.dataentity.Tuple;
import kd.fi.bd.accversion.AssistAddingContext;
import kd.fi.bd.cache.CacheHelper;
import kd.fi.bd.cache.CacheModule;
import kd.fi.bd.cache.DistributeCache;
import kd.fi.bd.enhance.treetask.ITaskContext;
import kd.fi.bd.util.BiTreeNode;
import kd.fi.bd.util.TaskExecutionResult;
import kd.fi.bd.vo.AccountOrgPairVO;
import kd.fi.bd.vo.AccountVO;
import kd.fi.bd.vo.OrgVO;

public class AccountContext
implements ITaskContext<Tuple<BiTreeNode<String, AccountVO>, BiTreeNode<Long, OrgVO>>, TaskExecutionResult<AccountOrgPairVO>>,
Serializable {
    private DistributeCache cache = CacheHelper.getDistributeCache(CacheModule.addingassit);
    private BiTreeNode<String, AccountContext> bindNode;
    private ReentrantLock lock = new ReentrantLock();
    private final Tuple<BiTreeNode<String, AccountVO>, BiTreeNode<Long, OrgVO>> accountOrgInfo;
    private final AssistAddingContext assistAddingContext;
    private TaskExecutionResult executionResult;

    public AccountContext(AssistAddingContext assistAddingContext, Tuple<BiTreeNode<String, AccountVO>, BiTreeNode<Long, OrgVO>> accountOrgInfo) {
        this.assistAddingContext = assistAddingContext;
        this.accountOrgInfo = accountOrgInfo;
    }

    public String getAccountNumber() {
        return (String)((BiTreeNode)this.accountOrgInfo.item1).getId();
    }

    public long getOrgId() {
        return (Long)((BiTreeNode)this.accountOrgInfo.item2).getId();
    }

    @Override
    public Tuple<BiTreeNode<String, AccountVO>, BiTreeNode<Long, OrgVO>> getData() {
        return this.accountOrgInfo;
    }

    @Override
    public <T extends ITaskContext<Tuple<BiTreeNode<String, AccountVO>, BiTreeNode<Long, OrgVO>>, TaskExecutionResult<AccountOrgPairVO>>> void bindNode(BiTreeNode<String, T> bindNode) {
        this.bindNode = bindNode;
    }

    @Override
    public BiTreeNode<String, AccountContext> getBindNode() {
        return this.bindNode;
    }

    @Override
    public TaskExecutionResult<AccountOrgPairVO> getExecutionResult() {
        return this.executionResult;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setExecutionResult(TaskExecutionResult<AccountOrgPairVO> result) {
        try {
            this.lock.lock();
            this.executionResult = result;
            String pageId = (String)ThreadCache.get((Object)"viewPageId");
            String finishedCountCacheKey = pageId + "finishedCount";
            if (Objects.nonNull(this.cache.get(finishedCountCacheKey))) {
                int finishedCount = Integer.parseInt(this.cache.get(finishedCountCacheKey));
                this.cache.put(finishedCountCacheKey, String.format("%s", finishedCount + 1));
            }
        }
        finally {
            this.lock.unlock();
        }
    }

    public AssistAddingContext getAssistAddingContext() {
        return this.assistAddingContext;
    }

    public String toString() {
        return "TaskContext{executionResult=" + this.executionResult + '}';
    }
}

