/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bd.indexing.es;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.BiFunction;
import kd.bos.fulltext.BatchValue;
import kd.bos.fulltext.FullTextUpdater;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.util.StringUtils;
import kd.fi.bd.indexing.constant.CDCStageEnum;
import kd.fi.bd.indexing.constant.ExIndexConstant;
import kd.fi.bd.indexing.es.ESSyncTargetInfo;
import kd.fi.bd.indexing.es.ElasticSearchHelper;
import kd.fi.bd.indexing.es.FullTextSearchIndexMeta;
import kd.fi.bd.model.common.PairTuple;
import kd.fi.bd.model.indexing.es.ESIndexSyncDataBlock;
import kd.fi.bd.threads.ThreadCategoryEnum;
import kd.fi.bd.util.pipe.SimpleAsyncPipe;
import kd.fi.bd.util.pipe.datablock.IAsyncStreamDataBlock;
import kd.fi.bd.util.timemeter.TimeCostMeter;

public class ESIndexRecordSyncHelper {
    private static final Log logger = LogFactory.getLog(ESIndexRecordSyncHelper.class);
    private TimeCostMeter[] _timeCostMeters;
    private Map<String, Integer> esSyncObjectIndex;
    private List<ESSyncTargetInfo> esSyncObjects;
    protected SimpleAsyncPipe<BatchValue[]> processPipe;

    public static ESIndexRecordSyncHelper getInstance() {
        return SingletonHolder.instance;
    }

    protected ESIndexRecordSyncHelper(int consumerCnt) {
        this._timeCostMeters = new TimeCostMeter[consumerCnt];
        this.esSyncObjects = new ArrayList<ESSyncTargetInfo>(2);
        this.esSyncObjectIndex = new ConcurrentHashMap<String, Integer>(consumerCnt);
        this.processPipe = new SimpleAsyncPipe(ThreadCategoryEnum.FI_PIPE, (category, dataBlock) -> this.onProcessDataBlock((ThreadCategoryEnum)((Object)category), (IAsyncStreamDataBlock<BatchValue[]>)dataBlock));
        this.processPipe.setExceptionListener(ex -> {
            logger.error("ESIndexRecordSyncHelper AsyncStreamPipe Error: " + ex.getMessage(), ex);
            return true;
        });
    }

    protected ESIndexRecordSyncHelper() {
        this(ExIndexConstant.ES_Upload_Thread_Cnt);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int registerESTarget(String moduleName, FullTextSearchIndexMeta esIndexMeta, BiFunction<PairTuple<CDCStageEnum, Boolean>, IAsyncStreamDataBlock<BatchValue[]>, Boolean> completedNotifier, boolean forceDeleteBeforeUpload) {
        Integer index;
        if (esIndexMeta == null) {
            throw new IllegalArgumentException("Cannot Register Null FullTextSearchIndexMeta!");
        }
        if (StringUtils.isEmpty((String)esIndexMeta.getIndexName())) {
            throw new IllegalArgumentException("ES Index Name cannot be null!");
        }
        String esTargetIndexName = esIndexMeta.getIndexName();
        if (!ExIndexConstant.isESIndexRegisteredOnSystemProperty(esTargetIndexName)) {
            ExIndexConstant.registerESIndexOnSystemProperty(moduleName, esTargetIndexName);
        }
        if ((index = this.esSyncObjectIndex.get(esTargetIndexName)) == null) {
            List<ESSyncTargetInfo> list = this.esSyncObjects;
            synchronized (list) {
                index = this.esSyncObjectIndex.get(esTargetIndexName);
                if (index == null) {
                    index = this.esSyncObjects.size();
                    this.esSyncObjects.add(new ESSyncTargetInfo(esTargetIndexName, forceDeleteBeforeUpload, esIndexMeta, completedNotifier));
                    this.esSyncObjectIndex.put(esTargetIndexName, index);
                }
            }
        } else {
            ESSyncTargetInfo targetInfo = this.esSyncObjects.get(index);
            targetInfo.setEsIndexMeta(esIndexMeta);
            targetInfo.setCompletedNotifier(completedNotifier);
            targetInfo.setForceDeleteBeforeUpload(forceDeleteBeforeUpload);
        }
        return index;
    }

    public int registerESTarget(String moduleName, FullTextSearchIndexMeta esIndexMeta, boolean forceDeleteBeforeUpload) {
        return this.registerESTarget(moduleName, esIndexMeta, null, forceDeleteBeforeUpload);
    }

    public synchronized void clearESIndexAllData(int esIndexSeqNum) {
        ESSyncTargetInfo targetInfo = this.esSyncObjects.get(esIndexSeqNum);
        if (targetInfo == null) {
            throw new IllegalArgumentException(String.format("Cannot found registered ES Index [%s]", esIndexSeqNum));
        }
        String esIndexName = targetInfo.getEsIndexMeta().getIndexName();
        targetInfo.getEsUpdater().deleteAll(esIndexName);
        ElasticSearchHelper.instance.reloadFullTextClient(esIndexName);
        targetInfo.reloadESUpdater();
    }

    public Integer getESIndexRegsiterSeqNum(String esIndexEntityName) {
        return this.esSyncObjectIndex.get(esIndexEntityName);
    }

    public ESSyncTargetInfo getRegisteredESSyncTargetInfo(String esIndexEntityName) {
        Integer index = this.esSyncObjectIndex.get(esIndexEntityName);
        return index == null ? null : this.esSyncObjects.get(index);
    }

    public ESSyncTargetInfo getRegisteredESSyncTargetInfo(int index) {
        return index >= 0 && index < this.esSyncObjects.size() ? this.esSyncObjects.get(index) : null;
    }

    protected void onProcessDataBlock(ThreadCategoryEnum consumerNum, IAsyncStreamDataBlock<BatchValue[]> srcDataBlock) {
        Object[] pks;
        if (!(srcDataBlock instanceof ESIndexSyncDataBlock)) {
            throw new IllegalArgumentException(String.format("Required ESIndexSyncDataBlock Data Block Type!, consumerNum=%s, srcDataBlock=%s", new Object[]{consumerNum, srcDataBlock}));
        }
        ESIndexSyncDataBlock dataBlock = (ESIndexSyncDataBlock)srcDataBlock;
        ESSyncTargetInfo esSyncTargetInfo = dataBlock.getRefESSyncTargetInfo();
        FullTextUpdater esUpdater = esSyncTargetInfo.getEsUpdater();
        String esIndexEntityName = esSyncTargetInfo.getEntityName();
        TimeCostMeter timeCostMeter = this.getTimeCostMeter(0, true);
        if (esSyncTargetInfo.isForceDeleteBeforeUpload() && (pks = dataBlock.get_cache_BatchValue_pks()) != null && pks.length > 0) {
            esUpdater.delete(esIndexEntityName, pks);
            timeCostMeter.outputTimeLog("--> esUpdater consumerNum:{}: delete {} From ES Index {}, Time Cost={}", new Object[]{consumerNum, pks.length, esIndexEntityName, timeCostMeter.getAndReset(0)});
        }
        boolean completedWithError = false;
        try {
            if (!dataBlock.isEmpty()) {
                esUpdater.insert(esIndexEntityName, (BatchValue[])dataBlock.getData());
                timeCostMeter.outputTimeLog("--> esUpdater consumerNum:{}: insert {} ES Index {}, Time Cost={}", new Object[]{consumerNum, dataBlock.size(), esIndexEntityName, timeCostMeter.getAndReset(0)});
            }
            srcDataBlock.onStageCompleted(CDCStageEnum.Completed, !completedWithError);
        }
        catch (Exception ex) {
            try {
                logger.error(ex.getMessage(), (Throwable)ex);
                completedWithError = true;
                throw ex;
            }
            catch (Throwable throwable) {
                srcDataBlock.onStageCompleted(CDCStageEnum.Completed, !completedWithError);
                timeCostMeter.outputTimeLog("--> esUpdater consumerNum:{}: Completed on ES Index {}: With Error:{}, Total Time Cost={}", new Object[]{consumerNum, esIndexEntityName, completedWithError, timeCostMeter.getAndReset(1)});
                throw throwable;
            }
        }
        timeCostMeter.outputTimeLog("--> esUpdater consumerNum:{}: Completed on ES Index {}: With Error:{}, Total Time Cost={}", new Object[]{consumerNum, esIndexEntityName, completedWithError, timeCostMeter.getAndReset(1)});
    }

    public ESIndexSyncDataBlock addData(Object groupKey, int esIndexEntityRegSeqNum, BatchValue[] values) {
        if (esIndexEntityRegSeqNum < 0 || esIndexEntityRegSeqNum > this.esSyncObjects.size()) {
            return null;
        }
        ESSyncTargetInfo esSyncTargetInfo = this.esSyncObjects.get(esIndexEntityRegSeqNum);
        return (ESIndexSyncDataBlock)this.processPipe.putToQueue(new ESIndexSyncDataBlock(groupKey, esSyncTargetInfo.getEsSyncStatistic().incrementAndGet(), values, esSyncTargetInfo));
    }

    public ESIndexSyncDataBlock addData(Object groupKey, String esIndexEntityName, BatchValue[] values) {
        Integer index = this.esSyncObjectIndex.get(esIndexEntityName);
        if (index == null) {
            throw new IllegalArgumentException(String.format("ES Target (%) not registered! --> Add Values=%s", esIndexEntityName, Arrays.deepToString(values)));
        }
        return this.addData(groupKey, index, values);
    }

    protected TimeCostMeter getTimeCostMeter(int index, boolean reset) {
        TimeCostMeter timeCostMeter = this._timeCostMeters[index];
        if (timeCostMeter == null) {
            this._timeCostMeters[index] = this.createNewTimeCostMeter();
            return this._timeCostMeters[index];
        }
        if (reset) {
            timeCostMeter.reset();
        }
        return this._timeCostMeters[index];
    }

    protected TimeCostMeter createNewTimeCostMeter() {
        return TimeCostMeter.create((template, params) -> logger.info(template, params), 2);
    }

    private static class SingletonHolder {
        private static ESIndexRecordSyncHelper instance = new ESIndexRecordSyncHelper();

        private SingletonHolder() {
        }
    }
}

