/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bd.indexing.es;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import kd.bos.fulltext.FTFilter;
import kd.bos.fulltext.FTRowData;
import kd.bos.fulltext.FullTextQuery;
import kd.fi.bd.indexing.constant.ExIndexConstant;
import kd.fi.bd.indexing.es.ElasticSearchHelper;
import kd.fi.bd.util.data.IDataValueUtil;

public class ESQueryResultIterator
implements Iterator<List<Object[]>> {
    private FullTextQuery textQuery;
    private String esIndexName;
    private String[] esQueryString;
    private String _cache_ESQueryString;
    private int _cache_QueryStringCnt;
    private FTFilter esQueryFilter;
    private String[] esSortProps;
    private int pageSize;
    private int currentPage;
    private boolean hasResult;
    private List<FTRowData> currentESQueryResult;
    private List<Object[]> _outputResultBuffer;

    public ESQueryResultIterator(FullTextQuery textQuery, String esIndexName, String[] esQueryString, FTFilter esQueryFilter, String[] esSortProps, int pageSize, int startPage) {
        this.textQuery = textQuery;
        this.esIndexName = esIndexName;
        this.esQueryString = esQueryString;
        if (esQueryString == null) {
            throw new IllegalArgumentException("ES Query Field String cannot be null!");
        }
        this._cache_ESQueryString = IDataValueUtil.arrayToString(esQueryString);
        this._cache_QueryStringCnt = esQueryString.length;
        this.esQueryFilter = esQueryFilter;
        this.esSortProps = esSortProps;
        this.pageSize = pageSize;
        this._outputResultBuffer = new ArrayList<Object[]>(this.pageSize);
        this.currentPage = Math.max(1, startPage);
        this.hasResult = false;
        this.currentESQueryResult = null;
    }

    public ESQueryResultIterator(String esIndexName, String[] esQueryString, FTFilter esQueryFilter, String[] esSortProps) {
        this(ElasticSearchHelper.instance.getFullTextQuery(esIndexName), esIndexName, esQueryString, esQueryFilter, esSortProps, ExIndexConstant.ES_Query_Page_Size, 1);
    }

    protected boolean doNextQuery() {
        this.currentESQueryResult = this.textQuery.search(this.esIndexName, this._cache_ESQueryString, this.esQueryFilter, this.esSortProps, this.currentPage, this.pageSize);
        this.hasResult = this.currentESQueryResult != null && !this.currentESQueryResult.isEmpty();
        return this.hasResult;
    }

    @Override
    public boolean hasNext() {
        if (this.currentESQueryResult == null) {
            return this.doNextQuery();
        }
        return this.hasResult;
    }

    @Override
    public List<Object[]> next() {
        if (!this.hasNext()) {
            throw new IndexOutOfBoundsException("No more record!");
        }
        this._outputResultBuffer.clear();
        for (FTRowData data : this.currentESQueryResult) {
            Object[] rowBuf = new Object[this._cache_QueryStringCnt];
            this._outputResultBuffer.add(rowBuf);
            for (int i = 0; i < this._cache_QueryStringCnt; ++i) {
                rowBuf[i] = data.get(this.esQueryString[i]);
            }
        }
        return this._outputResultBuffer;
    }
}

