/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bd.indexing.es;

import java.util.concurrent.atomic.AtomicLong;
import java.util.function.BiFunction;
import kd.bos.fulltext.BatchValue;
import kd.bos.fulltext.FullTextUpdater;
import kd.bos.fulltext.MatchProperty;
import kd.fi.bd.indexing.constant.CDCStageEnum;
import kd.fi.bd.indexing.es.ElasticSearchHelper;
import kd.fi.bd.indexing.es.FullTextSearchIndexMeta;
import kd.fi.bd.model.common.PairTuple;
import kd.fi.bd.util.pipe.datablock.IAsyncStreamDataBlock;

public class ESSyncTargetInfo {
    private FullTextUpdater esUpdater;
    private String esTargetIndex;
    private boolean forceDeleteBeforeUpload;
    private FullTextSearchIndexMeta esIndexMeta;
    private BiFunction<PairTuple<CDCStageEnum, Boolean>, IAsyncStreamDataBlock<BatchValue[]>, Boolean> completedNotifier;
    private AtomicLong esSyncStatistic;

    public ESSyncTargetInfo(String esTargetIndex, boolean forceDeleteBeforeUpload, FullTextSearchIndexMeta esIndexMeta, BiFunction<PairTuple<CDCStageEnum, Boolean>, IAsyncStreamDataBlock<BatchValue[]>, Boolean> completedNotifier) {
        this.esTargetIndex = esTargetIndex;
        if (this.esTargetIndex == null) {
            throw new IllegalArgumentException("ES Target Object cannot be null!");
        }
        this.esIndexMeta = esIndexMeta;
        if (this.esIndexMeta == null) {
            throw new IllegalArgumentException("ES Index Meta cannot be null!");
        }
        this.reloadESUpdater();
        this.forceDeleteBeforeUpload = forceDeleteBeforeUpload;
        this.completedNotifier = completedNotifier;
        this.esSyncStatistic = new AtomicLong(0L);
    }

    public void reloadESUpdater() {
        this.esUpdater = ElasticSearchHelper.instance.getFullTextUpdater(this.esTargetIndex);
        if (this.esUpdater == null) {
            throw new IllegalArgumentException("ES Updater Object cannot be null! : " + this.esTargetIndex);
        }
        MatchProperty[] queryProps = this.esIndexMeta.getQueryProps(false);
        this.esUpdater.addProperty(this.esIndexMeta.getQueryTarget(), queryProps);
    }

    public String toString() {
        return "ESSyncTargetInfo{esUpdater=" + this.esUpdater + ", esTargetObject='" + this.esTargetIndex + '\'' + ", forceDeleteBeforeUpload=" + this.forceDeleteBeforeUpload + ", esIndexMeta=" + this.esIndexMeta + ", completedNotifier=" + this.completedNotifier + ", esSyncStatistic=" + this.esSyncStatistic + '}';
    }

    public FullTextUpdater getEsUpdater() {
        return this.esUpdater;
    }

    public void setEsUpdater(FullTextUpdater esUpdater) {
        this.esUpdater = esUpdater;
    }

    public String getEsTargetIndex() {
        return this.esTargetIndex;
    }

    public String getEntityName() {
        return this.esIndexMeta.getQueryTarget();
    }

    public void setEsTargetIndex(String esTargetIndex) {
        this.esTargetIndex = esTargetIndex;
    }

    public boolean isForceDeleteBeforeUpload() {
        return this.forceDeleteBeforeUpload;
    }

    public void setForceDeleteBeforeUpload(boolean forceDeleteBeforeUpload) {
        this.forceDeleteBeforeUpload = forceDeleteBeforeUpload;
    }

    public FullTextSearchIndexMeta getEsIndexMeta() {
        return this.esIndexMeta;
    }

    public void setEsIndexMeta(FullTextSearchIndexMeta esIndexMeta) {
        this.esIndexMeta = esIndexMeta;
    }

    public BiFunction<PairTuple<CDCStageEnum, Boolean>, IAsyncStreamDataBlock<BatchValue[]>, Boolean> getCompletedNotifier() {
        return this.completedNotifier;
    }

    public void setCompletedNotifier(BiFunction<PairTuple<CDCStageEnum, Boolean>, IAsyncStreamDataBlock<BatchValue[]>, Boolean> completedNotifier) {
        this.completedNotifier = completedNotifier;
    }

    public AtomicLong getEsSyncStatistic() {
        return this.esSyncStatistic;
    }

    public void setEsSyncStatistic(AtomicLong esSyncStatistic) {
        this.esSyncStatistic = esSyncStatistic;
    }
}

