/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bd.indexing.integrator;

import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicInteger;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.fi.bd.indexing.cdc.CDCDBServiceHelper;
import kd.fi.bd.indexing.constant.CDCConstant;
import kd.fi.bd.indexing.constant.CDCRecOperationTypeEnum;
import kd.fi.bd.indexing.integrator.ESTextIndexGLIntegrator;
import kd.fi.bd.indexing.tasks.CDCGLVoucherTextProcessTask;
import kd.fi.bd.model.common.PairTuple;
import kd.fi.bd.util.data.IDataValueUtil;
import kd.fi.bd.util.optimizor.OptimizeControlPanel;
import kd.fi.bd.util.pipe.AsyncStreamPipe;
import kd.fi.bd.util.pipe.datablock.IAsyncStreamDataBlock;

public class CDCServiceGLIntegrator {
    private static final Log logger = LogFactory.getLog(CDCServiceGLIntegrator.class);
    private static final String[] GL_VoucherEntry_CDC_Props = new String[]{"id", "org_id", "period_id"};
    private static CDCServiceGLIntegrator _instance = new CDCServiceGLIntegrator();
    protected Map<PairTuple<Long, Long>, AtomicInteger> orgPeriodTaskInfo = new ConcurrentHashMap<PairTuple<Long, Long>, AtomicInteger>(1024);
    protected AsyncStreamPipe<PairTuple<Long, Long>> tmp_OrgPeriodTaskPipe = new AsyncStreamPipe(CDCConstant.CDC_Service_Thread_Cnt_GL);

    private CDCServiceGLIntegrator() {
        this.tmp_OrgPeriodTaskPipe.attach((idx, data) -> this.onProcessPipData((Integer)idx, (IAsyncStreamDataBlock<PairTuple<Long, Long>>)data));
    }

    protected void onProcessPipData(Integer seqNumber, IAsyncStreamDataBlock<PairTuple<Long, Long>> dataBlock) {
        try {
            CDCGLVoucherTextProcessTask task = new CDCGLVoucherTextProcessTask(dataBlock.getGroupId(), ESTextIndexGLIntegrator.getInstance().getGLVoucherDefaultESTextIndex_SeqNum(), dataBlock.getData().getKey(), dataBlock.getData().getValue());
            task.refreshRequestContext();
            task.call();
        }
        catch (Exception e) {
            logger.error(e.getMessage(), (Throwable)e);
            throw new RuntimeException(e);
        }
        finally {
            int cnt = this.orgPeriodTaskInfo.getOrDefault(dataBlock.getData(), new AtomicInteger(0)).decrementAndGet();
            logger.info("onProcessPipData_finally: data {} taskCnt {}", dataBlock.getData(), (Object)cnt);
            if (cnt >= 1) {
                this.tmp_OrgPeriodTaskPipe.putToQueue(dataBlock.getData());
            }
        }
    }

    public boolean isCDCEnabled() {
        return OptimizeControlPanel.isCDCServiceEnabled("gl");
    }

    public boolean isCDCRegisterEnabled() {
        return OptimizeControlPanel.isCDCServiceEnabled("gl.reg");
    }

    public static CDCServiceGLIntegrator getInstance() {
        return _instance;
    }

    public boolean registerCDCChangedRecord(CDCRecOperationTypeEnum operationType, DynamicObject[] changeRecords) {
        boolean cdcEnabled = this.isCDCRegisterEnabled();
        if (cdcEnabled) {
            CDCDBServiceHelper.registerCDCChangedRecord(operationType, GL_VoucherEntry_CDC_Props, changeRecords);
        }
        return cdcEnabled;
    }

    public boolean raiseCDCEvent(CDCRecOperationTypeEnum operationType, DynamicObject[] changeRecords) {
        if (changeRecords == null || changeRecords.length <= 0) {
            return false;
        }
        if (!this.isCDCEnabled()) {
            return false;
        }
        if (operationType == CDCRecOperationTypeEnum.Delete) {
            return true;
        }
        LinkedHashSet<PairTuple<Long, Long>> orgPeriodGroups = new LinkedHashSet<PairTuple<Long, Long>>(8);
        IDataEntityProperty[] pReaders = IDataValueUtil.getDynamicObjectProperty(changeRecords[0].getDataEntityType().getProperties(), GL_VoucherEntry_CDC_Props);
        for (DynamicObject dyn : changeRecords) {
            orgPeriodGroups.add(new PairTuple<Long, Long>((Long)pReaders[1].getValueFast((Object)dyn), (Long)pReaders[2].getValueFast((Object)dyn)));
        }
        return this.raiseCDCEvent(operationType, orgPeriodGroups);
    }

    public boolean raiseCDCEvent(CDCRecOperationTypeEnum operationType, Set<PairTuple<Long, Long>> orgPeriodGroups) {
        if (orgPeriodGroups == null || orgPeriodGroups.size() <= 0) {
            return false;
        }
        if (!this.isCDCEnabled()) {
            return false;
        }
        for (PairTuple<Long, Long> orgPeriod : orgPeriodGroups) {
            int cnt = this.orgPeriodTaskInfo.computeIfAbsent(orgPeriod, v -> new AtomicInteger(0)).incrementAndGet();
            logger.info("raiseCDCEvent: data {} taskCnt {}", orgPeriod, (Object)cnt);
            if (cnt >= 2) continue;
            this.tmp_OrgPeriodTaskPipe.putToQueue(orgPeriod);
        }
        return true;
    }
}

