/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bd.indexing.integrator;

import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Consumer;
import kd.bos.fulltext.BatchValue;
import kd.bos.fulltext.FTDataType;
import kd.bos.fulltext.FTRowData;
import kd.bos.fulltext.FullTextQuery;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.fi.bd.indexing.cdc.RegTextDBServiceHelper;
import kd.fi.bd.indexing.constant.ESTextMatchModeEnum;
import kd.fi.bd.indexing.constant.RecordCheckStatus;
import kd.fi.bd.indexing.es.ESIndexQueryHelper;
import kd.fi.bd.indexing.es.ESIndexRecordSyncHelper;
import kd.fi.bd.indexing.es.ElasticSearchHelper;
import kd.fi.bd.indexing.es.FullTextSearchIndexMeta;
import kd.fi.bd.indexing.tasks.GLVoucherTextProcessGroupTask;
import kd.fi.bd.indexing.tasks.InitGLVoucherTextGroupTask;
import kd.fi.bd.model.common.PairTuple;
import kd.fi.bd.model.indexing.context.es.ESIndexQueryTextContext;
import kd.fi.bd.model.indexing.es.ESIndexSyncDataBlock;
import kd.fi.bd.model.indexing.es.ESVouDescIndexQueryResult;
import kd.fi.bd.threads.FIConfigurableThreadService;
import kd.fi.bd.threads.ThreadCategoryEnum;

public class ESTextIndexGLIntegrator {
    private static final Log logger = LogFactory.getLog(ESTextIndexGLIntegrator.class);
    private static ESTextIndexGLIntegrator instance = new ESTextIndexGLIntegrator();
    public static final String ES_Index_gl_voucherentry_description = "bd_regtextinfo";
    private int _cache_GL_ESTextIndex_SeqNum = -1;
    private FullTextSearchIndexMeta _cache_GL_ESTextIndex_Meta;
    private final AtomicBoolean registered = new AtomicBoolean(false);
    private Map<String, PairTuple<String, FTDataType>> _cache_QFilterToEsFilterMapping_GL_Voucher;
    private Map<String, FullTextSearchIndexMeta> _cache_ESFullTextIndex_RegText = new HashMap<String, FullTextSearchIndexMeta>(1);
    private static final String esQueryString = "id, org, period, regtext";
    private static final String[] esQueryString_Array = new String[]{"id", "org", "period", "regtext"};
    private static String[] esSortProps = new String[]{"org desc", "period desc"};

    public static ESTextIndexGLIntegrator getInstance() {
        return instance;
    }

    protected ESTextIndexGLIntegrator() {
    }

    public int getGLVoucherDefaultESTextIndex_SeqNum() {
        if (!this.registered.get()) {
            this.registerGLVoucherDescriptionESIndex();
        }
        return this._cache_GL_ESTextIndex_SeqNum;
    }

    private FullTextSearchIndexMeta get_cache_GL_ESTextIndex_Meta() {
        if (!this.registered.get()) {
            this.registerGLVoucherDescriptionESIndex();
        }
        return this._cache_GL_ESTextIndex_Meta;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public FullTextSearchIndexMeta getDefaultFullTextSearchIndexMeta(String targetIndexName) {
        FullTextSearchIndexMeta indexMeta = this._cache_ESFullTextIndex_RegText.get(targetIndexName);
        if (indexMeta == null) {
            Map<String, FullTextSearchIndexMeta> map = this._cache_ESFullTextIndex_RegText;
            synchronized (map) {
                indexMeta = this._cache_ESFullTextIndex_RegText.get(targetIndexName);
                if (indexMeta == null) {
                    indexMeta = new FullTextSearchIndexMeta(targetIndexName, ES_Index_gl_voucherentry_description, "id", FTDataType.LONG).addValueProp("", "org", FTDataType.LONG).addValueProp("", "period", FTDataType.LONG).addValueProp("", "regtext", FTDataType.STRING);
                    indexMeta.refreashESConvertProps();
                    this._cache_ESFullTextIndex_RegText.put(targetIndexName, indexMeta);
                }
            }
        }
        return indexMeta;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, PairTuple<String, FTDataType>> getGLVoucherQFilterToEsFilterMapping() {
        if (this._cache_QFilterToEsFilterMapping_GL_Voucher == null) {
            ESTextIndexGLIntegrator eSTextIndexGLIntegrator = this;
            synchronized (eSTextIndexGLIntegrator) {
                this._cache_QFilterToEsFilterMapping_GL_Voucher = new HashMap<String, PairTuple<String, FTDataType>>(1);
                this._cache_QFilterToEsFilterMapping_GL_Voucher.put("org", new PairTuple<String, FTDataType>("org", FTDataType.LONG));
                this._cache_QFilterToEsFilterMapping_GL_Voucher.put("org.id", new PairTuple<String, FTDataType>("org", FTDataType.LONG));
                this._cache_QFilterToEsFilterMapping_GL_Voucher.put("period", new PairTuple<String, FTDataType>("period", FTDataType.LONG));
                this._cache_QFilterToEsFilterMapping_GL_Voucher.put("period.id", new PairTuple<String, FTDataType>("period", FTDataType.LONG));
                this._cache_QFilterToEsFilterMapping_GL_Voucher.put("edescription", new PairTuple<String, FTDataType>("regtext", FTDataType.STRING));
                this._cache_QFilterToEsFilterMapping_GL_Voucher.put("entries.edescription", new PairTuple<String, FTDataType>("regtext", FTDataType.STRING));
            }
        }
        return this._cache_QFilterToEsFilterMapping_GL_Voucher;
    }

    private synchronized void registerGLVoucherDescriptionESIndex() {
        if (!this.registered.get()) {
            this._cache_GL_ESTextIndex_Meta = this.getDefaultFullTextSearchIndexMeta(ES_Index_gl_voucherentry_description);
            this._cache_GL_ESTextIndex_SeqNum = ESIndexRecordSyncHelper.getInstance().registerESTarget("fi", this._cache_GL_ESTextIndex_Meta, false);
            this.registered.getAndSet(true);
        }
    }

    public int registerGLVoucherDescriptionESIndex(String moduleName, String esIndexName) {
        return ESIndexRecordSyncHelper.getInstance().registerESTarget(moduleName, this.getDefaultFullTextSearchIndexMeta(esIndexName), false);
    }

    public ESIndexSyncDataBlock addGLDescriptionDataToPipe(Object taskGroupKey, int esIndexSeqNum, BatchValue[] values) {
        return ESIndexRecordSyncHelper.getInstance().addData(taskGroupKey, esIndexSeqNum, values);
    }

    public ESIndexSyncDataBlock addGLDescriptionDataToPipe(Object taskGroupKey, int outputIndexRegNum, Collection<Object[]> dataRowsValues) {
        BatchValue[] values = new BatchValue[dataRowsValues.size()];
        int i = 0;
        for (Object[] row : dataRowsValues) {
            values[i++] = this.get_cache_GL_ESTextIndex_Meta().apply(row);
        }
        return this.addGLDescriptionDataToPipe(taskGroupKey, outputIndexRegNum, values);
    }

    public Integer getRegisterESIndexSeqNum(String esIndexName) {
        return ESIndexRecordSyncHelper.getInstance().getESIndexRegsiterSeqNum(esIndexName);
    }

    public void clearESIndexAllData(int esIndexSeqNum) {
        ESIndexRecordSyncHelper.getInstance().clearESIndexAllData(esIndexSeqNum);
    }

    public void clearESIndexAllData(String esIndexEntityName) {
        ESIndexRecordSyncHelper.getInstance().clearESIndexAllData(this.getRegisterESIndexSeqNum(esIndexEntityName));
    }

    public void startGLVoucherTextProcessTask(int taskType, String groupId, int esIndexRegSeqNum, Collection<Long> orgIds, Collection<Long> periodIds) throws Exception {
        GLVoucherTextProcessGroupTask task;
        switch (taskType) {
            case 0: {
                task = new InitGLVoucherTextGroupTask(groupId, esIndexRegSeqNum, orgIds, periodIds);
                break;
            }
            case 1: {
                task = new GLVoucherTextProcessGroupTask(groupId, esIndexRegSeqNum, orgIds, periodIds);
                break;
            }
            default: {
                throw new IllegalArgumentException("Not Support Task Type:" + taskType);
            }
        }
        FIConfigurableThreadService.getInstance().execute(ThreadCategoryEnum.FI_TEMP, task);
    }

    public static ESIndexQueryTextContext buildESIndexQueryTextContext(String esIndexName, int pageSize, int totalPageCnt) {
        return new ESIndexQueryTextContext(esIndexName, esIndexName, pageSize, totalPageCnt, ESTextMatchModeEnum.Match, new ESVouDescIndexQueryResult(RecordCheckStatus.UnCheck));
    }

    public void queryESGLVoucherIndex(String esIndexName, String queryText, Collection<Long> orgIds, Collection<Long> periodIds, int pageSize, int totalPageCnt, int startPage, Consumer<Object[]> resultConsumer) {
        FullTextQuery fullTextQuery = ElasticSearchHelper.instance.getFullTextQuery(esIndexName);
        if (fullTextQuery == null) {
            throw new IllegalArgumentException(String.format("ES Index [%s] Not Registerd!", esIndexName));
        }
        ESIndexQueryTextContext context = ESTextIndexGLIntegrator.buildESIndexQueryTextContext(esIndexName, pageSize, totalPageCnt);
        if (orgIds != null) {
            context.addESFilter(ESIndexQueryHelper.buildESInFilter("org", FTDataType.LONG, orgIds));
        }
        if (periodIds != null) {
            context.addESFilter(ESIndexQueryHelper.buildESInFilter("period", FTDataType.LONG, periodIds));
        }
        context.addESFilter(ESIndexQueryHelper.buildESLikeFilter("regtext", FTDataType.STRING, queryText));
        context.addESFilterText(queryText);
        List esQueryResult = fullTextQuery.search(esIndexName, esQueryString, context.getSingleESQueryFilter(), esSortProps, startPage, pageSize);
        int bufLength = esQueryString_Array.length;
        Object[] rowBuf = new Object[bufLength];
        for (FTRowData data : esQueryResult) {
            rowBuf[0] = data.getPkId();
            for (int i = 1; i < bufLength; ++i) {
                rowBuf[i] = data.get(esQueryString_Array[i]);
            }
            resultConsumer.accept(rowBuf);
        }
    }

    public static int deleteRegText(Collection<Long> orgIds, Collection<Long> periodIds) {
        return RegTextDBServiceHelper.deleteRegText(orgIds, periodIds);
    }
}

