/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bd.indexing.tasks;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.xdb.hint.HintCondition;
import kd.bos.xdb.hint.ShardingHintContext;
import kd.bos.xdb.sharding.sql.FilterType;
import kd.fi.bd.indexing.cdc.CDCDBServiceHelper;
import kd.fi.bd.indexing.cdc.RegTextDBServiceHelper;
import kd.fi.bd.indexing.constant.CDCStageEnum;
import kd.fi.bd.indexing.constant.CDCStatusEnum;
import kd.fi.bd.indexing.constant.CDCTaskTypeEnum;
import kd.fi.bd.indexing.integrator.ESTextIndexGLIntegrator;
import kd.fi.bd.indexing.tasks.AbstractCDCProcessTask;
import kd.fi.bd.model.common.PairTuple;
import kd.fi.bd.model.indexing.context.es.VoucherTextProcContext;
import kd.fi.bd.model.indexing.es.CDCTaskStatus;
import kd.fi.bd.model.indexing.es.ESIndexSyncDataBlock;
import kd.fi.bd.util.exception.KDExceptionBuilder;
import kd.fi.bd.util.filter.QFilterBuilder;

public class CDCGLVoucherTextProcessTask
extends AbstractCDCProcessTask<VoucherTextProcContext, Long, Long[]> {
    protected static final int batchSize = 5000;
    static final String GL_VOUCHER = "gl_voucher";
    protected static final String AlgoKey_procChangedVoucher_1 = "fi/gl/CDCGLVoucherTextProcessTask/procChangedVoucher";
    protected static final String Query_VoucherEntry_Description = "id, entries.id entryId, entries.edescription";
    Integer outputIndexRegNum;

    public CDCGLVoucherTextProcessTask(Object groupId, Integer outputIndexRegNum, Long orgId, Long periodId) {
        super(String.valueOf(groupId), orgId, periodId, new QFilterBuilder().add(new QFilter("org", "=", (Object)orgId)).add(new QFilter("period", "=", (Object)periodId)).add(new QFilter("entries.eorg", "=", (Object)orgId)).add(new QFilter("entries.eperiod", "=", (Object)periodId)));
        this.outputIndexRegNum = outputIndexRegNum;
        this.taskProcessContext = new VoucherTextProcContext(orgId, periodId);
        this._currentBatchPks = new LinkedList();
        this.taskResult = new Long[4];
        Arrays.fill((Object[])this.taskResult, (Object)0L);
    }

    @Override
    protected int getTaskType() {
        return CDCTaskTypeEnum.GL_VOUCHER_CDC.getCode();
    }

    protected boolean isInitTask() {
        return false;
    }

    @Override
    protected String getLockKey() {
        return String.format("fi/%s/%s_%s", GL_VOUCHER, this.orgId, this.periodId);
    }

    @Override
    protected <T> void mergerTaskStatisticResult(Long[] taskResult, T batchStatisticResult) {
        CDCGLVoucherTextProcessTask.mergerStatisticCnt((Long[])taskResult, (Number[])((Long[])batchStatisticResult));
    }

    @Override
    protected boolean fetchNextBatchCDCChangedRecHist(int batchSize) {
        this._currentBatchPks.clear();
        int timeMeterIndex = this._timeCostMeter.getMeterIndexAndResetTime("fetchNextBatchCDCChangedRecHist");
        CDCDBServiceHelper.fetchCDCChangedRecHist(((VoucherTextProcContext)this.taskProcessContext).getPeriodId(), ((VoucherTextProcContext)this.taskProcessContext).getOrgId(), this._cdc_task_status.getLast_cdc_id(), batchSize, row -> {
            ((VoucherTextProcContext)this.taskProcessContext).updateLastMaxCDCId(row.getLong(0));
            this._currentBatchPks.add(row.getLong(1));
            return true;
        });
        this._timeCostMeter.outputTimeLog("--> fetchNextBatchCDCChangedRecHist: \tTime:{}(ms)", this._timeCostMeter.getTimeCost(timeMeterIndex));
        return !this._currentBatchPks.isEmpty();
    }

    protected QFilter[] getProcessCDCChangeRecordsFilter(VoucherTextProcContext taskProcessContext, Collection<Long> srcRecordPks) {
        return new QFilter[]{new QFilter("id", "in", srcRecordPks)};
    }

    protected QFilter[] getVoucherFilters(QFilterBuilder baseFilter, VoucherTextProcContext taskProcessContext, Collection<Long> srcRecordPks) {
        return new QFilter[]{new QFilter("id", "in", srcRecordPks)};
    }

    protected long getTaskLastCompNewMaxSrcEntryId() {
        CDCTaskStatus initStatus;
        if (CDCStatusEnum.FAILURE.getStringValue().equalsIgnoreCase(this._cdc_task_status.getStatus())) {
            return RegTextDBServiceHelper.getMaxEntryId(this.orgId, this.periodId);
        }
        if (this._cdc_task_status.getLast_max_srcEntryId() == 0L && (initStatus = CDCDBServiceHelper.loadCDCTaskStatus(CDCTaskTypeEnum.GL_VOUCHER_INIT.getCode(), this.orgId, this.periodId)) != null) {
            return initStatus.getLast_max_srcEntryId();
        }
        return this._cdc_task_status.getLast_max_srcEntryId();
    }

    @Override
    protected Long[] processCDCChangeRecords(VoucherTextProcContext taskProcessContext, QFilterBuilder baseFilter, Collection<Long> srcRecordPks) {
        int[] timeMeterIndex = this._timeCostMeter.getMeterIndexAndResetTime("processCDCChangeRecords_batch", "processCDCChangeRecords_total");
        long oldVoucherId = -1L;
        long newVoucherId = -1L;
        long newVoucherEntryId = -1L;
        int _VoucherAddBatchSize = 5000;
        int procBatchCnt = 0;
        int addBatchCnt = -1;
        long lastCompNewMaxSrcEntryId = this.getTaskLastCompNewMaxSrcEntryId();
        try (ShardingHintContext ctx = ShardingHintContext.createAndSet((String)"t_gl_voucher", (HintCondition[])new HintCondition[]{new HintCondition("forgid", FilterType.eq, (Object)this.orgId), new HintCondition("fperiodid", FilterType.eq, (Object)this.periodId)});
             DataSet ds = QueryServiceHelper.queryDataSet((String)AlgoKey_procChangedVoucher_1, (String)GL_VOUCHER, (String)Query_VoucherEntry_Description, (QFilter[])this.getVoucherFilters(baseFilter, taskProcessContext, srcRecordPks), (String)"id");){
            if (ds != null && ds.hasNext()) {
                for (Row dataRow : ds) {
                    newVoucherId = dataRow.getLong(0);
                    newVoucherEntryId = dataRow.getLong(1);
                    if (newVoucherId != oldVoucherId) {
                        oldVoucherId = newVoucherId;
                        if (addBatchCnt > 5000) {
                            CDCGLVoucherTextProcessTask.mergerStatisticCnt((Long[])((Long[])this.taskResult), (Number[])this.batchProcessVoucherRegText(taskProcessContext));
                            taskProcessContext.reset();
                            addBatchCnt = -1;
                            this._timeCostMeter.outputTimeLog("--> Batch:{} \tTime:{}(ms)", ++procBatchCnt, this._timeCostMeter.getAndReset(timeMeterIndex[0]));
                        }
                    }
                    taskProcessContext.addNewVoucherTextProcRec(lastCompNewMaxSrcEntryId < newVoucherEntryId, newVoucherId, newVoucherEntryId, dataRow.getString(2));
                    ++addBatchCnt;
                }
            }
        }
        if (addBatchCnt >= 0 || procBatchCnt <= 0) {
            CDCGLVoucherTextProcessTask.mergerStatisticCnt((Long[])((Long[])this.taskResult), (Number[])this.batchProcessVoucherRegText(taskProcessContext));
            taskProcessContext.updateLastMaxID(1, newVoucherId);
            taskProcessContext.updateLastMaxID(2, newVoucherEntryId);
            taskProcessContext.reset();
            this._timeCostMeter.outputTimeLog("--> Final Batch:{} \tTime:{}(ms)", ++procBatchCnt, this._timeCostMeter.getAndReset(timeMeterIndex[0]));
        }
        long totalTime = this._timeCostMeter.getAndReset(timeMeterIndex[1]);
        if (procBatchCnt == 0) {
            procBatchCnt = 1;
        }
        this._timeCostMeter.outputTimeLog("--> [Task for Org:{}, Period\uff1a{} Completed] Total Batch Cnt:{} Statistic: {}\tTotal Time:{}(ms), AvgTime={}(ms)", taskProcessContext.getOrgId(), taskProcessContext.getPeriodId(), procBatchCnt, Arrays.deepToString((Object[])this.taskResult), totalTime, totalTime / (long)procBatchCnt);
        return (Long[])this.taskResult;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Integer[] batchProcessVoucherRegText(VoucherTextProcContext taskProcessContext) {
        int[] timeMeterIndex = this._timeCostMeter.getMeterIndexAndResetTime("batchProcessVoucherRegText_stage", "batchProcessVoucherRegText_total");
        taskProcessContext.finishAddChangeRecs();
        this.checkExistingRegFullText(taskProcessContext);
        this._timeCostMeter.outputTimeLog("\t--> 1.checkExistingRegFullText : Time:{}(ms)", this._timeCostMeter.getAndReset(timeMeterIndex[0]));
        ESIndexSyncDataBlock esUploadDataBlock = null;
        List<Object[]> insertNewRegTextParamList = taskProcessContext.getInsertNewRegTextParamList();
        if (insertNewRegTextParamList != null && !insertNewRegTextParamList.isEmpty() && (esUploadDataBlock = ESTextIndexGLIntegrator.getInstance().addGLDescriptionDataToPipe((Object)this.groupId, (int)this.outputIndexRegNum, insertNewRegTextParamList)) == null) {
            throw KDExceptionBuilder.buildKDBizException("Create ES Upload Data Block Failed! " + taskProcessContext);
        }
        RegTextDBServiceHelper.getRegTextOwnership(taskProcessContext.getNeedCheckExistSrcEntryIds(), row -> {
            taskProcessContext.addInvalidedOwnerEntryTextRefCnt(row.getLong(0), row.getLong(1));
            return true;
        });
        this._timeCostMeter.outputTimeLog("\t--> 2.addInvalidedOwnerEntryTextRefCnt : Time:{}(ms)", this._timeCostMeter.getAndReset(timeMeterIndex[0]));
        Object[] resultCnt = new Integer[4];
        try (TXHandle tx = TX.requiresNew((String)"batchProcessVoucherRegText");){
            try {
                PairTuple<CDCStageEnum, Boolean> esUploadResult;
                int[] dbResult = RegTextDBServiceHelper.batchInsertRegText(insertNewRegTextParamList);
                resultCnt[0] = dbResult != null ? dbResult.length : 0;
                taskProcessContext.finishInsertNewRegText();
                this._timeCostMeter.outputTimeLog("\t--> 3.1.batchInsertRegText: Insert ({}) Time:{}(ms)", resultCnt[0], this._timeCostMeter.getAndReset(timeMeterIndex[0]));
                Long[] idBuf = taskProcessContext.getDeleteTextRefOwnerShipSQLParams();
                boolean executeResult = RegTextDBServiceHelper.deleteRegTextOwnership(idBuf);
                resultCnt[2] = executeResult ? idBuf.length : 0;
                this._timeCostMeter.outputTimeLog("\t--> 3.2.deleteRegTextOwnership: Delete ({}: {}) Time:{}(ms)", resultCnt[2], executeResult, this._timeCostMeter.getAndReset(timeMeterIndex[0]));
                dbResult = RegTextDBServiceHelper.batchInsertRegTextOwnership(taskProcessContext.getInsertTextRefOwnerShipSQLParams());
                resultCnt[3] = dbResult != null ? dbResult.length : 0;
                this._timeCostMeter.outputTimeLog("\t--> 3.3.batchInsertRegTextOwnership: Insert ({}) Time:{}(ms)", resultCnt[3], this._timeCostMeter.getAndReset(timeMeterIndex[0]));
                dbResult = RegTextDBServiceHelper.batchUpdateRegTextRefCnt(taskProcessContext.getNeedUpdateRefCntTextIds(), true);
                resultCnt[1] = dbResult.length;
                this._timeCostMeter.outputTimeLog("\t--> 3.4.batchUpdateRegTextRefCnt: Update ({}) Time:{}(ms)", resultCnt[1], this._timeCostMeter.getAndReset(timeMeterIndex[0]));
                CDCDBServiceHelper.updateTaskStatusByType(taskProcessContext.finishContextProcessing(this._cdc_task_status), this.getTaskType());
                this._timeCostMeter.outputTimeLog("\t--> 3.5.updateCDCTaskCompletedStatus: update Time:{}(ms)", this._timeCostMeter.getAndReset(timeMeterIndex[0]));
                int delCnt = CDCDBServiceHelper.deleteCDCRecords(this.orgId, this.periodId, this._cdc_task_status.getLast_cdc_id());
                this._timeCostMeter.outputTimeLog("\t--> 3.6.deleteCDCRecords: delete Time:{}(ms), cnt:{}, param:{}", this._timeCostMeter.getAndReset(timeMeterIndex[0]), delCnt, this._cdc_task_status.getLast_cdc_id());
                if (!(esUploadDataBlock == null || (esUploadResult = esUploadDataBlock.waitStageChange(-1L)).getValue().booleanValue() && esUploadResult.getKey() == CDCStageEnum.Completed)) {
                    throw KDExceptionBuilder.buildKDBizException("Upload ES Failed! Result=" + esUploadResult + ", Source=" + esUploadDataBlock);
                }
            }
            catch (Exception e) {
                tx.markRollback();
                throw e;
            }
        }
        catch (Throwable throwable) {
            this._timeCostMeter.outputTimeLog("\t--> batchProcessVoucherRegText DB Trans ({}), Total Time:{}(ms)", Arrays.deepToString(resultCnt), this._timeCostMeter.getAndReset(timeMeterIndex[1]));
            throw throwable;
        }
        this._timeCostMeter.outputTimeLog("\t--> batchProcessVoucherRegText DB Trans ({}), Total Time:{}(ms)", Arrays.deepToString(resultCnt), this._timeCostMeter.getAndReset(timeMeterIndex[1]));
        return resultCnt;
    }

    private void checkExistingRegFullText(VoucherTextProcContext taskProcessContext) {
        ArrayList<String> textValueBufList = new ArrayList<String>(1001);
        int sqlLength = 30;
        for (String text : taskProcessContext.getRegTextQueryParam()) {
            textValueBufList.add(text);
            if ((sqlLength += text.length()) <= 30000) continue;
            RegTextDBServiceHelper.queryExistingRegText(this.orgId, this.periodId, textValueBufList.toArray(), row -> {
                taskProcessContext.updateExistingRegTextId(row.getLong(0), row.getString(1));
                return true;
            });
            textValueBufList.clear();
            sqlLength = 30;
        }
        if (!textValueBufList.isEmpty()) {
            RegTextDBServiceHelper.queryExistingRegText(this.orgId, this.periodId, textValueBufList.toArray(), row -> {
                taskProcessContext.updateExistingRegTextId(row.getLong(0), row.getString(1));
                return true;
            });
            textValueBufList.clear();
        }
        taskProcessContext.finishUpdateTextRefID();
    }
}

