/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bd.indexing.tasks;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.fulltext.FTDataType;
import kd.bos.fulltext.FTFilter;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.ORM;
import kd.bos.orm.query.QFilter;
import kd.fi.bd.indexing.constant.ESTextMatchModeEnum;
import kd.fi.bd.indexing.constant.ExIndexConstant;
import kd.fi.bd.indexing.constant.RecordCheckStatus;
import kd.fi.bd.indexing.es.ESIndexQueryHelper;
import kd.fi.bd.indexing.es.ElasticSearchHelper;
import kd.fi.bd.model.indexing.context.QueryPageInfo;
import kd.fi.bd.model.indexing.context.es.ESIndexQueryTextContext;
import kd.fi.bd.model.indexing.es.ESVouDescIndexQueryResult;
import kd.fi.bd.tasks.common.AbstractBaseWorkTask;
import kd.fi.bd.util.filter.QFilterBuilder;
import kd.fi.bd.util.filter.WildcardMatcher;
import kd.fi.bd.util.filter.WildcardPositionEnum;
import kd.fi.bd.util.optimizor.OptimizeControlPanel;
import kd.fi.bd.util.timemeter.TimeCostMeter;

public class GLVoucherTextESIndexQueryTask
extends AbstractBaseWorkTask<Serializable, Serializable, ESVouDescIndexQueryResult> {
    private static final Log logger = LogFactory.getLog(GLVoucherTextESIndexQueryTask.class);
    private ESIndexQueryTextContext<Long, ESVouDescIndexQueryResult> queryContext;
    private String orderBys;
    public static final String Prop_Description = "vdescription";
    public static final String Prop_Entry_Description = "entries.edescription";
    public static final String GL_VOUCHER = "gl_voucher";
    public static final String ES_RegText_Key = "regtext";
    public static final String Base_FullText_SQL_Join = " inner join t_bd_regtextownership ownership on ownership.fownerrecid=A.fid  inner join t_bd_regtextinfo textinfo on textinfo.fid = ownership.fid ";
    public static final String Direct_FullText_SQL_Join = " inner join t_bd_regtextownership ownership on ownership.fownerrecid=A.fid  inner join t_bd_regtextinfo textinfo on textinfo.fid = ownership.fid  and textinfo.forgid in %s and textinfo.fperiodid in %s ";
    public static final String ValidateText_SQL_Join = " inner join t_bd_regtextownership ownership on ownership.fownerrecid=A.fid  inner join t_bd_regtextinfo textinfo on textinfo.fid = ownership.fid  and textinfo.fid in ";
    public static final String Direct_QueryFullText_Join_Clause = " and textinfo.fregtext %s %s";
    public static final String Direct_QueryFullText_Like_Clause = String.format(" and textinfo.fregtext %s %s", "like", "?");

    public GLVoucherTextESIndexQueryTask(Serializable taskId, String indexName, List<QFilter> originalFilter, int pageSize, int totalPageCnt, ESTextMatchModeEnum textMatchMode) {
        super(taskId, taskId);
        this.queryContext = this.buildESQueryContext(indexName, pageSize, totalPageCnt, originalFilter, textMatchMode);
    }

    protected ESIndexQueryTextContext buildESQueryContext(String indexName, int pageSize, int totalPageCnt, List<QFilter> originalFilter, ESTextMatchModeEnum textMatchMode) {
        ESIndexQueryTextContext esIndexQueryTextContext = new ESIndexQueryTextContext(indexName, "bd_regtextinfo", pageSize, totalPageCnt, textMatchMode, new ESVouDescIndexQueryResult(RecordCheckStatus.UnCheck));
        esIndexQueryTextContext.addESSelectedProps("id");
        esIndexQueryTextContext.addQFilterToESFilterMapping("org", FTDataType.LONG).addQFilterToESFilterMapping("org.id", "org", FTDataType.LONG).addQFilterToESFilterMapping("period", FTDataType.LONG).addQFilterToESFilterMapping("period.id", "period", FTDataType.LONG).addQFilterToESFilterMapping(Prop_Description, ES_RegText_Key, FTDataType.STRING).addQFilterToESFilterMapping(Prop_Entry_Description, ES_RegText_Key, FTDataType.STRING);
        esIndexQueryTextContext.addSortProp("org desc", "period desc");
        HashSet removeIndexs = new HashSet(originalFilter.size());
        ElasticSearchHelper.convertQFilterToESFilter(textMatchMode, esIndexQueryTextContext.getqFilterToEsFilterMapping(), (f, i) -> {
            esIndexQueryTextContext.addESFilter((FTFilter)f);
            if (ES_RegText_Key.equals(f.getProperty())) {
                for (Object v : f.getValue().getValues()) {
                    if (v == null) continue;
                    esIndexQueryTextContext.addESFilterText(WildcardMatcher.addOrRemoveWildcard(WildcardPositionEnum.Pre_Suffix, true, v));
                }
                removeIndexs.add(i);
            }
        }, originalFilter);
        esIndexQueryTextContext.setEsResultExtrator(esQueryResult -> esQueryResult.stream().map(r -> Long.valueOf(r.getPkId())).collect(Collectors.toList()));
        LinkedList<QFilter> newFilterList = new LinkedList<QFilter>();
        int i2 = 0;
        for (QFilter f2 : originalFilter) {
            if (removeIndexs.contains(i2++)) continue;
            newFilterList.add(f2);
        }
        esIndexQueryTextContext.setOriginalFilters(newFilterList);
        QueryPageInfo finalQueryPageInfo = esIndexQueryTextContext.getQueryPageInof(0);
        finalQueryPageInfo.setDisplayPageSize(totalPageCnt);
        finalQueryPageInfo.setTotalMatchCnt(pageSize * totalPageCnt);
        esIndexQueryTextContext.getQueryPageInof(1).setDisplayPageSize(ExIndexConstant.ES_Query_Page_Size);
        esIndexQueryTextContext.setEsQueryResultValidator((context, ftRowData) -> this.validateESQueryResult((ESIndexQueryTextContext)context, (List<Long>)ftRowData));
        return esIndexQueryTextContext;
    }

    @Override
    protected ESVouDescIndexQueryResult doTaskJob() {
        boolean checkDB = OptimizeControlPanel.getSysPropertyBoolean("fi.ex-indexing.query.checkDB", Boolean.FALSE);
        if (checkDB) {
            RecordCheckStatus checkStatus = this.checkDBMatchRecordCnt(GL_VOUCHER, this.queryContext.getOriginalFilters());
            switch (checkStatus) {
                case Exceed_Limit: {
                    return ESIndexQueryHelper.doESSearchAndValidate(this.queryContext);
                }
            }
            return new ESVouDescIndexQueryResult(checkStatus);
        }
        return ESIndexQueryHelper.doESSearchAndValidate(this.queryContext);
    }

    protected ESVouDescIndexQueryResult validateESQueryResult(ESIndexQueryTextContext esIndexQueryTextContext, List<Long> textIdList) {
        TimeCostMeter timeMeter = TimeCostMeter.create(true, (template, params) -> logger.info(template, params), "Stage", "Total");
        ArrayList<Long> sqlParams = new ArrayList<Long>(textIdList.size() + esIndexQueryTextContext.getFilterTexts().size());
        sqlParams.addAll(textIdList);
        StringBuilder filterTextClause = new StringBuilder(ValidateText_SQL_Join).append(QFilterBuilder.buildSQLParamHolder(textIdList.size()));
        esIndexQueryTextContext.getFilterTexts().forEach(t -> {
            sqlParams.add((Long)t);
            filterTextClause.append(Direct_QueryFullText_Like_Clause);
        });
        QFilter validateFilter = QFilter.joinSQL((String)GL_VOUCHER, (String)filterTextClause.toString(), (Object[])sqlParams.toArray());
        this.getQueryContext().getOriginalFilters().forEach(f -> validateFilter.and((QFilter)f));
        timeMeter.outputTimeLog("\t\t-> Concat Validate ES Query Result SQL: Time Cost={}", timeMeter.getAndReset(0));
        ESVouDescIndexQueryResult result = new ESVouDescIndexQueryResult(RecordCheckStatus.Within_Limit);
        try (DataSet voucherDs = ORM.create().queryDataSet("fi/bd/ESQueryTask/validateESQueryResult/gl_voucher", GL_VOUCHER, "id", validateFilter.toArray(), "id", ExIndexConstant.MAX_DB_MATCH_CNT + 1);){
            timeMeter.outputTimeLog("\t\t->ORM Execute Validate ES Result SQL: Time Cost={}, validateFilter={}", timeMeter.getAndReset(0), validateFilter.toString());
            if (voucherDs.hasNext()) {
                int matchCnt = 0;
                for (Row row : voucherDs) {
                    result.add(row.getLong(0));
                    ++matchCnt;
                }
                if (matchCnt > ExIndexConstant.MAX_DB_MATCH_CNT) {
                    result.setRecordCheckStatus(RecordCheckStatus.Exceed_Limit);
                }
                result.setActualMatchCnt(matchCnt);
                timeMeter.outputTimeLog("\t\t-> Loop ORM DataSet: matchCnt={} Time Cost={}", matchCnt, timeMeter.getAndReset(0));
            }
        }
        return result.pack();
    }

    protected RecordCheckStatus checkDBMatchRecordCnt(String queryEntity, Collection<QFilter> srcFilters) {
        int n;
        QFilterBuilder filterBuilder = QFilterBuilder.modifyFilters(srcFilters, f -> null, new String[]{Prop_Description, Prop_Entry_Description});
        TimeCostMeter timeMeter = TimeCostMeter.create(true, (template, params) -> logger.info(template, params), "stage");
        int result = 0;
        try (DataSet ds = ORM.create().queryDataSet("fi/bd/ESQueryTask/getDBMatchRecordCnt", queryEntity, "id", filterBuilder.toArray(new QFilter[0]), null, 0, 1);){
            n = ds != null && ds.hasNext() ? 1 : 0;
        }
        if ((result += n) > 0) {
            ds = ORM.create().queryDataSet("fi/bd/ESQueryTask/getDBMatchRecordCnt", queryEntity, "id", filterBuilder.toArray(new QFilter[0]), this.orderBys, ExIndexConstant.MAX_USE_ES_INDEX_SIZE, 1);
            var7_7 = null;
            try {
                result += ds != null && ds.hasNext() ? 1 : 0;
            }
            catch (Throwable throwable) {
                var7_7 = throwable;
                throw throwable;
            }
            finally {
                if (ds != null) {
                    if (var7_7 != null) {
                        try {
                            ds.close();
                        }
                        catch (Throwable throwable) {
                            var7_7.addSuppressed(throwable);
                        }
                    } else {
                        ds.close();
                    }
                }
            }
        }
        timeMeter.outputTimeLog("\t->Perform DB SQL check whether exceed required amount of reocrds : Time Cost={}, MaxCnt={}, CheckResult={}", timeMeter.getAndReset(0), ExIndexConstant.MAX_USE_ES_INDEX_SIZE, result);
        return RecordCheckStatus.parse(result);
    }

    public ESIndexQueryTextContext getQueryContext() {
        return this.queryContext;
    }

    public void setQueryContext(ESIndexQueryTextContext queryContext) {
        this.queryContext = queryContext;
    }

    public String getOrderBys() {
        return this.orderBys;
    }

    public void setOrderBys(String orderBys) {
        this.orderBys = orderBys;
    }
}

