/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bd.indexing.tasks;

import java.util.Collection;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.fi.bd.indexing.cdc.CDCDBServiceHelper;
import kd.fi.bd.indexing.constant.CDCTaskTypeEnum;
import kd.fi.bd.indexing.tasks.CDCGLVoucherTextProcessTask;
import kd.fi.bd.model.indexing.context.es.VoucherTextProcContext;
import kd.fi.bd.model.indexing.es.CDCTaskStatus;
import kd.fi.bd.util.filter.QFilterBuilder;

public class GLVoucherTextProcessTask
extends CDCGLVoucherTextProcessTask {
    protected QFilterBuilder _fetchVoucherFilter;

    public GLVoucherTextProcessTask(String groupId, Integer outputIndexRegNum, Long orgId, Long periodId) {
        super((Object)groupId, outputIndexRegNum, orgId, periodId);
        this._fetchVoucherFilter = new QFilterBuilder().add(new QFilter("org", "=", (Object)orgId)).add(new QFilter("period", "=", (Object)periodId));
    }

    @Override
    protected boolean isInitTask() {
        return true;
    }

    @Override
    protected int getTaskType() {
        return CDCTaskTypeEnum.GL_VOUCHER_INIT.getCode();
    }

    @Override
    protected boolean fetchNextBatchCDCChangedRecHist(int batchSize) {
        int timeMeterIndex = this._timeCostMeter.getMeterIndexAndResetTime("fetchNextBatchCDCChangedRecHist");
        long lastMaxSrcId = Math.max(this._cdc_task_status.getLast_max_srcId(), ((VoucherTextProcContext)this.taskProcessContext).getLastMaxID(1));
        boolean result = QueryServiceHelper.exists((String)"gl_voucher", (QFilter[])this._fetchVoucherFilter.toArray(new QFilter("id", ">", (Object)lastMaxSrcId)));
        this._timeCostMeter.outputTimeLog("--> fetchNextBatchCDCChangedRecHist: Filter VoucherID>{}, result={}, \tTime:{}(ms)", lastMaxSrcId, result, this._timeCostMeter.getTimeCost(timeMeterIndex));
        return result;
    }

    @Override
    protected long getTaskLastCompNewMaxSrcEntryId() {
        CDCTaskStatus cdcStatus = CDCDBServiceHelper.loadCDCTaskStatus(CDCTaskTypeEnum.GL_VOUCHER_CDC.getCode(), this.orgId, this.periodId);
        if (cdcStatus == null) {
            return this._cdc_task_status.getLast_max_srcEntryId();
        }
        return Math.max(cdcStatus.getLast_max_srcEntryId(), this._cdc_task_status.getLast_max_srcEntryId());
    }

    @Override
    protected QFilter[] getProcessCDCChangeRecordsFilter(VoucherTextProcContext taskProcessContext, Collection<Long> srcRecordPks) {
        return new QFilter[]{new QFilter("id", ">", (Object)this._cdc_task_status.getLast_max_srcId())};
    }

    @Override
    protected QFilter[] getVoucherFilters(QFilterBuilder baseFilter, VoucherTextProcContext taskProcessContext, Collection<Long> srcRecordPks) {
        return baseFilter.toArray(this.getProcessCDCChangeRecordsFilter(taskProcessContext, srcRecordPks));
    }
}

