/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bd.logger;

import com.google.common.collect.ImmutableSet;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.Set;
import java.util.function.Supplier;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.fi.bd.util.DebugTrace;

public class ExtLogFactory {
    public static Log getLog(Class<?> clazz) {
        return ExtLogFactory.getLog(clazz, "");
    }

    public static Log getLog(Class<?> clazz, String logPrefix) {
        return ExtLogFactory.getLog(clazz, logPrefix, DebugTrace::enable);
    }

    public static Log getLog(Class<?> clazz, String logPrefix, Supplier<Boolean> whenInfo) {
        Log logger = LogFactory.getLog(clazz);
        return (Log)Proxy.newProxyInstance(Thread.currentThread().getContextClassLoader(), new Class[]{Log.class}, (InvocationHandler)new ExtLogProxy(logger, logPrefix, whenInfo));
    }

    private static class ExtLogProxy
    implements InvocationHandler {
        private final Log target;
        private final String logPrefix;
        private final Supplier<Boolean> whenInfo;
        private static final String METHOD_INFO = "info";
        private static final String METHOD_WARN = "warn";
        private static final String METHOD_ERROR = "error";
        private static final Set<String> PROXY_METHODS = ImmutableSet.of((Object)"info", (Object)"warn", (Object)"error");

        public ExtLogProxy(Log target, String logPrefix, Supplier<Boolean> whenInfo) {
            this.target = target;
            this.logPrefix = logPrefix;
            this.whenInfo = whenInfo;
        }

        @Override
        public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
            String methodName = method.getName();
            if (!PROXY_METHODS.contains(methodName)) {
                return method.invoke((Object)this.target, new Object[0]);
            }
            if (METHOD_INFO.equals(methodName) && !this.whenInfo.get().booleanValue()) {
                return null;
            }
            args[0] = this.prefixMsg(args[0]);
            return method.invoke((Object)this.target, args);
        }

        private Object prefixMsg(Object msg) {
            if (msg instanceof String) {
                return this.logPrefix + msg;
            }
            return msg;
        }
    }
}

