/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bd.model;

import com.alibaba.fastjson.JSONObject;
import java.util.Map;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.fi.bd.model.Context;
import kd.fi.bd.model.IPropContext;
import kd.fi.bd.model.schema.property.Prop;

public class JsonObjectAdapter
implements IPropContext {
    private final JSONObject source;

    public JSONObject getSource() {
        return this.source;
    }

    public JsonObjectAdapter(JSONObject source) {
        this.source = source;
    }

    @Override
    public JsonObjectAdapter registerContext(Prop prop, Object value) {
        this.source.put(prop.toTypeName(), value);
        return this;
    }

    @Override
    public JsonObjectAdapter registerContext(String prop, Object value) {
        this.source.put(prop, value);
        return this;
    }

    @Override
    public Object query(Prop prop) {
        return this.source.get((Object)prop.toTypeName());
    }

    @Override
    public Object query(String prop) {
        return this.source.get((Object)prop);
    }

    public static JsonObjectAdapter getEmpty() {
        return JsonObjectAdapter.fromJson(null);
    }

    public static JsonObjectAdapter fromJson(String jsonStr) {
        if (jsonStr == null) {
            return new JsonObjectAdapter(new JSONObject());
        }
        Map data = (Map)SerializationUtils.fromJsonString((String)jsonStr, Map.class);
        return new JsonObjectAdapter(new JSONObject(data));
    }

    public static JsonObjectAdapter fromContext(Context context) {
        return JsonObjectAdapter.fromMap(context.getRepo());
    }

    public static JsonObjectAdapter fromMap(Map<String, Object> source) {
        return new JsonObjectAdapter(new JSONObject(source));
    }

    public String toJsonStr() {
        return this.source.toJSONString();
    }
}

