/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bd.model.common;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.annotation.JSONField;
import com.fasterxml.jackson.annotation.JsonIgnore;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.Date;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.fi.bd.model.common.BasePropModel;
import kd.fi.bd.model.common.IJsonArraySerialization;
import kd.fi.bd.util.data.IDataValueUtil;

public abstract class AbstractBaseModel<V1, V2, V3>
implements IJsonArraySerialization {
    private static final long serialVersionUID = 7006106276200369907L;
    @JSONField(serialize=false)
    @JsonIgnore
    protected V1 v1;
    @JSONField(serialize=false)
    @JsonIgnore
    protected V2 v2;
    @JSONField(serialize=false)
    @JsonIgnore
    protected V3 v3;

    public AbstractBaseModel() {
        this.initialization();
    }

    public AbstractBaseModel(Object[] v) {
        this.initialization();
        this.updateValueArray(v);
    }

    public AbstractBaseModel(V1 v1, V2 v2, V3 v3) {
        this.initialization();
        this.v1 = v1;
        this.v2 = v2;
        this.v3 = v3;
    }

    public AbstractBaseModel(JSONArray jsonArray) {
        this.initialization();
        this.initFromJsonArray(jsonArray);
    }

    private final void initialization() {
    }

    public void loadFromDynamicObject(DynamicObject sourceDynamicObject, boolean fetchBaseValue) {
        if (sourceDynamicObject != null) {
            if (fetchBaseValue) {
                this.fetchBaseValueFromDynamicObject(sourceDynamicObject);
            }
            this.fetchValueFromDynamicObject(sourceDynamicObject);
        }
    }

    public void loadFromDynamicObject(DynamicObject sourceDynamicObject) {
        this.loadFromDynamicObject(sourceDynamicObject, true);
    }

    protected void fetchBaseValueFromDynamicObject(DynamicObject sourceDynamicObject) {
    }

    protected void fetchValueFromDynamicObject(DynamicObject sourceDynamicObject) {
    }

    public DynamicObject writeValueIntoDynamicObject(DynamicObject sourceDynamicObject) {
        return sourceDynamicObject;
    }

    public String toString() {
        return "DataBaseModel [v1=" + this.v1 + ", v2=" + this.v2 + ", v3=" + this.v3 + "]";
    }

    protected void initFromJsonArray(JSONArray jsonArray) {
        if (jsonArray != null) {
            this.updateValueArray(jsonArray.toArray());
        }
    }

    @JSONField(serialize=false)
    @JsonIgnore
    public String getEntityTypeName() {
        return null;
    }

    @JSONField(serialize=false)
    @JsonIgnore
    public String[] getRequiredChildEntryNames() {
        return null;
    }

    protected <T extends AbstractBaseModel<V1, V2, V3>> void copyFrom(T source) {
        if (source != null) {
            this.v1 = source.v1;
            this.v2 = source.v2;
            this.v3 = source.v3;
        }
    }

    @JSONField(serialize=false)
    @JsonIgnore
    protected int getArraySize() {
        return 3 + this.serializedArrayStartPos();
    }

    protected Object[] appendSerializedArray(int startPos, Object[] targetArray) {
        if (this.v1 != null) {
            targetArray[startPos] = this.v1;
        }
        if (this.v2 != null) {
            targetArray[startPos + 1] = this.v2;
        }
        if (this.v3 != null) {
            targetArray[startPos + 2] = this.v3;
        }
        return targetArray;
    }

    protected abstract void updateValueArray(Object[] var1);

    @Override
    public Object[] getV() {
        return this.appendSerializedArray(this.serializedArrayStartPos(), new Object[this.getArraySize()]);
    }

    protected int serializedArrayStartPos() {
        return 0;
    }

    @Override
    public void setV(Object[] v) {
        if (v == null) {
            return;
        }
        if (v.length > this.getArraySize()) {
            throw new IllegalArgumentException(String.format("Expect %s Array Size:%s, but acutal size=%s", this.getClass().getName(), this.getArraySize(), v.length));
        }
        this.updateValueArray(v);
    }

    protected Long dumpDateValue(Date srcDate) {
        return IDataValueUtil.dumpDateValue(srcDate);
    }

    protected JSONObject toJSONObject(Object source) {
        return IDataValueUtil.toJSONObject(source);
    }

    protected JSONArray toJSONArray(Object source) {
        return IDataValueUtil.toJSONArray(source);
    }

    protected boolean parseFromJSONArray(JSONArray jsonArray, IJsonArraySerialization target) {
        return IDataValueUtil.parseFromJSONArray(jsonArray, target);
    }

    protected BasePropModel getBasePropModel(Object[] objectArray, int index) {
        return IDataValueUtil.getBasePropModel(objectArray, index);
    }

    protected <T> T getBasePropObject(Object[] objectArray, int index, Class<T> targetClassType) {
        return IDataValueUtil.getBasePropObject(objectArray, index, targetClassType);
    }

    protected JSONArray getJSONArray(Object[] objectArray, int index) {
        return IDataValueUtil.getJSONArray(objectArray, index);
    }

    protected <T> T[] getArrayObject(Object[] objectArray, int index, Class<T> targetClassType) {
        return IDataValueUtil.getArrayObject(objectArray, index, targetClassType);
    }

    protected <T> T[][] getArraysObject(Object[] objectArray, int index, Class<T> targetClassType) {
        return IDataValueUtil.getArraysObject(objectArray, index, targetClassType);
    }

    protected int[] getIntArray(Object[] objectArray, int index) {
        return IDataValueUtil.getIntArray(objectArray, index);
    }

    protected long[] getLongArray(Object[] objectArray, int index) {
        return IDataValueUtil.getLongArray(objectArray, index);
    }

    protected Boolean getBoolean(Object[] v, int index) {
        return IDataValueUtil.getBoolean(v, index);
    }

    protected Byte getByte(Object[] v, int index) {
        return IDataValueUtil.getByte(v, index);
    }

    protected String getString(Object[] v, int index) {
        return IDataValueUtil.getString(v, index);
    }

    protected BigDecimal getBigDecimal(Object[] v, int index) {
        return new BigDecimal(IDataValueUtil.getString(v, index));
    }

    protected BigInteger getBigInteger(Object[] v, int index) {
        return new BigInteger(IDataValueUtil.getString(v, index));
    }

    protected Date getDate(Object[] v, int index) {
        return IDataValueUtil.getDate(v, index);
    }

    protected Integer getInteger(Object[] v, int index) {
        return IDataValueUtil.getInteger(v, index);
    }

    protected Short getShort(Object[] v, int index) {
        return IDataValueUtil.getShort(v, index);
    }

    protected Long getLong(Object[] v, int index) {
        return IDataValueUtil.getLong(v, index);
    }

    protected Double getDouble(Object[] v, int index) {
        return IDataValueUtil.getDouble(v, index);
    }

    protected Float getFloat(Object[] v, int index) {
        return IDataValueUtil.getFloat(v, index);
    }

    protected boolean isPropertyExisted(DynamicObject sourceDyn, String propertyName) {
        return sourceDyn.getDataEntityType().getProperties().containsKey((Object)propertyName);
    }

    protected IDataEntityProperty getDataEntityProperty(DynamicObject sourceDyn, String propertyName) {
        return IDataValueUtil.getDataEntityProperty(sourceDyn, propertyName);
    }

    protected <T> T getDynPropValue(DynamicObject sourceDyn, String propertyName, Class<T> clazzType) {
        return IDataValueUtil.getDynPropValue(sourceDyn, propertyName, clazzType);
    }

    protected Long getLong(DynamicObject sourceDyn, String propertyName) {
        return IDataValueUtil.getDynPropValue(sourceDyn, propertyName, Long.class);
    }

    protected Double getDouble(DynamicObject sourceDyn, String propertyName) {
        return IDataValueUtil.getDynPropValue(sourceDyn, propertyName, Double.class);
    }

    protected Short getShort(DynamicObject sourceDyn, String propertyName) {
        return IDataValueUtil.getDynPropValue(sourceDyn, propertyName, Short.class);
    }

    protected Integer getInteger(DynamicObject sourceDyn, String propertyName) {
        return IDataValueUtil.getDynPropValue(sourceDyn, propertyName, Integer.class);
    }

    protected Byte getByte(DynamicObject sourceDyn, String propertyName) {
        return IDataValueUtil.getDynPropValue(sourceDyn, propertyName, Byte.class);
    }

    protected Date getDate(DynamicObject sourceDyn, String propertyName) {
        return IDataValueUtil.getDynPropValue(sourceDyn, propertyName, Date.class);
    }

    protected String getString(DynamicObject sourceDyn, String propertyName) {
        return IDataValueUtil.getDynPropValue(sourceDyn, propertyName, String.class);
    }

    protected DynamicObject getDynamicObject(DynamicObject sourceDyn, String propertyName) {
        return IDataValueUtil.getDynPropValue(sourceDyn, propertyName, DynamicObject.class);
    }

    protected DynamicObjectCollection getDynamicObjectCollection(DynamicObject sourceDyn, String propertyName) {
        return IDataValueUtil.getDynPropValue(sourceDyn, propertyName, DynamicObjectCollection.class);
    }

    protected <T> T getBasePropObject(DynamicObject sourceDynamicObject, String propertyName, Class<T> targetClass) {
        return IDataValueUtil.getBasePropObject(sourceDynamicObject, propertyName, targetClass);
    }

    protected Boolean getBoolean(DynamicObject sourceDyn, String propertyName) {
        return IDataValueUtil.getDynPropValue(sourceDyn, propertyName, Boolean.class);
    }

    protected Object getObject(DynamicObject sourceDyn, String propertyName) {
        return IDataValueUtil.getDynPropValue(sourceDyn, propertyName);
    }
}

