/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bd.model.indexing.context;

import java.io.Serializable;

public class QueryPageInfo
implements Serializable {
    private int displayPageSize;
    private long totalMatchCnt;
    private int currentPageIndex;

    public QueryPageInfo(int pageSize) {
        this.reset(pageSize);
    }

    public QueryPageInfo reset(int pageSize) {
        this.displayPageSize = pageSize;
        this.totalMatchCnt = 0L;
        this.currentPageIndex = 1;
        return this;
    }

    public int getDisplayPageSize() {
        return this.displayPageSize;
    }

    public int nextPage() {
        return ++this.currentPageIndex;
    }

    public int getAndMoveNextPage() {
        return this.currentPageIndex++;
    }

    public int prevPage() {
        return --this.currentPageIndex;
    }

    public synchronized long addMatchCnt(long newMatchCnt) {
        return this.totalMatchCnt += newMatchCnt;
    }

    public void setDisplayPageSize(int displayPageSize) {
        this.displayPageSize = displayPageSize;
    }

    public long getTotalMatchCnt() {
        return this.totalMatchCnt;
    }

    public void setTotalMatchCnt(long totalMatchCnt) {
        this.totalMatchCnt = totalMatchCnt;
    }

    public int getCurrentPageIndex() {
        return this.currentPageIndex;
    }

    public void setCurrentPageIndex(int currentPageIndex) {
        this.currentPageIndex = currentPageIndex;
    }

    public long getCurPageOffsetIndex() {
        return this.currentPageIndex * this.displayPageSize;
    }
}

