/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bd.model.indexing.context.es;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.BiFunction;
import java.util.function.Function;
import kd.bos.db.DBRoute;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.fulltext.FTCompare;
import kd.bos.fulltext.FTDataType;
import kd.bos.fulltext.FTFilter;
import kd.bos.fulltext.FTRowData;
import kd.bos.fulltext.FTValue;
import kd.bos.orm.query.QFilter;
import kd.fi.bd.indexing.constant.ESTextMatchModeEnum;
import kd.fi.bd.indexing.es.ElasticSearchHelper;
import kd.fi.bd.model.common.PairTuple;
import kd.fi.bd.model.indexing.IExIndexQueryResult;
import kd.fi.bd.model.indexing.context.QueryPageInfo;
import kd.fi.bd.util.data.IDataValueUtil;

public class ESIndexQueryTextContext<E, T extends IExIndexQueryResult>
implements Serializable {
    private boolean testESQueryExceedLimit = true;
    private String indexName;
    private DBRoute validateDBRoute;
    private String esQueryTarget;
    private List<String> esSelectedProps;
    private List<String> esSortProps;
    private Map<String, PairTuple<String, FTDataType>> qFilterToEsFilterMapping;
    private List<FTFilter> esQueryFilters;
    private Set<String> filterTexts;
    public static final int FINAL_QUERY_INFO = 0;
    public static final int ES_QUERY_INFO = 1;
    private QueryPageInfo[] queryInfos;
    private BiFunction<ESIndexQueryTextContext, List<E>, T> esQueryResultValidator;
    private T externalIndexQueryResult;
    private List<QFilter> originalFilters;
    private Function<List<FTRowData>, List<E>> esResultExtrator;
    private ESTextMatchModeEnum textMatchMode;
    private int pageSize;
    private int totalPageCnt;

    public ESIndexQueryTextContext(String indexName, String esQueryTarget, int pageSize, int totalPageCnt, ESTextMatchModeEnum textMatchMode, T externalIndexQueryResult) {
        this.pageSize = pageSize;
        this.totalPageCnt = totalPageCnt;
        this.queryInfos = new QueryPageInfo[2];
        for (int i = 0; i < this.queryInfos.length; ++i) {
            this.queryInfos[i] = new QueryPageInfo(pageSize);
        }
        this.indexName = indexName;
        this.esQueryTarget = esQueryTarget;
        this.textMatchMode = textMatchMode;
        this.validateDBRoute = DBRoute.of((String)EntityMetadataCache.getDataEntityType((String)esQueryTarget).getDBRouteKey());
        this.esSelectedProps = new LinkedList<String>();
        this.esQueryFilters = new LinkedList<FTFilter>();
        this.filterTexts = new LinkedHashSet<String>(1);
        this.qFilterToEsFilterMapping = new HashMap<String, PairTuple<String, FTDataType>>(2);
        this.externalIndexQueryResult = externalIndexQueryResult;
    }

    public ESIndexQueryTextContext reset(int pageSize) {
        for (QueryPageInfo queryPageInfo : this.queryInfos) {
            queryPageInfo.reset(pageSize);
        }
        this.esQueryFilters.clear();
        this.filterTexts.clear();
        this.qFilterToEsFilterMapping.clear();
        this.esSelectedProps.clear();
        return this;
    }

    public ESIndexQueryTextContext addQFilterToESFilterMapping(String qfilterPropName, String esFitlerPropName, FTDataType esPropType) {
        this.qFilterToEsFilterMapping.put(qfilterPropName, new PairTuple<String, FTDataType>(esFitlerPropName, esPropType));
        return this;
    }

    public ESIndexQueryTextContext addQFilterToESFilterMapping(String qfilterPropName, FTDataType esPropType) {
        return this.addQFilterToESFilterMapping(qfilterPropName, qfilterPropName, esPropType);
    }

    public List<FTFilter> addESFilters(Collection<QFilter> srcFilter) {
        List<FTFilter> esFilters = ElasticSearchHelper.convertQFilterToESFilter(this.textMatchMode, this.qFilterToEsFilterMapping, srcFilter);
        this.esQueryFilters.addAll(esFilters);
        return esFilters;
    }

    public List<FTFilter> addESFilters(QFilter ... srcFilter) {
        if (srcFilter == null || srcFilter.length <= 0) {
            return Collections.EMPTY_LIST;
        }
        return this.addESFilters(Arrays.asList(srcFilter));
    }

    public FTFilter addESFilter(String property, FTCompare cp, FTDataType dataType, Object ... values) {
        FTFilter esFilter = new FTFilter(property, cp, FTValue.normal((FTDataType)dataType, (Object[])values));
        this.esQueryFilters.add(esFilter);
        return esFilter;
    }

    public ESIndexQueryTextContext addESFilter(FTFilter esFilter) {
        this.esQueryFilters.add(esFilter);
        return this;
    }

    public ESIndexQueryTextContext addESFilterText(String filterText) {
        this.filterTexts.add(filterText);
        return this;
    }

    public QueryPageInfo getQueryPageInof(int queryInfoType) {
        return this.queryInfos[queryInfoType];
    }

    public FTFilter getSingleESQueryFilter() {
        FTFilter finalEsQueryFilter = null;
        for (FTFilter f : this.esQueryFilters) {
            if (finalEsQueryFilter == null) {
                finalEsQueryFilter = new FTFilter(f.getProperty(), f.getCp(), f.getValue());
                continue;
            }
            finalEsQueryFilter.and(f);
        }
        return finalEsQueryFilter;
    }

    public boolean addESSelectedProps(String ... esProps) {
        if (esProps == null || esProps.length <= 0) {
            return false;
        }
        this.esSelectedProps.addAll(Arrays.asList(esProps));
        return true;
    }

    public String buildESSelectString() {
        return IDataValueUtil.iteratorToString(this.esSelectedProps.iterator(), ",", null, true);
    }

    public String[] getESSortProps() {
        return this.esSortProps == null || this.esSortProps.isEmpty() ? null : this.esSortProps.toArray(new String[0]);
    }

    public ESIndexQueryTextContext<E, T> addSortProp(String ... sortProps) {
        if (sortProps != null && sortProps.length > 0) {
            if (this.esSortProps == null) {
                this.esSortProps = new LinkedList<String>();
            }
            this.esSortProps.addAll(Arrays.asList(sortProps));
        }
        return this;
    }

    public List<String> getEsSelectedProps() {
        return this.esSelectedProps;
    }

    public ESIndexQueryTextContext<E, T> setEsSelectedProps(List<String> esSelectedProps) {
        this.esSelectedProps = esSelectedProps;
        return this;
    }

    public String getIndexName() {
        return this.indexName;
    }

    public ESIndexQueryTextContext setIndexName(String indexName) {
        this.indexName = indexName;
        return this;
    }

    public String getEsQueryTarget() {
        return this.esQueryTarget;
    }

    public ESIndexQueryTextContext setEsQueryTarget(String esQueryTarget) {
        this.esQueryTarget = esQueryTarget;
        return this;
    }

    public Map<String, PairTuple<String, FTDataType>> getqFilterToEsFilterMapping() {
        return this.qFilterToEsFilterMapping;
    }

    public ESIndexQueryTextContext setqFilterToEsFilterMapping(Map<String, PairTuple<String, FTDataType>> qFilterToEsFilterMapping) {
        this.qFilterToEsFilterMapping = qFilterToEsFilterMapping;
        return this;
    }

    public QueryPageInfo[] getQueryInfos() {
        return this.queryInfos;
    }

    public void setQueryInfos(QueryPageInfo[] queryInfos) {
        this.queryInfos = queryInfos;
    }

    public BiFunction<ESIndexQueryTextContext, List<E>, T> getEsQueryResultValidator() {
        return this.esQueryResultValidator;
    }

    public DBRoute getValidateDBRoute() {
        return this.validateDBRoute;
    }

    public void setValidateDBRoute(DBRoute validateDBRoute) {
        this.validateDBRoute = validateDBRoute;
    }

    public ESIndexQueryTextContext setEsQueryResultValidator(BiFunction<ESIndexQueryTextContext, List<E>, T> esQueryResultValidator) {
        this.esQueryResultValidator = esQueryResultValidator;
        return this;
    }

    public T getExternalIndexQueryResult() {
        return this.externalIndexQueryResult;
    }

    public void setExternalIndexQueryResult(T externalIndexQueryResult) {
        this.externalIndexQueryResult = externalIndexQueryResult;
    }

    public Set<String> getFilterTexts() {
        return this.filterTexts;
    }

    public ESIndexQueryTextContext setFilterTexts(Set<String> filterTexts) {
        this.filterTexts = filterTexts;
        return this;
    }

    public List<FTFilter> getEsQueryFilters() {
        return this.esQueryFilters;
    }

    public void setEsQueryFilters(List<FTFilter> esQueryFilters) {
        this.esQueryFilters = esQueryFilters;
    }

    public Function<List<FTRowData>, List<E>> getEsResultExtrator() {
        return this.esResultExtrator;
    }

    public ESIndexQueryTextContext setEsResultExtrator(Function<List<FTRowData>, List<E>> esResultExtrator) {
        this.esResultExtrator = esResultExtrator;
        return this;
    }

    public List<QFilter> getOriginalFilters() {
        return this.originalFilters;
    }

    public ESIndexQueryTextContext setOriginalFilters(List<QFilter> originalFilters) {
        this.originalFilters = originalFilters;
        return this;
    }

    public ESTextMatchModeEnum getTextMatchMode() {
        return this.textMatchMode;
    }

    public boolean isTestESQueryExceedLimit() {
        return this.testESQueryExceedLimit;
    }

    public void setTestESQueryExceedLimit(boolean testESQueryExceedLimit) {
        this.testESQueryExceedLimit = testESQueryExceedLimit;
    }

    public int getPageSize() {
        return this.pageSize;
    }

    public void setPageSize(int pageSize) {
        this.pageSize = pageSize;
    }

    public int getTotalPageCnt() {
        return this.totalPageCnt;
    }

    public void setTotalPageCnt(int totalPageCnt) {
        this.totalPageCnt = totalPageCnt;
    }
}

