/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bd.model.indexing.context.es;

import java.io.Serializable;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import kd.bos.fulltext.BatchValue;
import kd.bos.fulltext.MatchProperty;
import kd.fi.bd.indexing.constant.ExIndexConstant;
import kd.fi.bd.indexing.es.FullTextSearchIndexMeta;

public class ESIndexRecordUploadContext
implements Serializable {
    private int batchSize;
    private int parallelCnt;
    private boolean forceDeleteBeforeUpload;
    private Collection<Throwable> exceptionList;
    private int totalUploadCnt;
    private Collection<BatchValue> srcData;
    private FullTextSearchIndexMeta indexMeta;
    private List<Object>[] processedPKs;

    public ESIndexRecordUploadContext(FullTextSearchIndexMeta indexMeta, Collection<BatchValue> srcData) {
        this(indexMeta, srcData, 5000, ExIndexConstant.ES_Query_Thread_Cnt, true);
    }

    public ESIndexRecordUploadContext(FullTextSearchIndexMeta indexMeta, Collection<BatchValue> srcData, int batchSize, int parallelCnt, boolean forceDeleteBeforeUpload) {
        this.indexMeta = indexMeta;
        this.indexMeta.refreashESConvertProps();
        this.batchSize = batchSize;
        this.parallelCnt = parallelCnt;
        this.forceDeleteBeforeUpload = forceDeleteBeforeUpload;
        this.exceptionList = new LinkedList<Throwable>();
        this.processedPKs = new LinkedList[2];
        for (int i = 0; i < this.processedPKs.length; ++i) {
            this.processedPKs[i] = new LinkedList<Object>();
        }
        if (srcData != null) {
            this.srcData = srcData;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addProcessedPks(Collection<Object> pks, boolean success) {
        ESIndexRecordUploadContext eSIndexRecordUploadContext = this;
        synchronized (eSIndexRecordUploadContext) {
            this.processedPKs[success ? 0 : 1].addAll(pks);
        }
    }

    public List<Object>[] getProcessedPKs() {
        return this.processedPKs;
    }

    public void setProcessedPKs(List<Object>[] processedPKs) {
        this.processedPKs = processedPKs;
    }

    public String getESQueryTargetName() {
        return this.indexMeta == null ? null : this.indexMeta.getQueryTarget();
    }

    public String getESIndexName() {
        return this.indexMeta == null ? null : this.indexMeta.getIndexName();
    }

    public int getBatchSize() {
        return this.batchSize;
    }

    public void setBatchSize(int batchSize) {
        this.batchSize = batchSize;
    }

    public int getParallelCnt() {
        return this.parallelCnt;
    }

    public void setParallelCnt(int parallelCnt) {
        this.parallelCnt = parallelCnt;
    }

    public boolean isForceDeleteBeforeUpload() {
        return this.forceDeleteBeforeUpload;
    }

    public void setForceDeleteBeforeUpload(boolean forceDeleteBeforeUpload) {
        this.forceDeleteBeforeUpload = forceDeleteBeforeUpload;
    }

    public boolean hasException() {
        return this.exceptionList != null && !this.exceptionList.isEmpty();
    }

    public Collection<Throwable> getExceptionList() {
        return this.exceptionList;
    }

    public void setExceptionList(Collection<Throwable> exceptionList) {
        this.exceptionList = exceptionList;
    }

    public int getTotalUploadCnt() {
        return this.totalUploadCnt;
    }

    public void setTotalUploadCnt(int totalUploadCnt) {
        this.totalUploadCnt = totalUploadCnt;
    }

    public FullTextSearchIndexMeta getIndexMeta() {
        return this.indexMeta;
    }

    public void setIndexMeta(FullTextSearchIndexMeta indexMeta) {
        this.indexMeta = indexMeta;
    }

    public Collection<BatchValue> getSrcData() {
        return this.srcData;
    }

    public void setSrcData(Collection<BatchValue> srcData) {
        this.srcData = srcData;
    }

    public MatchProperty[] getESConvertProp() {
        return this.indexMeta.refreashESConvertProps();
    }
}

