/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bd.model.indexing.es;

import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import kd.bos.orm.query.QFilter;
import kd.fi.bd.indexing.constant.RecordCheckStatus;
import kd.fi.bd.model.indexing.IExIndexQueryResult;
import kd.fi.bd.util.filter.QFilterBuilder;

public class ESVouDescIndexQueryResult
extends LinkedList<Long>
implements IExIndexQueryResult<Long> {
    private int actualMatchCnt = 0;
    private RecordCheckStatus recordCheckStatus;

    public ESVouDescIndexQueryResult(RecordCheckStatus recordCheckStatus) {
        this.recordCheckStatus = recordCheckStatus;
    }

    @Override
    public IExIndexQueryResult<Long> merge(IExIndexQueryResult<Long> srcResult) {
        if (srcResult instanceof ESVouDescIndexQueryResult) {
            this.addAll((ESVouDescIndexQueryResult)srcResult);
            this.actualMatchCnt += srcResult.getActualMatchCnt();
        }
        return this;
    }

    @Override
    public String toString() {
        return "ESVouDescIndexQueryResult{actualMatchCnt=" + this.actualMatchCnt + ", recordCheckStatus=" + (Object)((Object)this.recordCheckStatus) + ", Values=" + super.toString() + '}';
    }

    @Override
    public ESVouDescIndexQueryResult pack() {
        if (this.isEmpty()) {
            return this;
        }
        LinkedHashSet<Long> packList = new LinkedHashSet<Long>(this);
        this.clear();
        this.addAll(packList);
        return this;
    }

    @Override
    public void cleanResult() {
        super.clear();
        this.recordCheckStatus = RecordCheckStatus.UnCheck;
        this.actualMatchCnt = 0;
    }

    @Override
    public int getActualMatchCnt() {
        return this.actualMatchCnt;
    }

    @Override
    public int setActualMatchCnt(int actualMatchCnt) {
        this.actualMatchCnt = actualMatchCnt;
        return this.actualMatchCnt;
    }

    @Override
    public RecordCheckStatus getRecordCheckStatus() {
        return this.recordCheckStatus;
    }

    @Override
    public void setRecordCheckStatus(RecordCheckStatus recordCheckStatus) {
        this.recordCheckStatus = recordCheckStatus;
    }

    @Override
    public QFilter buildQFilter() {
        return QFilterBuilder.create("id", "in", new HashSet<Long>(this)).buildSingleFilter();
    }
}

