/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bd.model.muldims;

import java.util.Arrays;
import java.util.BitSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.Map;
import java.util.Set;
import java.util.function.Consumer;

public class AssisDimLookupGroup<V> {
    protected String wildcardDimKey;
    public static final int DefaultHashSize = 4;
    protected Map<String, Integer> dimNameIndexMap;
    protected Map<BitSet, AssisDimGroup<V>> dimGroups;

    public AssisDimLookupGroup(String wildcardDimKey, String ... dimNames) {
        this.wildcardDimKey = wildcardDimKey;
        this.dimNameIndexMap = new LinkedHashMap<String, Integer>(4);
        this.dimGroups = new HashMap<BitSet, AssisDimGroup<V>>(8);
        if (dimNames != null && dimNames.length > 0) {
            int i = 0;
            for (String dimName : dimNames) {
                this.dimNameIndexMap.put(dimName, i++);
            }
        }
    }

    public String toString() {
        return "AssisDimLookupGroup{wildcardDimKey='" + this.wildcardDimKey + '\'' + ", dimNameIndexMap=" + this.dimNameIndexMap + ", dimGroups=" + this.dimGroups + '}';
    }

    public void addAssisDimGroup(String[] rawDimKey, V value) {
        int dimIndex = 0;
        BitSet requiredDimBitset = new BitSet();
        int[] requiredDimIndexs = new int[rawDimKey.length];
        int i = 0;
        for (String dimKey : rawDimKey) {
            if (!this.wildcardDimKey.equals(dimKey)) {
                requiredDimBitset.set(dimIndex);
                requiredDimIndexs[i++] = dimIndex;
            }
            ++dimIndex;
        }
        requiredDimIndexs = Arrays.copyOf(requiredDimIndexs, i);
        this.dimGroups.computeIfAbsent(requiredDimBitset, k -> new AssisDimGroup((BitSet)k)).addMappingDimGroupInner(new AssisDimKey(rawDimKey, requiredDimIndexs), value);
    }

    public void foundMatchDimGroup(String[] rawDimKey, Consumer<Set<V>> matchValueConsumer) {
        this.foundMatchDimGroup(new AssisDimKey(rawDimKey), matchValueConsumer);
    }

    public void foundMatchDimGroup(AssisDimKey dimKey, Consumer<Set<V>> matchValueConsumer) {
        for (AssisDimGroup<V> dimGroup : this.dimGroups.values()) {
            dimGroup.foundMatchValues(dimKey.setUsedDimIndexs(dimGroup.requiredDimIndexs), matchValueConsumer);
        }
    }

    public Set<V> getMatchDimGroupValues(String[] rawDimKey, StringBuilder dimKeyOutputBuffer) {
        return this.getMatchDimGroupValues(new AssisDimKey(rawDimKey));
    }

    public Set<V> getMatchDimGroupValues(AssisDimKey dimKey) {
        HashSet result = new HashSet(4);
        this.foundMatchDimGroup(dimKey, (Set<V> rs) -> {
            if (rs != null) {
                result.addAll(rs);
            }
        });
        return result;
    }

    public static StringBuilder buildDimKey(String[] rawDimKey, BitSet requiredDimIndexs, StringBuilder output) {
        int setBitIndex = -1;
        output.setLength(0);
        while ((setBitIndex = requiredDimIndexs.nextSetBit(setBitIndex + 1)) >= 0) {
            output.append(rawDimKey[setBitIndex]).append('|');
        }
        return output;
    }

    public void clear() {
        this.dimNameIndexMap.clear();
        this.dimGroups.clear();
    }

    public static class AssisDimKey {
        protected int[] rawDimKeyHashCodes;
        protected String[] rawDimKeys;
        protected int[] usedDimIndexs;
        protected transient int _hashCodeCache = 0;

        protected AssisDimKey() {
        }

        public AssisDimKey(String[] rawDimKeys) {
            this.rawDimKeys = rawDimKeys;
            this.preGenRawDimKeyHashCode();
        }

        protected void preGenRawDimKeyHashCode() {
            int length = this.rawDimKeys.length;
            this.rawDimKeyHashCodes = new int[length];
            for (int i = 0; i < length; ++i) {
                this.rawDimKeyHashCodes[i] = this.rawDimKeys[i].hashCode();
            }
        }

        public AssisDimKey(String[] rawDimKeys, int[] usedDims) {
            this(rawDimKeys);
            this.usedDimIndexs = usedDims;
            this.pregenHashCode(usedDims);
        }

        public AssisDimKey setRawDimKeys(String[] rawDimKeys) {
            this.rawDimKeys = rawDimKeys;
            this.preGenRawDimKeyHashCode();
            return this;
        }

        public String toString() {
            return "AssisDimKey{rawDimKeyHashCodes=" + Arrays.toString(this.rawDimKeyHashCodes) + ", rawDimKeys=" + Arrays.toString(this.rawDimKeys) + ", usedDimIndexs=" + Arrays.toString(this.usedDimIndexs) + ", _hashCodeCache=" + this._hashCodeCache + '}';
        }

        public String[] getRawDimKeys() {
            return this.rawDimKeys;
        }

        public int[] getUsedDimIndexs() {
            return this.usedDimIndexs;
        }

        public AssisDimKey setUsedDimIndexs(int[] usedDimIndexs) {
            this.usedDimIndexs = usedDimIndexs;
            this.pregenHashCode(usedDimIndexs);
            return this;
        }

        protected void pregenHashCode(int[] usedDimIndexs) {
            this._hashCodeCache = 1;
            for (int setBitIndex : usedDimIndexs) {
                this._hashCodeCache = 31 * this._hashCodeCache + this.rawDimKeyHashCodes[setBitIndex];
            }
        }

        public int hashCode() {
            return this._hashCodeCache;
        }

        public boolean equals(Object targetDimKey) {
            if (!(targetDimKey instanceof AssisDimKey)) {
                return false;
            }
            String[] compareTarget = ((AssisDimKey)targetDimKey).rawDimKeys;
            if (compareTarget.length != this.rawDimKeys.length) {
                return false;
            }
            for (int setBitIndex : this.usedDimIndexs) {
                if (this.rawDimKeys[setBitIndex].equals(compareTarget[setBitIndex])) continue;
                return false;
            }
            return true;
        }
    }

    public static class AssisDimGroupKey {
        protected BitSet groupKey;
        protected int[] usedDimIndexs;
        protected transient int _hashCodeCache = 0;

        public AssisDimGroupKey(BitSet groupKey, int[] usedDimIndexs) {
            this.groupKey = groupKey;
            this.usedDimIndexs = usedDimIndexs;
        }

        public AssisDimGroupKey(BitSet groupKey, int usedDimCnt) {
            this.groupKey = groupKey;
            int i = -1;
            int index = 0;
            int[] usedDimIndexs = new int[usedDimCnt];
            while ((i = groupKey.nextSetBit(i)) >= 0) {
                usedDimIndexs[index++] = i;
            }
        }

        public int hashCode() {
            return this._hashCodeCache;
        }

        public int[] getUsedDimIndexs() {
            return this.usedDimIndexs;
        }

        public boolean equals(Object targetDimKey) {
            if (!(targetDimKey instanceof AssisDimGroupKey)) {
                return false;
            }
            return this.groupKey.equals(((AssisDimGroupKey)targetDimKey).groupKey);
        }
    }

    public static class AssisDimGroup<V> {
        protected int[] requiredDimIndexs;
        protected Map<AssisDimKey, Set<V>> dimIndexMap;

        public String toString() {
            return "AssisDimGroup{requiredDimIndexs=" + Arrays.toString(this.requiredDimIndexs) + ", dimIndexMap=" + this.dimIndexMap + '}';
        }

        public AssisDimGroup(int[] requiredDimIndexs) {
            this.requiredDimIndexs = requiredDimIndexs;
            this.dimIndexMap = new HashMap<AssisDimKey, Set<V>>(4);
        }

        public AssisDimGroup(BitSet requiredDimBitSet) {
            int dimIndex = -1;
            LinkedList<Integer> dimIndexBufList = new LinkedList<Integer>();
            while ((dimIndex = requiredDimBitSet.nextSetBit(dimIndex + 1)) >= 0) {
                dimIndexBufList.add(dimIndex);
            }
            this.requiredDimIndexs = new int[dimIndexBufList.size()];
            dimIndex = 0;
            for (Integer index : dimIndexBufList) {
                this.requiredDimIndexs[dimIndex++] = index;
            }
            this.dimIndexMap = new HashMap<AssisDimKey, Set<V>>(4);
        }

        public void addMappingDimGroup(String[] rawDimKey, V value) {
            this.dimIndexMap.computeIfAbsent(new AssisDimKey(rawDimKey, this.requiredDimIndexs), k -> new HashSet(4)).add(value);
        }

        protected void addMappingDimGroupInner(AssisDimKey dimGroupKey, V value) {
            this.dimIndexMap.computeIfAbsent(dimGroupKey, k -> new HashSet(4)).add(value);
        }

        public void clear() {
            this.dimIndexMap.clear();
        }

        public void foundMatchValues(String[] rawDimKey, Consumer<Set<V>> matchValueConsumer) {
            matchValueConsumer.accept(this.dimIndexMap.get(new AssisDimKey(rawDimKey, this.requiredDimIndexs)));
        }

        public void foundMatchValues(AssisDimKey rawDimKey, Consumer<Set<V>> matchValueConsumer) {
            matchValueConsumer.accept(this.dimIndexMap.get(rawDimKey));
        }

        public Set<V> getMatchValues(String[] rawDimKey) {
            return this.dimIndexMap.get(new AssisDimKey(rawDimKey));
        }

        public Set<V> getMatchValues(AssisDimKey rawDimKey) {
            return this.dimIndexMap.get(rawDimKey);
        }
    }
}

