/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bd.model.schema;

import java.util.HashMap;
import java.util.Map;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.fi.bd.model.schema.AbstractFormSchema;

public class SchemaFactory {
    private static final Log logger = LogFactory.getLog(SchemaFactory.class);
    private static final Map<String, AbstractFormSchema> INSTANCE_CACHE = new HashMap<String, AbstractFormSchema>();

    private static void loadSchemaClazz(String clazzTypeName) {
        try {
            Class.forName(clazzTypeName);
        }
        catch (ClassNotFoundException e) {
            logger.warn("not find class by " + clazzTypeName, (Throwable)e);
        }
    }

    protected static void cacheSchema(AbstractFormSchema schema, Boolean override) {
        if (override.booleanValue()) {
            INSTANCE_CACHE.put(schema.entity, schema);
        } else {
            INSTANCE_CACHE.putIfAbsent(schema.entity, schema);
        }
    }

    private static AbstractFormSchema get(String entity) {
        return INSTANCE_CACHE.get(entity);
    }
}

