/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bd.plugin;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.filter.AbstractFilterContantParser;
import kd.bos.entity.filter.FilterContantParserArgs;
import kd.bos.entity.filter.FilterRow;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDBizException;
import kd.bos.ext.fi.accountref.AccountBookInfo;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.fi.bd.enums.AccountBooksType;
import kd.fi.bd.plugin.CustomCompare;
import kd.fi.bd.util.BDUtil;
import kd.fi.bd.util.FibdApp;
import kd.fi.bd.util.PermissonType;
import kd.fi.bd.util.filter.QFilterBuilder;

public class CustomComparePlugin
extends AbstractFilterContantParser {
    private static final Predicate<String> isOrgFilterField = field -> field.startsWith("org.");
    private static final Predicate<String> isBookTypeFilterField = field -> field.startsWith("booktype.");
    private static final Log logger = LogFactory.getLog(CustomComparePlugin.class);

    protected QFilter getQFilter(FilterContantParserArgs parserArgs) {
        List<AccountBookInfo> accountBookInfos = this.extractBooksFromFilterArgs(parserArgs);
        if (accountBookInfos.isEmpty()) {
            logger.warn("---book not found, return false filter---");
            return QFilterBuilder.getVoidFilter();
        }
        CustomCompare compare = CustomCompare.fromComareTypeId(parserArgs.getFilterRow().getCompareType().getId());
        for (AccountBookInfo accountBookInfo : accountBookInfos) {
            accountBookInfo.setCurPeriodId(compare.getParseFunc().apply(accountBookInfo.getCurPeriodId()));
        }
        if (parserArgs.getMainEntityType().getProperties().containsKey((Object)"period")) {
            return this.parseFinalFilterByPeriod(accountBookInfos);
        }
        return this.parseFinalFilterByDate(accountBookInfos);
    }

    private QFilter parseFinalFilterByPeriod(List<AccountBookInfo> accountBookInfos) {
        Collection groupByPeriodIds = accountBookInfos.stream().collect(Collectors.groupingBy(AccountBookInfo::getPeriodTypeId, Collectors.mapping(AccountBookInfo::getCurPeriodId, Collectors.toSet()))).values();
        if (groupByPeriodIds.stream().anyMatch(periodIds -> periodIds.size() > 1)) {
            throw new KDBizException(PeriodParseErrorCode.periodNotUnique(), new Object[0]);
        }
        return new QFilter("period", "in", groupByPeriodIds.stream().flatMap(Collection::stream).collect(Collectors.toList()));
    }

    private QFilter parseFinalFilterByDate(List<AccountBookInfo> accountBookInfos) {
        Collection periodDyns = BusinessDataServiceHelper.loadFromCache((Object[])accountBookInfos.stream().map(AccountBookInfo::getCurPeriodId).distinct().toArray(), (DynamicObjectType)EntityMetadataCache.getSubDataEntityType((String)"bd_period", Arrays.asList("begindate", "enddate"))).values();
        if (periodDyns.isEmpty()) {
            return QFilterBuilder.getVoidFilter();
        }
        DynamicObject samplePeriodDyn = (DynamicObject)periodDyns.stream().iterator().next();
        if (periodDyns.stream().skip(1L).anyMatch(booDyn -> !this.isSameDatePeriod((DynamicObject)booDyn, samplePeriodDyn))) {
            throw new KDBizException(PeriodParseErrorCode.dateNotUnique(), new Object[0]);
        }
        return QFilter.of((String)"bookeddate >= ? and bookeddate <= ?", (Object[])new Object[]{samplePeriodDyn.getDate("begindate"), samplePeriodDyn.getDate("enddate")});
    }

    private List<AccountBookInfo> extractBooksFromFilterArgs(FilterContantParserArgs parserArgs) {
        QFilterBuilder qFilterBuilder = new QFilterBuilder().add(this.buildOrgQFilter(parserArgs)).add(this.buildBookTypeQFilter(parserArgs)).add("curperiod", "!=", 0L).addEqual("isbizunit", Boolean.TRUE);
        return QueryServiceHelper.query((String)"CustomComparePlugin#queryAccountBook", (String)"gl_accountbook", (String)String.join((CharSequence)",", "periodtype", "curperiod"), (QFilter[])qFilterBuilder.toArray(new QFilter[0]), null).stream().map(dyn -> {
            AccountBookInfo bookInfo = new AccountBookInfo();
            bookInfo.setPeriodtype(dyn.getLong("periodtype"));
            bookInfo.setCurPeriodId(dyn.getLong("curperiod"));
            return bookInfo;
        }).collect(Collectors.toList());
    }

    private QFilter buildOrgQFilter(FilterContantParserArgs filterContantParserArgs) {
        return filterContantParserArgs.getFilterRows().stream().filter(row -> isOrgFilterField.test(row.getFilterField().getFieldName())).map(row -> this.convertToAccountBookFilter((FilterRow)row, "org")).reduce((qf1, qf2) -> qf1.and(qf2)).orElseGet(() -> new QFilter("org", "in", BDUtil.getAcctOrgPkList(filterContantParserArgs.getMainEntityType().getName(), PermissonType.VIEW)));
    }

    private QFilter buildBookTypeQFilter(FilterContantParserArgs filterContantParserArgs) {
        return filterContantParserArgs.getFilterRows().stream().filter(row -> isBookTypeFilterField.test(row.getFilterField().getFieldName())).map(row -> this.convertToAccountBookFilter((FilterRow)row, "bookstype")).reduce((qf1, qf2) -> qf1.and(qf2)).orElseGet(() -> AccountBooksType.buildMainBookFilter("bookstype.accounttype"));
    }

    private QFilter convertToAccountBookFilter(FilterRow filterRow, String targetField) {
        QFilter filter = filterRow.getFilterResult().getQFilter();
        String suffix = filterRow.getFilterField().getFieldName().split("\\.", 2)[1];
        String finalFieldName = String.join((CharSequence)".", targetField, suffix);
        if (filter == null) {
            Class propertyType = filterRow.getFilterField().getFieldProp().getPropertyType();
            List valueToFilter = filterRow.getValue();
            if (propertyType.getTypeName().equals("long")) {
                valueToFilter = filterRow.getValue().stream().map(Long::parseLong).collect(Collectors.toList());
            }
            return new QFilter(finalFieldName, "in", (Object)valueToFilter);
        }
        return new QFilter(finalFieldName, filter.getCP(), filter.getValue());
    }

    private boolean isSameDatePeriod(DynamicObject periodA, DynamicObject periodB) {
        return Objects.equals(periodA.getDate("begindate"), periodB.getDate("begindate")) && Objects.equals(periodA.getDate("enddate"), periodB.getDate("enddate"));
    }

    protected String getScriptFilter(FilterContantParserArgs arg0) {
        return null;
    }

    private static class PeriodParseErrorCode {
        private PeriodParseErrorCode() {
        }

        private static ErrorCode periodNotUnique() {
            return PeriodParseErrorCode.create("periodNotUnique", ResManager.loadKDString((String)"\u6240\u9009\u7ec4\u7ec7\u5f53\u524d\u671f\u95f4\u4e0d\u4e00\u81f4\uff0c\u4e0d\u652f\u6301\u6309\u671f\u95f4\u67e5\u8be2\u6570\u636e\uff0c\u8bf7\u9009\u62e9\u65e5\u671f\u8303\u56f4\u8fdb\u884c\u67e5\u8be2\u6216\u8005\u53ea\u67e5\u8be2\u5f53\u524d\u671f\u95f4\u4e00\u81f4\u7684\u7ec4\u7ec7\u3002", (String)"PeriodParseErrorCode_1", (String)FibdApp.instance.commonModule(), (Object[])new Object[0]));
        }

        private static ErrorCode dateNotUnique() {
            return PeriodParseErrorCode.create("dateNotUnique", ResManager.loadKDString((String)"\u6240\u9009\u7ec4\u7ec7\u5f53\u524d\u671f\u95f4\u7684\u5f00\u59cb/\u7ed3\u675f\u65e5\u671f\u4e0d\u4e00\u81f4\uff0c\u4e0d\u652f\u6301\u6309\u671f\u95f4\u67e5\u8be2\u6570\u636e\uff0c\u8bf7\u9009\u62e9\u65e5\u671f\u8303\u56f4\u8fdb\u884c\u67e5\u8be2\u6216\u8005\u53ea\u67e5\u8be2\u5f53\u524d\u671f\u95f4\u4e00\u81f4\u7684\u7ec4\u7ec7\u3002", (String)"PeriodParseErrorCode_2", (String)FibdApp.instance.commonModule(), (Object[])new Object[0]));
        }

        private static ErrorCode create(String errorCode, String message) {
            return new ErrorCode("fi.fibd." + errorCode, message);
        }
    }
}

