/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bd.rate;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.Date;
import kd.fi.bd.rate.RateType;

public class ExchangeRate
implements Cloneable {
    private RateType rateType;
    private BigDecimal indirectRate;
    private BigDecimal directRate;
    private int precision = 8;
    private Date effectDate;

    public RateType getRateType() {
        if (this.rateType == null) {
            this.rateType = RateType.DIRECT_RATE;
        }
        return this.rateType;
    }

    public void setRateType(RateType rateType) {
        this.rateType = rateType;
    }

    public BigDecimal getIndirectRate() {
        return this.indirectRate;
    }

    public BigDecimal getIndirectRateNoPrecision() {
        return this.indirectRate;
    }

    public void setIndirectRate(BigDecimal indirectRate) {
        this.indirectRate = indirectRate;
    }

    public BigDecimal getDirectRate() {
        return this.directRate == null ? null : this.directRate.setScale(this.getPrecision(), RoundingMode.HALF_UP);
    }

    public BigDecimal getDirectRateNoPrecision() {
        return this.directRate;
    }

    public void setDirectRate(BigDecimal directRate) {
        this.directRate = directRate;
    }

    public int getPrecision() {
        return this.precision;
    }

    public void setPrecision(int precision) {
        this.precision = precision;
    }

    public Date getEffectDate() {
        return this.effectDate;
    }

    public void setEffectDate(Date effectDate) {
        this.effectDate = effectDate;
    }

    public BigDecimal getValue() {
        return Boolean.TRUE.equals(this.getRateType().getValue()) ? this.getIndirectRate() : this.getDirectRate();
    }

    public BigDecimal getValueNoPrecision() {
        return Boolean.TRUE.equals(this.getRateType().getValue()) ? this.getIndirectRateNoPrecision() : this.getDirectRateNoPrecision();
    }

    public Object clone() {
        try {
            return super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new RuntimeException(e);
        }
    }
}

